/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts;

import de.mennomax.astikorcarts.CommonInitializer;
import de.mennomax.astikorcarts.Initializer;
import de.mennomax.astikorcarts.client.ClientInitializer;
import de.mennomax.astikorcarts.entity.AnimalCartEntity;
import de.mennomax.astikorcarts.entity.PlowEntity;
import de.mennomax.astikorcarts.entity.PostilionEntity;
import de.mennomax.astikorcarts.entity.SupplyCartEntity;
import de.mennomax.astikorcarts.inventory.container.PlowContainer;
import de.mennomax.astikorcarts.item.CartItem;
import de.mennomax.astikorcarts.network.NetBuilder;
import de.mennomax.astikorcarts.network.clientbound.UpdateDrawnMessage;
import de.mennomax.astikorcarts.network.serverbound.ActionKeyMessage;
import de.mennomax.astikorcarts.network.serverbound.OpenSupplyCartMessage;
import de.mennomax.astikorcarts.network.serverbound.ToggleSlowMessage;
import de.mennomax.astikorcarts.server.ServerInitializer;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="astikorcarts")
public final class AstikorCarts {
    public static final String ID = "astikorcarts";
    public static final Logger LOGGER = LoggerFactory.getLogger(AstikorCarts.class);
    public static final SimpleChannel CHANNEL = new NetBuilder(new ResourceLocation("astikorcarts", "main")).version(1).optionalServer().requiredClient().serverbound(ActionKeyMessage::new).consumer(() -> ActionKeyMessage::handle).serverbound(ToggleSlowMessage::new).consumer(() -> ToggleSlowMessage::handle).clientbound(UpdateDrawnMessage::new).consumer(() -> new UpdateDrawnMessage.Handler()).serverbound(OpenSupplyCartMessage::new).consumer(() -> OpenSupplyCartMessage::handle).build();

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(ID, name.toLowerCase(Locale.ROOT));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(Items.ANIMAL_CART);
            event.accept(Items.SUPPLY_CART);
            event.accept(Items.PLOW);
            event.accept(Items.WHEEL);
        }
    }

    public AstikorCarts() {
        ClientModEvents.InitContext ctx = new ClientModEvents.InitContext();
        ((CommonInitializer)DistExecutor.runForDist(() -> ClientInitializer::new, () -> ServerInitializer::new)).init(ctx);
        ctx.modBus().addListener(EventPriority.NORMAL, this::setup);
        Items.R.register(ctx.modBus());
        EntityTypes.R.register(ctx.modBus());
        SoundEvents.SOUND_EVENTS.register(ctx.modBus());
        ContainerTypes.R.register(ctx.modBus());
        ACStats.AC_STATS.register(ctx.modBus());
        ctx.modBus().addListener(this::addCreative);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ACStats.initStats());
    }

    public static final class Items {
        private static final DeferredRegister<Item> R = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"astikorcarts");
        public static final RegistryObject<Item> WHEEL = R.register("wheel", () -> new Item(new Item.Properties()));
        public static final RegistryObject<Item> SUPPLY_CART;
        public static final RegistryObject<Item> PLOW;
        public static final RegistryObject<Item> ANIMAL_CART;

        static {
            Supplier<Item> cart = () -> new CartItem(new Item.Properties().m_41487_(1));
            SUPPLY_CART = R.register("supply_cart", cart);
            PLOW = R.register("plow", cart);
            ANIMAL_CART = R.register("animal_cart", cart);
        }
    }

    public static class ClientModEvents {

        private static class InitContext
        implements Initializer.Context {
            private InitContext() {
            }

            @Override
            public ModLoadingContext context() {
                return ModLoadingContext.get();
            }

            @Override
            public IEventBus bus() {
                return MinecraftForge.EVENT_BUS;
            }

            @Override
            public IEventBus modBus() {
                return FMLJavaModLoadingContext.get().getModEventBus();
            }
        }
    }

    public static final class EntityTypes {
        private static final DeferredRegister<EntityType<?>> R = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"astikorcarts");
        public static final RegistryObject<EntityType<SupplyCartEntity>> SUPPLY_CART = R.register("supply_cart", () -> EntityType.Builder.m_20704_(SupplyCartEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.5f, 1.4f).m_20712_("astikorcarts:supply_cart"));
        public static final RegistryObject<EntityType<PlowEntity>> PLOW = R.register("plow", () -> EntityType.Builder.m_20704_(PlowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.3f, 1.4f).m_20712_("astikorcarts:plow"));
        public static final RegistryObject<EntityType<AnimalCartEntity>> ANIMAL_CART = R.register("animal_cart", () -> EntityType.Builder.m_20704_(AnimalCartEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.3f, 1.4f).m_20712_("astikorcarts:animal_cart"));
        public static final RegistryObject<EntityType<PostilionEntity>> POSTILION = R.register("postilion", () -> EntityType.Builder.m_20704_(PostilionEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20698_().m_20716_().m_20712_("astikorcarts:postilion"));

        private EntityTypes() {
        }
    }

    public static final class SoundEvents {
        private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"astikorcarts");
        public static final RegistryObject<SoundEvent> CART_ATTACHED = SoundEvents.registerSoundEvent("entity.cart.attach");
        public static final RegistryObject<SoundEvent> CART_DETACHED = SoundEvents.registerSoundEvent("entity.cart.detach");
        public static final RegistryObject<SoundEvent> CART_PLACED = SoundEvents.registerSoundEvent("entity.cart.place");

        private static RegistryObject<SoundEvent> registerSoundEvent(String name) {
            ResourceLocation id = new ResourceLocation(AstikorCarts.ID, name);
            return SOUND_EVENTS.register(name, () -> SoundEvent.m_262824_((ResourceLocation)id));
        }
    }

    public static final class ContainerTypes {
        private static final DeferredRegister<MenuType<?>> R = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"astikorcarts");
        public static final RegistryObject<MenuType<PlowContainer>> PLOW_CART = R.register("plow", () -> IForgeMenuType.create(PlowContainer::new));

        private ContainerTypes() {
        }
    }

    public class ACStats {
        public static final DeferredRegister<ResourceLocation> AC_STATS = DeferredRegister.create((ResourceKey)Registries.f_256887_, (String)"astikorcarts");
        public static final RegistryObject<ResourceLocation> CART_ONE_CM = AC_STATS.register("cart_one_cm", () -> ACStats.makeStat("cart_one_cm"));

        private static ResourceLocation makeStat(String key) {
            return new ResourceLocation(AstikorCarts.ID, key);
        }

        public static void initStats() {
            Stats.f_12988_.m_12899_((Object)((ResourceLocation)CART_ONE_CM.get()), StatFormatter.f_12875_);
        }
    }
}

