/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.recipe;

import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.github.alexthe668.iwannaskate.server.recipe.RecipeSkateboard;
import com.github.alexthe668.iwannaskate.server.recipe.RecipeSkateboardBanner;
import com.github.alexthe668.iwannaskate.server.recipe.RecipeSkateboardDeck;
import com.github.alexthe668.iwannaskate.server.recipe.RecipeSkateboardGripTape;
import com.github.alexthe668.iwannaskate.server.recipe.RecipeSkateboardShimmer;
import com.github.alexthe668.iwannaskate.server.recipe.RecipeSkateboardSwapWheels;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class IWSRecipeRegistry {
    public static final DeferredRegister<RecipeSerializer<?>> DEF_REG = DeferredRegister.create((ResourceKey)Registries.f_256764_, (String)"iwannaskate");
    public static final RegistryObject<RecipeSerializer<?>> SKATEBOARD_DECK = DEF_REG.register("skateboard_deck", () -> new SimpleCraftingRecipeSerializer(RecipeSkateboardDeck::new));
    public static final RegistryObject<RecipeSerializer<?>> SKATEBOARD = DEF_REG.register("skateboard", () -> new SimpleCraftingRecipeSerializer(RecipeSkateboard::new));
    public static final RegistryObject<RecipeSerializer<?>> SKATEBOARD_BANNER = DEF_REG.register("skateboard_banner", () -> new SimpleCraftingRecipeSerializer(RecipeSkateboardBanner::new));
    public static final RegistryObject<RecipeSerializer<?>> SKATEBOARD_GRIP_TAPE = DEF_REG.register("skateboard_grip_tape", () -> new SimpleCraftingRecipeSerializer(RecipeSkateboardGripTape::new));
    public static final RegistryObject<RecipeSerializer<?>> SKATEBOARD_SHIMMER = DEF_REG.register("skateboard_shimmer", () -> new SimpleCraftingRecipeSerializer(RecipeSkateboardShimmer::new));
    public static final RegistryObject<RecipeSerializer<?>> SKATEBOARD_SWAP_WHEELS = DEF_REG.register("skateboard_swap_wheels", () -> new SimpleCraftingRecipeSerializer(RecipeSkateboardSwapWheels::new));

    public static void registerCauldronInteractions() {
        Map dyeToCarpet = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyeColor.class), map -> {
            map.put(DyeColor.WHITE, Blocks.f_50336_);
            map.put(DyeColor.ORANGE, Blocks.f_50337_);
            map.put(DyeColor.MAGENTA, Blocks.f_50338_);
            map.put(DyeColor.LIGHT_BLUE, Blocks.f_50339_);
            map.put(DyeColor.YELLOW, Blocks.f_50340_);
            map.put(DyeColor.LIME, Blocks.f_50341_);
            map.put(DyeColor.PINK, Blocks.f_50342_);
            map.put(DyeColor.GRAY, Blocks.f_50343_);
            map.put(DyeColor.LIGHT_GRAY, Blocks.f_50344_);
            map.put(DyeColor.CYAN, Blocks.f_50345_);
            map.put(DyeColor.PURPLE, Blocks.f_50346_);
            map.put(DyeColor.BLUE, Blocks.f_50347_);
            map.put(DyeColor.BROWN, Blocks.f_50348_);
            map.put(DyeColor.GREEN, Blocks.f_50349_);
            map.put(DyeColor.RED, Blocks.f_50350_);
            map.put(DyeColor.BLACK, Blocks.f_50351_);
        });
        CauldronInteraction.f_175607_.put((Item)IWSItemRegistry.SKATEBOARD.get(), (blockState, level, pos, player, hand, stack) -> {
            SkateboardData data = SkateboardData.fromStack(stack);
            boolean used = false;
            if (data.hasGripTape()) {
                used = true;
                DyeColor gripTapeColor = data.getGripTapeColor();
                ItemStack itemstack = new ItemStack((ItemLike)dyeToCarpet.get(gripTapeColor));
                if (!itemstack.m_41619_()) {
                    if (player.m_150109_().m_36054_(itemstack)) {
                        player.f_36095_.m_150429_();
                    } else {
                        player.m_36176_(itemstack, false);
                    }
                }
                data.removeGripTape();
            } else if (data.hasBanner()) {
                used = true;
                data.removeBanner();
            }
            if (used) {
                SkateboardData.setStackData(stack, data);
                LayeredCauldronBlock.m_153559_((BlockState)blockState, (Level)level, (BlockPos)pos);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        });
    }
}

