/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.item;

import com.github.alexthe668.iwannaskate.client.particle.IWSParticleRegistry;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.item.SkateboardWheelsItem;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public enum SkateboardWheels {
    DEFAULT,
    WHITE,
    ORANGE,
    MAGENTA,
    LIGHT_BLUE,
    YELLOW,
    LIME,
    PINK,
    GRAY,
    LIGHT_GRAY,
    CYAN,
    PURPLE,
    BLUE,
    BROWN,
    GREEN,
    RED,
    BLACK,
    ENDERPEARL(true),
    FLAME(true),
    SOUL_FLAME(true),
    RAINBOW(true),
    SPOOKY(false),
    SNOWY(false),
    SHOCKING(true),
    HONEY(true),
    AESTHETIC(true),
    HOVER(true),
    EMERALD(false);

    private final ResourceLocation texture = new ResourceLocation("iwannaskate", "textures/entity/skateboard/wheels/wheels_" + this.name().toLowerCase() + ".png");
    private final boolean isTrade;
    private RegistryObject<Item> itemRegistryObject;

    private SkateboardWheels() {
        this(false);
    }

    private SkateboardWheels(boolean isTrade) {
        this.isTrade = isTrade;
    }

    public static void init() {
        for (SkateboardWheels wheelType : SkateboardWheels.values()) {
            String id = wheelType == DEFAULT ? "skateboard_wheels" : "skateboard_wheels_" + wheelType.name().toLowerCase();
            wheelType.itemRegistryObject = IWSItemRegistry.DEF_REG.register(id, () -> new SkateboardWheelsItem(new Item.Properties(), wheelType));
        }
    }

    public static SkateboardWheels fromItem(Item item) {
        if (item instanceof SkateboardWheelsItem) {
            SkateboardWheelsItem wheelsItem = (SkateboardWheelsItem)item;
            return wheelsItem.getWheelType();
        }
        return DEFAULT;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public RegistryObject<Item> getItemRegistryObject() {
        return this.itemRegistryObject;
    }

    public boolean isTrade() {
        return this.isTrade;
    }

    @Nullable
    public ParticleOptions getWheelParticles() {
        if (this == FLAME) {
            return ParticleTypes.f_123744_;
        }
        if (this == SOUL_FLAME) {
            return ParticleTypes.f_123745_;
        }
        if (this == ENDERPEARL) {
            return ParticleTypes.f_123760_;
        }
        if (this == SPOOKY) {
            return (ParticleOptions)IWSParticleRegistry.HALLOWEEN.get();
        }
        if (this == SNOWY) {
            return ParticleTypes.f_175821_;
        }
        if (this == HONEY) {
            return (ParticleOptions)IWSParticleRegistry.BEE.get();
        }
        if (this == HOVER) {
            return (ParticleOptions)IWSParticleRegistry.HOVER.get();
        }
        if (this == EMERALD) {
            return (ParticleOptions)IWSParticleRegistry.SPARKLE.get();
        }
        return null;
    }

    public boolean hasTrail() {
        return this == RAINBOW || this == AESTHETIC;
    }

    public boolean isEmissive() {
        return this == FLAME || this == SOUL_FLAME || this == RAINBOW || this == AESTHETIC;
    }

    public float getParticleChancePerTick() {
        if (this == FLAME || this == SOUL_FLAME || this == ENDERPEARL) {
            return 0.3f;
        }
        if (this == SPOOKY || this == SNOWY) {
            return 0.1f;
        }
        if (this == HONEY) {
            return 0.03f;
        }
        if (this == HOVER) {
            return 1.0f;
        }
        if (this == EMERALD) {
            return 0.1f;
        }
        return 0.0f;
    }

    public boolean particleSpawnOverride(SkateboardEntity skateboard) {
        if (this == HOVER) {
            return skateboard.f_19797_ % 4 == 0;
        }
        return false;
    }

    public boolean hideTrucks() {
        return this == HOVER;
    }
}

