/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.mixin;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.server.entity.HasAnimationFlags;
import com.github.alexthe668.iwannaskate.server.entity.IWSEntityRegistry;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import com.github.alexthe668.iwannaskate.server.entity.WanderingSkaterEntity;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.misc.IWSAdvancements;
import com.github.alexthe668.iwannaskate.server.potion.IWSEffectRegistry;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager
implements HasAnimationFlags {
    private static final EntityDataAccessor<Integer> IWS_ANIMATION_FLAGS = SynchedEntityData.m_135353_(Villager.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int useEnergyDrinkTime = 0;
    private int skateNitwitTime = 0;

    @Shadow
    public abstract VillagerData m_7141_();

    @Shadow
    public abstract void m_34375_(VillagerData var1);

    public VillagerMixin(EntityType<? extends AbstractVillager> type, Level level) {
        super(type, level);
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/npc/Villager;defineSynchedData()V"})
    private void iws_registerData(CallbackInfo ci) {
        this.f_19804_.m_135372_(IWS_ANIMATION_FLAGS, (Object)0);
    }

    @Inject(method={"Lnet/minecraft/world/entity/npc/Villager;pickUpItem(Lnet/minecraft/world/entity/item/ItemEntity;)V"}, remap=true, at={@At(value="HEAD")}, cancellable=true)
    protected void iws_pickUpItem(ItemEntity item, CallbackInfo ci) {
        ItemStack stack = item.m_32055_();
        if (stack.m_150930_((Item)IWSItemRegistry.ENERGY_DRINK.get()) || stack.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) {
            if (this.m_21205_().m_41619_()) {
                Entity itemThrower = item.m_19749_();
                if (itemThrower instanceof Player) {
                    Player player = (Player)itemThrower;
                    if (!this.m_9236_().f_46443_) {
                        IWSAdvancements.trigger((Entity)player, IWSAdvancements.GIVE_VILLAGER_DRINK);
                    }
                }
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(1);
                this.m_21008_(InteractionHand.MAIN_HAND, copy);
                stack.m_41774_(1);
            }
            ci.cancel();
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/npc/Villager;wantsToPickUp(Lnet/minecraft/world/item/ItemStack;)Z"}, remap=true, at={@At(value="HEAD")}, cancellable=true)
    protected void iws_wantsToPickup(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (this.m_6162_() && stack.m_150930_((Item)IWSItemRegistry.ENERGY_DRINK.get()) && this.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && ((Boolean)IWannaSkateMod.COMMON_CONFIG.convertVillagersToNitwits.get()).booleanValue()) {
            cir.setReturnValue((Object)true);
        } else if (!this.m_6162_() && this.m_7141_().m_35571_() == VillagerProfession.f_35596_ && ((Boolean)IWannaSkateMod.COMMON_CONFIG.convertNitwitsToSkaters.get()).booleanValue() && stack.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/npc/Villager;tick()V"}, remap=true, at={@At(value="TAIL")})
    public void iws_tick(CallbackInfo ci) {
        ItemStack stack = this.m_21205_();
        int currentAnimFlag = 0;
        if (stack != null) {
            if (this.m_6162_() && stack.m_150930_((Item)IWSItemRegistry.ENERGY_DRINK.get()) && ((Boolean)IWannaSkateMod.COMMON_CONFIG.convertVillagersToNitwits.get()).booleanValue()) {
                if (this.useEnergyDrinkTime < 60) {
                    if (this.useEnergyDrinkTime % 5 == 0) {
                        this.m_5496_(stack.m_41615_(), 0.5f, this.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
                    }
                    currentAnimFlag = 1;
                    ++this.useEnergyDrinkTime;
                } else {
                    this.useEnergyDrinkTime = 0;
                    stack.m_41774_(1);
                    if (this.f_19796_.m_188499_()) {
                        this.m_34375_(this.m_7141_().m_35565_(VillagerProfession.f_35596_));
                        this.m_7292_(new MobEffectInstance((MobEffect)IWSEffectRegistry.OVERCAFFEINATED.get(), 1200));
                    }
                }
            }
            if (!this.m_6162_() && this.m_7141_().m_35571_() == VillagerProfession.f_35596_ && ((Boolean)IWannaSkateMod.COMMON_CONFIG.convertNitwitsToSkaters.get()).booleanValue()) {
                if (stack.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) {
                    SkateboardEntity spawnedBoard = (SkateboardEntity)((EntityType)IWSEntityRegistry.SKATEBOARD.get()).m_20615_(this.m_9236_());
                    spawnedBoard.setItemStack(stack.m_41777_());
                    spawnedBoard.m_146884_(this.m_20182_());
                    spawnedBoard.m_146922_(this.m_146908_());
                    spawnedBoard.setMobSpawned();
                    spawnedBoard.m_146926_(-70.0f);
                    if (this.m_9236_().m_7967_((Entity)spawnedBoard)) {
                        this.m_21011_(InteractionHand.OFF_HAND, true);
                        stack.m_41774_(1);
                    }
                    this.m_20329_(spawnedBoard);
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 300, 0));
                }
                if (this.m_20159_() && this.m_20202_() instanceof SkateboardEntity) {
                    ++this.skateNitwitTime;
                }
                if (this.skateNitwitTime > 300 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)((EntityType)IWSEntityRegistry.WANDERING_SKATER.get()), timer -> {
                    this.skateNitwitTime = timer;
                })) {
                    this.m_216990_(SoundEvents.f_12616_);
                    WanderingSkaterEntity wanderingSkaterEntity = (WanderingSkaterEntity)this.m_21406_((EntityType)IWSEntityRegistry.WANDERING_SKATER.get(), true);
                    wanderingSkaterEntity.setNoDespawn(true);
                    if (wanderingSkaterEntity != null) {
                        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)wanderingSkaterEntity);
                    }
                }
            }
        }
        this.setIWSAnimationFlags(currentAnimFlag);
    }

    @Override
    public int getIWSAnimationFlags() {
        return (Integer)this.f_19804_.m_135370_(IWS_ANIMATION_FLAGS);
    }

    public void setIWSAnimationFlags(int flags) {
        this.f_19804_.m_135381_(IWS_ANIMATION_FLAGS, (Object)flags);
    }
}

