/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.model;

import com.github.alexthe668.iwannaskate.server.entity.WanderingSkaterEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.VillagerHeadModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class WanderingSkaterModel
extends HierarchicalModel<WanderingSkaterEntity>
implements HeadedModel,
VillagerHeadModel {
    private final ModelPart head;
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart arms;
    private final ModelPart right_leg;
    private final ModelPart left_leg;

    public WanderingSkaterModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.arms = root.m_171324_("arms");
        this.right_leg = root.m_171324_("right_leg");
        this.left_leg = root.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition headwear = head.m_171599_("headwear", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headwear2 = head.m_171599_("headwear2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rotation = headwear2.m_171599_("rotation", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-4.0f, -4.0f, 0.0f, 8.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)5.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition arms = partdefinition.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)0.3f));
        PartDefinition arms_rotation = arms.m_171599_("arms_rotation", CubeListBuilder.m_171558_().m_171514_(16, 36).m_171488_(-8.0f, 0.0f, -1.05f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(32, 31).m_171488_(-4.0f, 4.0f, -1.05f, 8.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.05f, (float)-0.7505f, (float)0.0f, (float)0.0f));
        PartDefinition arms_flipped = arms_rotation.m_171599_("arms_flipped", CubeListBuilder.m_171558_().m_171514_(16, 36).m_171480_().m_171488_(4.0f, -24.0f, -1.05f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171488_(-2.0f, 1.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171480_().m_171488_(-2.0f, 1.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(WanderingSkaterEntity skater, float limbSwing, float limbSwingAmount, float ageInTicks, float rotY, float rotX) {
        float partialTick = ageInTicks - (float)skater.f_19797_;
        float attack = skater.getAttackingProgress(partialTick);
        this.root.f_104204_ = (float)((double)attack * Math.toRadians(Mth.m_14177_((float)skater.getAttackingAngle(partialTick))));
        limbSwing += attack * ageInTicks;
        limbSwingAmount = Math.max(attack, limbSwingAmount);
        boolean flag = skater.m_35303_() > 0;
        this.head.f_104204_ = rotY * ((float)Math.PI / 180);
        this.head.f_104203_ = rotX * ((float)Math.PI / 180);
        if (flag) {
            this.head.f_104205_ = 0.3f * Mth.m_14031_((float)(0.45f * ageInTicks));
            this.head.f_104203_ = 0.4f;
        } else {
            this.head.f_104205_ = 0.0f;
        }
        this.right_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.left_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.right_leg.f_104204_ = 0.0f;
        this.left_leg.f_104204_ = 0.0f;
    }

    public void translateToArms(PoseStack stack) {
        this.root.m_104299_(stack);
        this.body.m_104299_(stack);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_7491_(boolean p_104035_) {
    }
}

