/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.model;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.client.model.ModelPartWrapper;
import com.github.alexthe668.iwannaskate.client.model.ModelRootRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.world.entity.Entity;

public enum ModelPartType {
    BODY,
    HEAD,
    LEFT_ARM,
    RIGHT_ARM,
    LEFT_LEG,
    RIGHT_LEG;

    private static final ModelPartWrapper[] EMPTY;
    private static Map<EntityModel, ModelPartWrapper[]> DEFAULT_HUMAN_MAPPINGS;

    public ModelPartWrapper[] findIn(Entity entity, EntityModel model) {
        ModelRootRegistry.SkateModelParts partsFromJson;
        if (((Boolean)IWannaSkateMod.CLIENT_CONFIG.animateAllEntityModels.get()).booleanValue() && (partsFromJson = ModelRootRegistry.INSTANCE.getAnimationData(model, entity.m_6095_())) != null) {
            switch (this) {
                case BODY: {
                    return partsFromJson.body() != null ? partsFromJson.body() : EMPTY;
                }
                case HEAD: {
                    return partsFromJson.head() != null ? partsFromJson.head() : EMPTY;
                }
                case LEFT_LEG: {
                    return partsFromJson.leftLeg() != null ? partsFromJson.leftLeg() : EMPTY;
                }
                case RIGHT_LEG: {
                    return partsFromJson.rightLeg() != null ? partsFromJson.rightLeg() : EMPTY;
                }
                case LEFT_ARM: {
                    return partsFromJson.leftArm() != null ? partsFromJson.leftArm() : EMPTY;
                }
                case RIGHT_ARM: {
                    return partsFromJson.rightArm() != null ? partsFromJson.rightArm() : EMPTY;
                }
            }
        }
        ModelPartWrapper[] mappings = model instanceof PlayerModel ? this.findInDefaultPlayer((PlayerModel)model) : (model instanceof HumanoidModel ? this.findInDefaultHumanoid((HumanoidModel)model) : EMPTY);
        DEFAULT_HUMAN_MAPPINGS.put(model, mappings);
        return mappings;
    }

    private ModelPartWrapper[] findInDefaultHumanoid(HumanoidModel model) {
        switch (this) {
            case BODY: {
                return new ModelPartWrapper[]{new ModelPartWrapper(model.f_102810_)};
            }
            case HEAD: {
                return new ModelPartWrapper[]{new ModelPartWrapper(model.f_102808_), new ModelPartWrapper(model.f_102809_)};
            }
            case LEFT_LEG: {
                return new ModelPartWrapper[]{new ModelPartWrapper(model.f_102814_)};
            }
            case RIGHT_LEG: {
                return new ModelPartWrapper[]{new ModelPartWrapper(model.f_102813_)};
            }
            case LEFT_ARM: {
                return new ModelPartWrapper[]{new ModelPartWrapper(model.f_102812_)};
            }
            case RIGHT_ARM: {
                return new ModelPartWrapper[]{new ModelPartWrapper(model.f_102811_)};
            }
        }
        return EMPTY;
    }

    private ModelPartWrapper[] findInDefaultPlayer(PlayerModel model) {
        switch (this) {
            case BODY: {
                return new ModelPartWrapper[]{new ModelPartWrapper(model.f_102810_), new ModelPartWrapper(model.f_103378_)};
            }
            case HEAD: {
                return new ModelPartWrapper[]{new ModelPartWrapper(model.f_102808_), new ModelPartWrapper(model.f_102809_)};
            }
            case LEFT_LEG: {
                return new ModelPartWrapper[]{new ModelPartWrapper(model.f_102814_), new ModelPartWrapper(model.f_103376_)};
            }
            case RIGHT_LEG: {
                return new ModelPartWrapper[]{new ModelPartWrapper(model.f_102813_), new ModelPartWrapper(model.f_103377_)};
            }
            case LEFT_ARM: {
                return new ModelPartWrapper[]{new ModelPartWrapper(model.f_102812_), new ModelPartWrapper(model.f_103374_)};
            }
            case RIGHT_ARM: {
                return new ModelPartWrapper[]{new ModelPartWrapper(model.f_102811_), new ModelPartWrapper(model.f_103375_)};
            }
        }
        return EMPTY;
    }

    static {
        EMPTY = new ModelPartWrapper[]{new ModelPartWrapper()};
        DEFAULT_HUMAN_MAPPINGS = new HashMap<EntityModel, ModelPartWrapper[]>();
    }
}

