/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.color;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class DeckTexture
extends SimpleTexture {
    private int[] colors;
    private ResourceLocation[] textureLocs;
    private NativeImage coreImage;

    public DeckTexture(ResourceLocation[] textures, int[] colors) {
        super(textures[0]);
        this.textureLocs = textures;
        this.colors = colors;
    }

    public void m_6704_(ResourceManager resourceManager) throws IOException {
        for (int i = 0; i < this.textureLocs.length; ++i) {
            this.loadSimpleTexture(resourceManager, this.textureLocs[i], this.colors[i]);
        }
        if (this.coreImage != null) {
            TextureUtil.prepareImage((int)this.m_117963_(), (int)this.coreImage.m_84982_(), (int)this.coreImage.m_85084_());
            this.m_117966_();
            this.coreImage.m_85040_(0, 0, 0, false);
        }
    }

    private void loadSimpleTexture(ResourceManager resourceManager, ResourceLocation resourceLocation, int color) throws IOException {
        SimpleTexture.TextureImage simpletexture$textureimage = SimpleTexture.TextureImage.m_118155_((ResourceManager)resourceManager, (ResourceLocation)resourceLocation);
        simpletexture$textureimage.m_118159_();
        NativeImage nativeimage = simpletexture$textureimage.m_118158_();
        this.setColorOfImage(nativeimage, color);
        this.addImageToCore(nativeimage);
    }

    private void setColorOfImage(NativeImage nativeImage, int color) {
        for (int i = 0; i < nativeImage.m_84982_(); ++i) {
            for (int j = 0; j < nativeImage.m_85084_(); ++j) {
                int colorAt = nativeImage.m_84985_(i, j);
                int alpha = colorAt >> 24 & 0xFF;
                if (alpha != 255) continue;
                nativeImage.m_84988_(i, j, color);
            }
        }
    }

    private void addImageToCore(NativeImage nativeImage) {
        if (this.coreImage == null) {
            this.coreImage = new NativeImage(nativeImage.m_84982_(), nativeImage.m_85084_(), false);
        }
        for (int i = 0; i < nativeImage.m_84982_(); ++i) {
            for (int j = 0; j < nativeImage.m_85084_(); ++j) {
                int colorAt = nativeImage.m_84985_(i, j);
                int alpha = colorAt >> 24 & 0xFF;
                if (alpha == 0) continue;
                this.coreImage.m_84988_(i, j, colorAt);
            }
        }
    }

    public static ResourceLocation getOrCreateDeckTexture(ResourceLocation deckTexture, ResourceLocation[] textures, int[] colors) {
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        AbstractTexture abstracttexture = textureManager.m_174786_(deckTexture, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
        if (abstracttexture == MissingTextureAtlasSprite.m_118080_() && textures.length == colors.length) {
            textureManager.m_118495_(deckTexture, (AbstractTexture)new DeckTexture(textures, colors));
        }
        return deckTexture;
    }
}

