/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity;

import com.faboslav.friendsandfoes.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.util.client.PlayerProvider;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class PlayerIllusionEntity
extends Mob {
    private static final String TICKS_UNTIL_DESPAWN_NBT_NAME = "TicksUntilDespawn";
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_DESPAWN;
    private static final String PLAYER_UUID_NBT_NAME = "PlayerUuid";
    private static final EntityDataAccessor<Optional<UUID>> PLAYER_UUID;
    private static final EntityDataAccessor<Byte> PLAYER_MODEL_PARTS;
    @Nullable
    private Player player;
    @Nullable
    private PlayerInfo playerListEntry;
    public double prevCapeX;
    public double prevCapeY;
    public double prevCapeZ;
    public double capeX;
    public double capeY;
    public double capeZ;
    public float prevStrideDistance;
    public float strideDistance;

    public PlayerIllusionEntity(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PLAYER_MODEL_PARTS, (Object)0);
        this.f_19804_.m_135372_(TICKS_UNTIL_DESPAWN, (Object)0);
        this.f_19804_.m_135372_(PLAYER_UUID, Optional.empty());
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_(TICKS_UNTIL_DESPAWN_NBT_NAME, this.getTicksUntilDespawn());
        nbt.m_128362_(PLAYER_UUID_NBT_NAME, this.getPlayerUuid());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setPlayerUuid(nbt.m_128342_(PLAYER_UUID_NBT_NAME));
        this.setTicksUntilDespawn(nbt.m_128451_(TICKS_UNTIL_DESPAWN_NBT_NAME));
    }

    public boolean m_6149_() {
        return false;
    }

    protected boolean m_6125_() {
        return false;
    }

    public void m_8107_() {
        boolean isPlayerNonExistingOrDead;
        super.m_8107_();
        if (this.getTicksUntilDespawn() > 0) {
            this.setTicksUntilDespawn(this.getTicksUntilDespawn() - 1);
        }
        boolean bl = isPlayerNonExistingOrDead = this.getPlayer() != null && !this.getPlayer().m_6084_();
        if (this.getTicksUntilDespawn() == 0 || isPlayerNonExistingOrDead) {
            this.discardIllusion();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.discardIllusion();
        return true;
    }

    public boolean isPartVisible(PlayerModelPart modelPart) {
        return ((Byte)this.m_20088_().m_135370_(PLAYER_MODEL_PARTS) & modelPart.m_36445_()) == modelPart.m_36445_();
    }

    public boolean hasSkinTexture() {
        PlayerInfo playerListEntry = this.getPlayerListEntry();
        return playerListEntry != null && playerListEntry.m_105335_();
    }

    public ResourceLocation getSkinTexture() {
        PlayerInfo playerListEntry = this.getPlayerListEntry();
        UUID uuid = this.getPlayerUuid();
        if (uuid == null) {
            uuid = this.m_20148_();
        }
        return playerListEntry == null ? DefaultPlayerSkin.m_118627_((UUID)uuid) : playerListEntry.m_105337_();
    }

    public String getModel() {
        PlayerInfo playerListEntry = this.getPlayerListEntry();
        UUID uuid = this.getPlayerUuid();
        if (uuid == null) {
            uuid = this.m_20148_();
        }
        String model = playerListEntry == null ? DefaultPlayerSkin.m_118629_((UUID)uuid) : playerListEntry.m_105336_();
        return model;
    }

    @Nullable
    public ResourceLocation getCapeTexture() {
        PlayerInfo playerListEntry = this.getPlayerListEntry();
        return playerListEntry == null ? null : playerListEntry.m_105338_();
    }

    public boolean canRenderElytraTexture() {
        return this.getPlayerListEntry() != null;
    }

    @Nullable
    public ResourceLocation getElytraTexture() {
        PlayerInfo playerListEntry = this.getPlayerListEntry();
        return playerListEntry == null ? null : playerListEntry.m_105339_();
    }

    public boolean canRenderCapeTexture() {
        return this.getPlayerListEntry() != null;
    }

    @Nullable
    private PlayerInfo getPlayerListEntry() {
        if (this.playerListEntry == null) {
            UUID uuid = this.getPlayerUuid();
            if (uuid == null) {
                uuid = this.m_20148_();
            }
            this.playerListEntry = PlayerProvider.getClientPlayerListEntry(uuid);
        }
        return this.playerListEntry;
    }

    @Nullable
    public UUID getPlayerUuid() {
        return ((Optional)this.f_19804_.m_135370_(PLAYER_UUID)).orElse(null);
    }

    public void setPlayerUuid(UUID uuid) {
        this.f_19804_.m_135381_(PLAYER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public int getTicksUntilDespawn() {
        return (Integer)this.f_19804_.m_135370_(TICKS_UNTIL_DESPAWN);
    }

    public void setTicksUntilDespawn(int ticksUntilDespawn) {
        this.f_19804_.m_135381_(TICKS_UNTIL_DESPAWN, (Object)ticksUntilDespawn);
    }

    private void discardIllusion() {
        this.playMirrorSound();
        this.spawnCloudParticles();
        this.m_146870_();
    }

    private void playMirrorSound() {
        this.m_5496_(FriendsAndFoesSoundEvents.ENTITY_PLAYER_MIRROR_MOVE.get(), this.m_6121_(), this.m_6100_());
    }

    public boolean tryToTeleport(int x, int y, int z) {
        double bottomY = Math.max(y -= 8, this.m_9236_().m_141937_());
        double topY = Math.min(bottomY + 16.0, (double)(((ServerLevel)this.m_9236_()).m_143344_() - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = this.m_20984_(x, y = (int)Mth.m_14008_((double)(y + 1), (double)bottomY, (double)topY), z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    public void spawnCloudParticles() {
        this.spawnParticles(ParticleTypes.f_123796_, 16);
    }

    private void spawnParticles(SimpleParticleType particleType, int amount) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)this.m_20193_()).m_8767_((ParticleOptions)particleType, this.m_20208_(0.5), this.m_20187_() + 0.5, this.m_20262_(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    static {
        PLAYER_MODEL_PARTS = SynchedEntityData.m_135353_(PlayerIllusionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        TICKS_UNTIL_DESPAWN = SynchedEntityData.m_135353_(PlayerIllusionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        PLAYER_UUID = SynchedEntityData.m_135353_(PlayerIllusionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    }
}

