/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.entity;

import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.common.ai.GingyFollowOwnerGoal;
import net.mehvahdjukaar.snowyspirit.common.ai.GingySitWhenOrderedToGoal;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GingyEntity
extends AbstractGolem
implements OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(GingyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(GingyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Integer> DATA_COLOR_ID = SynchedEntityData.m_135353_(GingyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GingyEntity(EntityType<? extends AbstractGolem> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new GingySitWhenOrderedToGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new GingyFollowOwnerGoal(this, 1.0, 7.0f, 3.5f, false));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8, 1.0000001E-5f));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_COLOR_ID, (Object)DyeColor.WHITE.ordinal());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        DyeColor d = this.getColor();
        compound.m_128405_("Color", d.m_41060_());
        if (this.m_21805_() != null) {
            compound.m_128362_("Owner", this.m_21805_());
        }
        compound.m_128379_("Sitting", this.isOrderedToSit());
        BodyIntegrity bodyIntegrity = this.getBodyIntegrity();
        if (bodyIntegrity != BodyIntegrity.FULL) {
            compound.m_128405_("Bites", bodyIntegrity.ordinal());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            UUID uUID = compound.m_128342_("Owner");
            this.setOwnerUUID(uUID);
        }
        if (compound.m_128425_("Color", 99)) {
            this.setColor(DyeColor.m_41053_((int)compound.m_128451_("Color")));
        }
        this.setOrderedToSit(compound.m_128471_("Sitting"));
        if (compound.m_128425_("Bites", 99)) {
            this.setBodyIntegrity(BodyIntegrity.values()[compound.m_128451_("Bites")]);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setColor(DyeColor.values()[level.m_213780_().m_188503_(DyeColor.values().length)]);
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return super.m_6431_(pose, dimensions);
    }

    public boolean m_6126_() {
        return true;
    }

    public DyeColor getColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLOR_ID)));
    }

    public void setColor(DyeColor collarColor) {
        this.f_19804_.m_135381_(DATA_COLOR_ID, (Object)collarColor.m_41060_());
    }

    public boolean isForwardDeathAnim() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 0x80) >> 7 == 1;
    }

    public void setForwardDeathAnim(boolean forward) {
        byte b = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b & 0x7F | (forward ? 1 : 0) << 7)));
    }

    public BodyIntegrity getBodyIntegrity() {
        return BodyIntegrity.values()[((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 0xE) >> 1];
    }

    public boolean increaseIntegrity() {
        BodyIntegrity b = this.getBodyIntegrity();
        BodyIntegrity[] values = BodyIntegrity.values();
        int ind = b.ordinal();
        if (ind > 0) {
            this.setBodyIntegrity(values[ind - 1]);
            return true;
        }
        return false;
    }

    public boolean decreaseIntegrity() {
        BodyIntegrity b = this.getBodyIntegrity();
        BodyIntegrity[] values = BodyIntegrity.values();
        int ind = b.ordinal();
        if (ind < values.length - 1) {
            this.setBodyIntegrity(values[ind + 1]);
            return true;
        }
        return false;
    }

    public void setBodyIntegrity(BodyIntegrity bodyIntegrity) {
        byte b = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        int ind = bodyIntegrity.ordinal();
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b & 0xF1 | ind << 1)));
    }

    public boolean isOrderedToSit() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setOrderedToSit(boolean sitting) {
        byte b = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (sitting) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b & 0xFFFFFFFE)));
        }
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    public boolean m_6779_(LivingEntity target) {
        return !this.isOwnedBy(target) && super.m_6779_(target);
    }

    public boolean isOwnedBy(LivingEntity entity) {
        return entity == this.m_269323_();
    }

    public boolean m_7307_(Entity entity) {
        LivingEntity livingEntity = this.m_269323_();
        if (entity == livingEntity) {
            return true;
        }
        if (livingEntity != null) {
            return livingEntity.m_7307_(entity);
        }
        return super.m_7307_(entity);
    }

    public void m_6667_(DamageSource damageSource) {
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && this.m_269323_() instanceof ServerPlayer) {
            this.m_269323_().m_213846_(this.m_21231_().m_19293_());
        }
        super.m_6667_(damageSource);
    }

    protected int m_7302_(int currentAir) {
        return currentAir;
    }

    public boolean isFood(ItemStack stack) {
        return stack.m_150930_(ModRegistry.GINGERBREAD_COOKIE.get());
    }

    protected void usePlayerItem(Player player, InteractionHand hand, ItemStack stack) {
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        Level level = this.m_9236_();
        if (this.isOwnedBy((LivingEntity)player)) {
            if (item.m_41472_() && this.isFood(itemStack) && this.m_21223_() < this.m_21233_()) {
                this.usePlayerItem(player, hand, itemStack);
                this.m_5634_(item.m_41473_().m_38744_());
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (player.m_36341_()) {
                this.setOrderedToSit(!this.isOrderedToSit());
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        if (this.m_20206_() > 2.0f) {
            player.m_20329_((Entity)this);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (itemStack.m_150930_(Items.f_42455_)) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
                Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)itemStack, (ItemStack)Items.f_42455_.m_41469_().m_7968_());
            }
            this.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 900));
            if (player.m_7500_() || !this.m_20147_()) {
                Vec3 oldMov = this.m_20184_();
                this.m_6469_(this.m_269291_().m_269075_(player), Float.MAX_VALUE);
                this.m_20256_(oldMov);
                this.setForwardDeathAnim(true);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (itemStack.m_150930_(ModRegistry.GINGERBREAD_COOKIE.get())) {
            this.increaseIntegrity();
            this.m_5496_(ModRegistry.GINGERBREAD_BLOCK.get().m_49962_(ModRegistry.GINGERBREAD_BLOCK.get().m_49966_()).m_56777_(), 1.0f, 0.2f);
            itemStack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (player.m_36391_(player.m_7500_())) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                SnowySpirit.giveAdvancement(sp, "husbandry/eat_gingerbread_golem");
            }
            if (!this.decreaseIntegrity()) {
                this.m_146870_();
            }
            player.m_216990_(player.m_7866_(ModRegistry.GINGERBREAD_COOKIE.get().m_7968_()));
            player.m_36324_().m_38707_(1, 0.1f);
            level.m_142346_((Entity)player, GameEvent.f_157806_, this.m_20183_());
            for (int j = 0; j < 15; ++j) {
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ModRegistry.GINGERBREAD_FROSTED_BLOCK.get().m_49966_()), this.m_20208_(1.0), this.m_20187_() + 0.2, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        InteractionResult interactionResult = super.m_6071_(player, hand);
        if (interactionResult.m_19077_()) {
            this.m_21530_();
        }
        return interactionResult;
    }

    public int m_8085_() {
        return 30;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public static enum BodyIntegrity {
        FULL,
        NO_LEFT_HAND,
        NO_HANDS,
        NO_HEAD,
        NO_BODY;

    }
}

