/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.block;

import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.snowyspirit.common.entity.GolemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GumdropButton
extends DirectionalBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected static final VoxelShape DOWN_AABB = Block.m_49796_((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape UP_AABB = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)5.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)4.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)12.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)11.0);
    protected static final VoxelShape PRESSED_DOWN_AABB = Block.m_49796_((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape PRESSED_UP_AABB = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0);
    protected static final VoxelShape PRESSED_NORTH_AABB = Block.m_49796_((double)5.0, (double)5.0, (double)14.0, (double)11.0, (double)11.0, (double)16.0);
    protected static final VoxelShape PRESSED_SOUTH_AABB = Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)2.0);
    protected static final VoxelShape PRESSED_WEST_AABB = Block.m_49796_((double)14.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    protected static final VoxelShape PRESSED_EAST_AABB = Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)2.0, (double)11.0, (double)11.0);
    public final DyeColor color;

    public GumdropButton(DyeColor color) {
        super(BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_().m_284268_(color).m_60918_(SoundType.f_56750_).m_60910_());
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockPos relative = pos.m_7494_().m_121945_(((Direction)state.m_61143_((Property)f_52588_)).m_122424_());
        BlockState pumpkin = level.m_8055_(relative);
        if (pumpkin.m_60734_() instanceof CarvedPumpkinBlock) {
            GolemHelper.trySpawningGingy(pumpkin, (LevelAccessor)level, relative, (Entity)placer);
        }
        GolemHelper.trySpawningMongo(state, level, pos, (Entity)placer);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction dir = ((Direction)pState.m_61143_((Property)f_52588_)).m_122424_();
        BlockPos blockpos = pPos.m_121945_(dir);
        return GumdropButton.m_49863_((LevelReader)pLevel, (BlockPos)blockpos, (Direction)dir);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction = pContext.m_43719_();
        BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction);
        if (blockstate.m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_())) {
            return blockstate;
        }
        return null;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return ((Direction)pState.m_61143_((Property)f_52588_)).m_122424_() == pFacing && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    private int getPressDuration() {
        return 40;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        boolean powered = (Boolean)pState.m_61143_((Property)POWERED);
        return switch ((Direction)pState.m_61143_((Property)f_52588_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST -> {
                if (powered) {
                    yield PRESSED_EAST_AABB;
                }
                yield EAST_AABB;
            }
            case Direction.WEST -> {
                if (powered) {
                    yield PRESSED_WEST_AABB;
                }
                yield WEST_AABB;
            }
            case Direction.SOUTH -> {
                if (powered) {
                    yield PRESSED_SOUTH_AABB;
                }
                yield SOUTH_AABB;
            }
            case Direction.NORTH -> {
                if (powered) {
                    yield PRESSED_NORTH_AABB;
                }
                yield NORTH_AABB;
            }
            case Direction.DOWN -> {
                if (powered) {
                    yield PRESSED_DOWN_AABB;
                }
                yield DOWN_AABB;
            }
            case Direction.UP -> powered ? PRESSED_UP_AABB : UP_AABB;
        };
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        this.press(pState, pLevel, pPos);
        this.playSound(pPlayer, (LevelAccessor)pLevel, pPos, true);
        pLevel.m_142346_((Entity)pPlayer, GameEvent.f_223702_, pPos);
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public void press(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbours(pState, pLevel, pPos);
        pLevel.m_186460_(pPos, (Block)this, this.getPressDuration());
    }

    protected void playSound(@Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos, boolean pHitByArrow) {
        pLevel.m_5594_((Player)(pHitByArrow ? pPlayer : null), pPos, this.getSound(pHitByArrow), SoundSource.BLOCKS, 0.3f, pHitByArrow ? 0.6f : 0.5f);
    }

    protected SoundEvent getSound(boolean pIsOn) {
        return pIsOn ? SoundEvents.f_12389_ : SoundEvents.f_12393_;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pIsMoving && !pState.m_60713_(pNewState.m_60734_())) {
            if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
                this.updateNeighbours(pState, pLevel, pPos);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public int m_6378_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.m_61143_((Property)POWERED) != false && pBlockState.m_61143_((Property)f_52588_) == pSide ? 15 : 0;
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            this.checkPressed(pState, (Level)pLevel, pPos);
        }
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pLevel.f_46443_ && !((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            this.checkPressed(pState, pLevel, pPos);
        }
    }

    private void checkPressed(BlockState pState, Level pLevel, BlockPos pPos) {
        boolean flag1;
        List<Entity> list = pLevel.m_45976_(Entity.class, pState.m_60808_((BlockGetter)pLevel, pPos).m_83215_().m_82338_(pPos)).stream().filter(e -> e instanceof AbstractArrow || e instanceof LivingEntity).toList();
        boolean flag = !list.isEmpty();
        if (flag != (flag1 = ((Boolean)pState.m_61143_((Property)POWERED)).booleanValue())) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
            this.updateNeighbours(pState, pLevel, pPos);
            this.playSound(null, (LevelAccessor)pLevel, pPos, flag);
            pLevel.m_142346_((Entity)list.stream().findFirst().orElse(null), flag ? GameEvent.f_223702_ : GameEvent.f_223703_, pPos);
        }
        if (flag) {
            pLevel.m_186460_(new BlockPos((Vec3i)pPos), (Block)this, this.getPressDuration());
        }
    }

    private void updateNeighbours(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.m_46672_(pPos, (Block)this);
        pLevel.m_46672_(pPos.m_121945_(((Direction)pState.m_61143_((Property)f_52588_)).m_122424_()), (Block)this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_52588_, POWERED});
    }
}

