/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.datagen.recipes;

import com.google.gson.JsonObject;
import com.hlysine.create_connected.CreateConnected;
import com.hlysine.create_connected.config.FeatureToggle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class FeatureEnabledCondition
implements ICondition {
    private static final ResourceLocation NAME = CreateConnected.asResource("feature_enabled");
    private final ResourceLocation feature;
    private final boolean invert;

    public FeatureEnabledCondition(ResourceLocation feature, boolean invert) {
        this.feature = feature;
        this.invert = invert;
    }

    public FeatureEnabledCondition(ResourceLocation feature) {
        this(feature, false);
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return FeatureToggle.isEnabled(this.feature) != this.invert;
    }

    public static class Serializer
    implements IConditionSerializer<FeatureEnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, FeatureEnabledCondition value) {
            json.addProperty("feature", value.feature.toString());
            json.addProperty("invert", Boolean.valueOf(value.invert));
        }

        public FeatureEnabledCondition read(JsonObject json) {
            return new FeatureEnabledCondition(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"feature")), GsonHelper.m_13912_((JsonObject)json, (String)"invert"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

