/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.datagen.advancements;

import com.hlysine.create_connected.datagen.advancements.Awardable;
import com.hlysine.create_connected.datagen.advancements.CCAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;

public class AdvancementBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<AdvancementBehaviour> TYPE = new BehaviourType();
    private UUID playerId;
    private final Set<Awardable> advancements = new HashSet<Awardable>();

    public AdvancementBehaviour(SmartBlockEntity be, Awardable ... advancements) {
        super(be);
        this.add(advancements);
    }

    public void add(Awardable ... advancements) {
        this.advancements.addAll(Arrays.asList(advancements));
    }

    public boolean isOwnerPresent() {
        return this.playerId != null;
    }

    public void setOwner(UUID id) {
        Player player = this.getWorld().m_46003_(id);
        if (player == null) {
            return;
        }
        this.playerId = id;
        this.removeAwarded();
        this.blockEntity.m_6596_();
    }

    public void initialize() {
        super.initialize();
        this.removeAwarded();
    }

    private void removeAwarded() {
        Player player = this.getOwner();
        if (player == null) {
            return;
        }
        this.advancements.removeIf(c -> c.isAlreadyAwardedTo(player));
        if (this.advancements.isEmpty()) {
            this.playerId = null;
            this.blockEntity.m_6596_();
        }
    }

    public void awardOwnerIfNear(Awardable advancement, int maxDistance) {
        Player player = this.getOwner();
        if (player == null) {
            return;
        }
        if (player.m_20238_(Vec3.m_82512_((Vec3i)this.getPos())) > (double)(maxDistance * maxDistance)) {
            return;
        }
        this.award(advancement, player);
    }

    public void awardOwner(Awardable advancement) {
        Player player = this.getOwner();
        if (player == null) {
            return;
        }
        this.award(advancement, player);
    }

    private void award(Awardable advancement, Player player) {
        if (this.advancements.contains(advancement)) {
            advancement.awardTo(player);
        }
        this.removeAwarded();
    }

    private Player getOwner() {
        if (this.playerId == null) {
            return null;
        }
        return this.getWorld().m_46003_(this.playerId);
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.playerId != null) {
            nbt.m_128362_("Owner", this.playerId);
        }
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (nbt.m_128441_("Owner")) {
            this.playerId = nbt.m_128342_("Owner");
        }
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public static void tryAward(BlockGetter reader, BlockPos pos, Awardable advancement) {
        AdvancementBehaviour behaviour = (AdvancementBehaviour)BlockEntityBehaviour.get((BlockGetter)reader, (BlockPos)pos, TYPE);
        if (behaviour != null) {
            behaviour.awardOwner(advancement);
        }
    }

    public static void tryAward(BlockEntity be, Awardable advancement) {
        AdvancementBehaviour behaviour = (AdvancementBehaviour)BlockEntityBehaviour.get((BlockEntity)be, TYPE);
        if (behaviour != null) {
            behaviour.awardOwner(advancement);
        }
    }

    public static void trackOwner(Level worldIn, BlockPos pos, LivingEntity placer) {
        AdvancementBehaviour behaviour = (AdvancementBehaviour)BlockEntityBehaviour.get((BlockGetter)worldIn, (BlockPos)pos, TYPE);
        if (behaviour == null) {
            return;
        }
        if (placer instanceof FakePlayer) {
            return;
        }
        if (placer instanceof ServerPlayer) {
            behaviour.setOwner(placer.m_20148_());
        }
    }

    public static void registerAwardables(SmartBlockEntity be, List<BlockEntityBehaviour> behaviours, CCAdvancement ... advancements) {
        for (BlockEntityBehaviour behaviour : behaviours) {
            if (!(behaviour instanceof AdvancementBehaviour)) continue;
            AdvancementBehaviour ab = (AdvancementBehaviour)behaviour;
            ab.add(advancements);
            return;
        }
        behaviours.add(new AdvancementBehaviour(be, advancements));
    }
}

