/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.copycat;

import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.CCShapes;
import com.simibubi.create.content.decoration.copycat.WaterloggedCopycatBlock;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PoleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CopycatVerticalStepBlock
extends WaterloggedCopycatBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    private static final Map<Pair<Integer, Integer>, Direction> VERTICAL_POSITION_MAP = new HashMap<Pair<Integer, Integer>, Direction>();
    private static final Map<Pair<Direction, Integer>, Direction> HORIZONTAL_POSITION_MAP = new HashMap<Pair<Direction, Integer>, Direction>();

    public CopycatVerticalStepBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (!player.m_6144_() && player.m_36326_()) {
            ItemStack heldItem = player.m_21120_(hand);
            IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
            if (placementHelper.matchesItem(heldItem)) {
                placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, ray);
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState toState = reader.m_8055_(toPos);
        if (toState.m_60713_((Block)this)) {
            return toState.m_61143_((Property)FACING) != direction;
        }
        return true;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState toState = reader.m_8055_(toPos);
        BlockPos diff = toPos.m_121996_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return true;
        }
        Direction face = Direction.m_122378_((int)diff.m_123341_(), (int)diff.m_123342_(), (int)diff.m_123343_());
        if (face == null) {
            return false;
        }
        if (toState.m_60713_((Block)this)) {
            return toState.m_61143_((Property)FACING) == facing && face.m_122434_() == Direction.Axis.Y;
        }
        return false;
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return face.m_122434_() == Direction.Axis.Y || face == facing || face == facing.m_122428_();
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return !this.canFaceBeOccluded(state, face);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        int zOffset;
        BlockState stateForPlacement = super.m_5573_(context);
        assert (stateForPlacement != null);
        int xOffset = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_() > 0.5 ? 1 : -1;
        int n = zOffset = context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_() > 0.5 ? 1 : -1;
        if (context.m_43719_().m_122434_() == Direction.Axis.Y) {
            return (BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)VERTICAL_POSITION_MAP.get(Pair.of((Object)xOffset, (Object)zOffset)));
        }
        return (BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)HORIZONTAL_POSITION_MAP.get(Pair.of((Object)context.m_43719_(), (Object)(context.m_43719_().m_122434_() == Direction.Axis.X ? zOffset : xOffset))));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{FACING}));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return CCShapes.CASING_8PX_VERTICAL.get((Direction)pState.m_61143_((Property)FACING));
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if (state.m_60713_((Block)this) == neighborState.m_60713_((Block)this) && CopycatVerticalStepBlock.getMaterial((BlockGetter)level, (BlockPos)pos).m_60719_(CopycatVerticalStepBlock.getMaterial((BlockGetter)level, (BlockPos)pos.m_121945_(dir)), dir.m_122424_())) {
            return dir.m_122434_().m_122478_() && neighborState.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
        }
        return false;
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState pState, @NotNull Mirror pMirror) {
        Direction.Axis mirrorAxis = null;
        for (Direction.Axis axis : Iterate.axes) {
            if (!pMirror.m_54842_().m_56526_(axis)) continue;
            mirrorAxis = axis;
            break;
        }
        if (mirrorAxis == null || mirrorAxis.m_122478_()) {
            return super.m_6943_(pState, pMirror);
        }
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        if (facing.m_122434_() != mirrorAxis) {
            return (BlockState)pState.m_61124_((Property)FACING, (Comparable)facing.m_122427_());
        }
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)facing.m_122428_());
    }

    static {
        for (Direction main : Iterate.horizontalDirections) {
            Direction cross = main.m_122428_();
            int mainOffset = main.m_122421_().m_122540_();
            int crossOffset = cross.m_122421_().m_122540_();
            if (main.m_122434_() == Direction.Axis.X) {
                VERTICAL_POSITION_MAP.put((Pair<Integer, Integer>)Pair.of((Object)mainOffset, (Object)crossOffset), main);
            } else {
                VERTICAL_POSITION_MAP.put((Pair<Integer, Integer>)Pair.of((Object)crossOffset, (Object)mainOffset), main);
            }
            HORIZONTAL_POSITION_MAP.put((Pair<Direction, Integer>)Pair.of((Object)main.m_122424_(), (Object)crossOffset), main);
            HORIZONTAL_POSITION_MAP.put((Pair<Direction, Integer>)Pair.of((Object)cross.m_122424_(), (Object)mainOffset), main);
        }
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction> {
        private PlacementHelper() {
            super(arg_0 -> CCBlocks.COPYCAT_VERTICAL_STEP.has(arg_0), $ -> Direction.Axis.Y, (Property)FACING);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof CopycatVerticalStepBlock;
        }
    }
}

