/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.entity.PhotographEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;

public class PhotographEntityRenderer<T extends PhotographEntity>
extends EntityRenderer<T> {
    public PhotographEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T pEntity) {
        return InventoryMenu.f_39692_;
    }

    public boolean shouldRender(T livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return super.m_5523_(livingEntity, camera, camX, camY, camZ);
    }

    public void render(@NotNull T entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        Either<String, ResourceLocation> idOrTexture;
        int brightness;
        super.m_7392_(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        boolean invisible = entity.m_20145_();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252529_.m_252977_(entity.m_146909_()));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entity.m_146908_()));
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)((PhotographEntity)((Object)entity)).getRotation() * 360.0f / 4.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_85837_(-0.5, -0.5, 0.02625);
        float scale = 0.00390625f;
        poseStack.m_85841_(scale, scale, -scale);
        switch (entity.m_6350_()) {
            case DOWN: {
                int n = 210;
                break;
            }
            case UP: {
                int n = 255;
                break;
            }
            default: {
                int n = brightness = 235;
            }
        }
        if (((PhotographEntity)((Object)entity)).isGlowing()) {
            packedLight = 0xF000F0;
        }
        if ((idOrTexture = ((PhotographEntity)((Object)entity)).getIdOrTexture()) != null) {
            if (invisible) {
                ExposureClient.getExposureRenderer().renderSimple(idOrTexture, false, false, poseStack, bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, brightness, brightness, brightness, 255);
            } else {
                ExposureClient.getExposureRenderer().renderOnPaper(idOrTexture, poseStack, bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, brightness, brightness, brightness, 255, false);
            }
        } else if (!invisible) {
            ExposureClient.getExposureRenderer().renderPaperTexture(poseStack, bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, brightness, brightness, brightness, 255);
        }
        poseStack.m_85849_();
    }
}

