/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.item.PhotographItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemFramePhotographRenderer {
    public static boolean render(ItemFrame itemFrameEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        ItemStack itemStack = itemFrameEntity.m_31822_();
        Item item = itemStack.m_41720_();
        if (!(item instanceof PhotographItem)) {
            return false;
        }
        PhotographItem photographItem = (PhotographItem)item;
        @Nullable Either<String, ResourceLocation> idOrTexture = photographItem.getIdOrTexture(itemStack);
        if (idOrTexture == null) {
            return false;
        }
        if (itemFrameEntity.m_6095_() == EntityType.f_147033_) {
            packedLight = 0xF000F0;
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(45 * itemFrameEntity.m_31823_())));
        float size = 256.0f;
        float scale = 1.0f / size;
        float pixelScale = scale / 16.0f;
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_85841_(scale -= pixelScale * 6.0f, scale, scale);
        poseStack.m_252880_(-size / 2.0f, -size / 2.0f, 10.0f);
        ExposureClient.getExposureRenderer().renderSimple(idOrTexture, false, false, poseStack, bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, 255, 255, 255, 255);
        poseStack.m_85849_();
        return true;
    }
}

