/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.render.ExposureImage;
import io.github.mortuusars.exposure.render.ExposureTexture;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ExposureRenderer
implements AutoCloseable {
    public static final ResourceLocation PHOTOGRAPH_TEXTURE = Exposure.resource("textures/block/photograph.png");
    public static final int SIZE = 256;
    private final Map<String, ExposureInstance> cache = new HashMap<String, ExposureInstance>();

    public void renderSimple(@NotNull Either<String, ResourceLocation> idOrTexture, PoseStack poseStack, float x, float y, float width, float height) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        this.renderSimple(idOrTexture, false, false, poseStack, (MultiBufferSource)bufferSource, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, 255, 255, 255, 255);
        bufferSource.m_109911_();
    }

    public void renderSimple(@NotNull Either<String, ResourceLocation> idOrTexture, boolean negative, boolean simulateFilm, PoseStack poseStack, MultiBufferSource bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a) {
        @Nullable ExposureImage exposure = (ExposureImage)idOrTexture.map(id -> ExposureClient.getExposureStorage().getOrQuery((String)id).map(data -> new ExposureImage((String)id, (ExposureSavedData)((Object)((Object)data)))).orElse(null), texture -> {
            @Nullable ExposureTexture exposureTexture = ExposureTexture.getTexture(texture);
            if (exposureTexture != null) {
                return new ExposureImage(texture.toString(), exposureTexture);
            }
            return null;
        });
        if (exposure != null) {
            String id2 = (String)idOrTexture.map(expId -> expId, ResourceLocation::toString);
            this.getOrCreateExposureInstance(id2, exposure, negative, simulateFilm).draw(poseStack, bufferSource, minX, minY, maxX, maxY, minU, minV, maxU, maxV, packedLight, r, g, b, a);
        }
    }

    public void renderOnPaper(@NotNull Either<String, ResourceLocation> idOrTexture, PoseStack poseStack, MultiBufferSource bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a, boolean renderBackside) {
        this.renderPaperTexture(poseStack, bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, r, g, b, a);
        if (renderBackside) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            poseStack.m_85837_(-256.0, 0.0, -0.5);
            ExposureRenderer.renderTexture(PHOTOGRAPH_TEXTURE, poseStack, bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 1.0f, 0.0f, 0.0f, 1.0f, packedLight, (int)((float)r * 0.85f), (int)((float)g * 0.85f), (int)((float)b * 0.85f), a);
            poseStack.m_85849_();
        }
        poseStack.m_85836_();
        float offset = 16.0f;
        poseStack.m_252880_(offset, offset, 1.0f);
        poseStack.m_85841_(0.875f, 0.875f, 0.875f);
        this.renderSimple(idOrTexture, false, false, poseStack, bufferSource, minX, minY, maxX, maxY, minU, minV, maxU, maxV, packedLight, r, g, b, a);
        poseStack.m_85849_();
    }

    public void renderPaperTexture(PoseStack poseStack, MultiBufferSource bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a) {
        ExposureRenderer.renderTexture(PHOTOGRAPH_TEXTURE, poseStack, bufferSource, minX, minY, maxX, maxY, minU, minV, maxU, maxV, packedLight, r, g, b, a);
    }

    private static void renderTexture(ResourceLocation resource, PoseStack poseStack, MultiBufferSource bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resource);
        RenderSystem.setShader(GameRenderer::m_172835_);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        VertexConsumer bufferBuilder = bufferSource.m_6299_(RenderType.m_110497_((ResourceLocation)resource));
        bufferBuilder.m_252986_(matrix, minX, maxY, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_85969_(packedLight).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, maxY, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(packedLight).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, minY, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_85969_(packedLight).m_5752_();
        bufferBuilder.m_252986_(matrix, minX, minY, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, minV).m_85969_(packedLight).m_5752_();
    }

    private ExposureInstance getOrCreateExposureInstance(String id, ExposureImage exposure, boolean negative, boolean simulateFilm) {
        String instanceId = id + (negative ? "_negative" : "") + (simulateFilm ? "_film" : "");
        return this.cache.compute(instanceId, (expId, expData) -> {
            if (expData == null) {
                return new ExposureInstance((String)expId, exposure, negative, simulateFilm);
            }
            expData.replaceData(exposure);
            return expData;
        });
    }

    public void clearData() {
        for (ExposureInstance instance : this.cache.values()) {
            instance.close();
        }
        this.cache.clear();
    }

    @Override
    public void close() {
        this.clearData();
    }

    static class ExposureInstance
    implements AutoCloseable {
        private final boolean negative;
        private final boolean simulateFilm;
        private final RenderType renderType;
        private ExposureImage exposure;
        private DynamicTexture texture;
        private boolean requiresUpload = true;

        ExposureInstance(String id, ExposureImage exposure, boolean negative, boolean simulateFilm) {
            this.exposure = exposure;
            this.texture = new DynamicTexture(exposure.getWidth(), exposure.getHeight(), true);
            this.negative = negative;
            this.simulateFilm = simulateFilm;
            String textureId = ExposureInstance.createTextureId(id);
            ResourceLocation resourcelocation = Minecraft.m_91087_().m_91097_().m_118490_(textureId, this.texture);
            this.renderType = RenderType.m_110497_((ResourceLocation)resourcelocation);
        }

        private static String createTextureId(String exposureId) {
            Object id = "exposure/" + exposureId.toLowerCase();
            id = ((String)id).replace(':', '_');
            Pattern pattern = Pattern.compile("[^a-z0-9_.-]");
            Matcher matcher = pattern.matcher((CharSequence)id);
            StringBuilder sb = new StringBuilder();
            while (matcher.find()) {
                matcher.appendReplacement(sb, String.valueOf(matcher.group().hashCode()));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }

        private void replaceData(ExposureImage exposure) {
            boolean hasChanged = !this.exposure.getName().equals(exposure.getName());
            this.exposure = exposure;
            if (hasChanged) {
                this.texture = new DynamicTexture(exposure.getWidth(), exposure.getHeight(), true);
            }
            this.requiresUpload |= hasChanged;
        }

        public void forceUpload() {
            this.requiresUpload = true;
        }

        private void updateTexture() {
            if (this.texture.m_117991_() == null) {
                return;
            }
            for (int y = 0; y < this.exposure.getWidth(); ++y) {
                for (int x = 0; x < this.exposure.getHeight(); ++x) {
                    int ABGR = this.exposure.getPixelABGR(x, y);
                    if (this.negative) {
                        int blue = ABGR >> 16 & 0xFF;
                        int green = ABGR >> 8 & 0xFF;
                        int red = ABGR & 0xFF;
                        ABGR ^= 0xFFFFFF;
                        if (this.simulateFilm) {
                            int brightness = (blue + green + red) / 3;
                            int opacity = (int)Mth.m_14036_((float)((float)brightness * 1.5f), (float)0.0f, (float)255.0f);
                            ABGR = ABGR & 0xFFFFFF | opacity << 24;
                        }
                    }
                    this.texture.m_117991_().m_84988_(x, y, ABGR);
                }
            }
            this.texture.m_117985_();
        }

        void draw(PoseStack poseStack, MultiBufferSource bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a) {
            if (this.requiresUpload) {
                this.updateTexture();
                this.requiresUpload = false;
            }
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            VertexConsumer vertexconsumer = bufferSource.m_6299_(this.renderType);
            vertexconsumer.m_252986_(matrix4f, minX, maxY, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_85969_(packedLight).m_5752_();
            vertexconsumer.m_252986_(matrix4f, maxX, maxY, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(packedLight).m_5752_();
            vertexconsumer.m_252986_(matrix4f, maxX, minY, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_85969_(packedLight).m_5752_();
            vertexconsumer.m_252986_(matrix4f, minX, minY, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, minV).m_85969_(packedLight).m_5752_();
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

