/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.camera.button;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.FlashMode;
import io.github.mortuusars.exposure.camera.infrastructure.SynchronizedCameraInHandActions;
import io.github.mortuusars.exposure.gui.screen.camera.button.CycleButton;
import io.github.mortuusars.exposure.util.CameraInHand;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class FlashModeButton
extends CycleButton {
    private final List<FlashMode> flashModes = Arrays.stream(FlashMode.values()).toList();

    public FlashModeButton(Screen screen, int x, int y, int width, int height, int u, int v, ResourceLocation texture) {
        super(screen, x, y, width, height, u, v, height, texture);
        CameraInHand camera = CameraInHand.getActive((Player)Minecraft.m_91087_().f_91074_);
        Preconditions.checkState((!camera.isEmpty() ? 1 : 0) != 0, (Object)"Player must hold an active camera at this point.");
        FlashMode guide = camera.getItem().getFlashMode(camera.getStack());
        int currentGuideIndex = 0;
        for (int i = 0; i < this.flashModes.size(); ++i) {
            if (!this.flashModes.get(i).getId().equals(guide.getId())) continue;
            currentGuideIndex = i;
            break;
        }
        this.setupButtonElements(this.flashModes.size(), currentGuideIndex);
    }

    public void m_7435_(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)Exposure.SoundEvents.CAMERA_BUTTON_CLICK.get(), (float)(Objects.requireNonNull(Minecraft.m_91087_().f_91073_).f_46441_.m_188501_() * 0.15f + 0.93f), (float)0.7f));
    }

    @Override
    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280398_(Exposure.resource("textures/gui/viewfinder/icon/flash_mode/" + this.flashModes.get(this.currentIndex).getId() + ".png"), this.m_252754_(), this.m_252907_() + 4, 0, 0.0f, 0.0f, 15, 14, 15, 14);
    }

    @Override
    public void renderToolTip(@NotNull GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        pGuiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, List.of(Component.m_237115_((String)"gui.exposure.viewfinder.flash_mode.tooltip"), ((MutableComponent)this.m_6035_()).m_130940_(ChatFormatting.GRAY)), Optional.empty(), mouseX, mouseY);
    }

    @NotNull
    public Component m_6035_() {
        return this.flashModes.get(this.currentIndex).translate();
    }

    @Override
    protected void onCycle() {
        SynchronizedCameraInHandActions.setFlashMode(this.flashModes.get(this.currentIndex));
    }
}

