/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.forge.data.generation.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.exposure.Exposure;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class FilmDevelopingFinishedRecipe
implements FinishedRecipe {
    private final ResourceLocation id;
    private final Item result;
    private final int count;
    private final String group;
    private final List<Ingredient> ingredients;
    private final Advancement.Builder advancement;
    private final ResourceLocation advancementId;

    public FilmDevelopingFinishedRecipe(ResourceLocation id, Item result, int count, String group, List<Ingredient> ingredients, Advancement.Builder advancement, ResourceLocation advancementId) {
        this.id = id;
        this.result = result;
        this.count = count;
        this.group = group;
        this.ingredients = ingredients;
        this.advancement = advancement;
        this.advancementId = advancementId;
    }

    public void m_7917_(@NotNull JsonObject pJson) {
        if (!this.group.isEmpty()) {
            pJson.addProperty("group", this.group);
        }
        JsonArray jsonarray = new JsonArray();
        for (Ingredient ingredient : this.ingredients) {
            jsonarray.add(ingredient.m_43942_());
        }
        pJson.add("ingredients", (JsonElement)jsonarray);
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result)).toString());
        if (this.count > 1) {
            jsonobject.addProperty("count", (Number)this.count);
        }
        pJson.add("result", (JsonElement)jsonobject);
    }

    @NotNull
    public RecipeSerializer<?> m_6637_() {
        return Exposure.RecipeSerializers.FILM_DEVELOPING.get();
    }

    @NotNull
    public ResourceLocation m_6445_() {
        return this.id;
    }

    @Nullable
    public JsonObject m_5860_() {
        return this.advancement.m_138400_();
    }

    @Nullable
    public ResourceLocation m_6448_() {
        return this.advancementId;
    }
}

