/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.world;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.block.CSBlockRegistry;
import com.github.alexthe668.cloudstorage.block.CloudChestBlockEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonTieEntity;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.item.BalloonItem;
import com.github.alexthe668.cloudstorage.world.CSStructureRegistry;
import com.github.alexthe668.cloudstorage.world.SkyTempleBlockProcessor;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class SkyTempleStructure
extends Structure {
    public static final Codec<Structure> BALLOON_CODEC = SkyTempleStructure.m_226607_(settings -> new SkyTempleStructure(true, (Structure.StructureSettings)settings));
    public static final Codec<Structure> TEMPLE_CODEC = SkyTempleStructure.m_226607_(settings -> new SkyTempleStructure(false, (Structure.StructureSettings)settings));
    private static final ResourceLocation[] TEMPLES = new ResourceLocation[]{new ResourceLocation("cloudstorage:sky_temple_0"), new ResourceLocation("cloudstorage:sky_temple_1"), new ResourceLocation("cloudstorage:sky_temple_2")};
    private static final ResourceLocation[] BALLOONS = new ResourceLocation[]{new ResourceLocation("cloudstorage:big_balloon_0"), new ResourceLocation("cloudstorage:big_balloon_1"), new ResourceLocation("cloudstorage:big_balloon_2")};
    private boolean balloon = false;

    public SkyTempleStructure(boolean balloon, Structure.StructureSettings settings) {
        super(settings);
        this.balloon = balloon;
    }

    private static Optional<Structure.GenerationStub> generateTemplePieces(Structure.GenerationContext contex) {
        if (((Boolean)CloudStorage.CONFIG.generateSkyTemples.get()).booleanValue()) {
            Rotation rotation = Rotation.m_221990_((RandomSource)contex.f_226626_());
            LevelHeightAccessor levelHeight = contex.f_226629_();
            int y = contex.f_226622_().m_223235_(contex.f_226628_().m_45604_(), contex.f_226628_().m_45605_(), Heightmap.Types.WORLD_SURFACE_WG, levelHeight, contex.f_226624_()) + 3;
            int randomHeight = 10 + contex.f_226626_().m_188503_(10);
            BlockPos blockpos = new BlockPos(contex.f_226628_().m_45604_(), Math.max(y, (Integer)CloudStorage.CONFIG.cloudHeight.get()) + randomHeight, contex.f_226628_().m_45605_());
            ResourceLocation res = (ResourceLocation)Util.m_214670_((Object[])TEMPLES, (RandomSource)contex.f_226626_());
            return Optional.of(new Structure.GenerationStub(blockpos, piecesBuilder -> piecesBuilder.m_142679_((StructurePiece)new Piece(contex.f_226625_(), res, blockpos, rotation, contex.f_226626_().m_188505_()))));
        }
        return Optional.empty();
    }

    private static Optional<Structure.GenerationStub> generateBalloonPieces(Structure.GenerationContext contex) {
        if (((Boolean)CloudStorage.CONFIG.generateBigBalloons.get()).booleanValue()) {
            Rotation rotation = Rotation.m_221990_((RandomSource)contex.f_226626_());
            LevelHeightAccessor levelHeight = contex.f_226629_();
            int y = contex.f_226622_().m_223235_(contex.f_226628_().m_45604_(), contex.f_226628_().m_45605_(), Heightmap.Types.WORLD_SURFACE_WG, levelHeight, contex.f_226624_()) + 3;
            int randomHeight = 10 + contex.f_226626_().m_188503_(40);
            BlockPos blockpos = new BlockPos(contex.f_226628_().m_45604_(), Math.max(y, (Integer)CloudStorage.CONFIG.cloudHeight.get()) + randomHeight, contex.f_226628_().m_45605_());
            ResourceLocation res = (ResourceLocation)Util.m_214670_((Object[])BALLOONS, (RandomSource)contex.f_226626_());
            return Optional.of(new Structure.GenerationStub(blockpos, piecesBuilder -> piecesBuilder.m_142679_((StructurePiece)new Piece(contex.f_226625_(), res, blockpos, rotation, contex.f_226626_().m_188505_()))));
        }
        return Optional.empty();
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        return this.balloon ? SkyTempleStructure.generateBalloonPieces(context) : SkyTempleStructure.generateTemplePieces(context);
    }

    public StructureType<?> m_213658_() {
        return this.balloon ? (StructureType)CSStructureRegistry.BALLOON_TYPE.get() : (StructureType)CSStructureRegistry.SKY_TEMPLE_TYPE.get();
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.STRONGHOLDS;
    }

    public static class Piece
    extends TemplateStructurePiece {
        private long seed;

        public Piece(StructureTemplateManager manager, ResourceLocation resourceLocation, BlockPos pos, Rotation rotation, long seed) {
            super(StructurePieceType.f_210104_, 0, manager, resourceLocation, resourceLocation.toString(), Piece.makeSettings(rotation, seed), pos);
            this.seed = seed;
        }

        public Piece(StructureTemplateManager manager, CompoundTag tag) {
            super(StructurePieceType.f_210104_, tag, manager, x -> Piece.makeSettings(Rotation.valueOf((String)tag.m_128461_("Rotation")), tag.m_128454_("Seed")));
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            this(context.f_226956_(), tag);
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation, long seed) {
            StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE);
            settings.m_74394_();
            settings.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_);
            RandomSource random = RandomSource.m_216335_((long)seed);
            WoodType woodType = switch (random.m_188503_(5)) {
                case 1 -> WoodType.f_61832_;
                case 2 -> WoodType.f_61831_;
                case 3 -> WoodType.f_61834_;
                case 4 -> WoodType.f_61833_;
                case 5 -> WoodType.f_61835_;
                default -> WoodType.f_61830_;
            };
            DyeColor dyecolor1 = (DyeColor)Util.m_214670_((Object[])DyeColor.values(), (RandomSource)random);
            DyeColor dyecolor2 = (DyeColor)Util.m_214670_((Object[])DyeColor.values(), (RandomSource)random);
            settings.m_74383_((StructureProcessor)new SkyTempleBlockProcessor(woodType, dyecolor1, dyecolor2));
            return settings;
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
            super.m_183620_(context, tag);
            tag.m_128359_("Rotation", this.f_73657_.m_74404_().name());
            tag.m_128356_("Seed", this.seed);
        }

        protected void m_213704_(String string, BlockPos pos, ServerLevelAccessor accessor, RandomSource random, BoundingBox box) {
            accessor.m_7731_(pos, Blocks.f_50016_.m_49966_(), 1);
            switch (string) {
                case "cloud_chest": {
                    accessor.m_7731_(pos, ((Block)CSBlockRegistry.CLOUD_CHEST.get()).m_49966_().m_60717_(this.f_73657_.m_74404_()), 1);
                    BlockEntity blockEntity = accessor.m_7702_(pos);
                    if (!(blockEntity instanceof CloudChestBlockEntity)) break;
                    CloudChestBlockEntity cloudChest = (CloudChestBlockEntity)blockEntity;
                    cloudChest.setLootBalloon(random.m_188503_(0xFFFFFF), BalloonItem.LOOT_TABLE, this.seed);
                    break;
                }
                case "bloviator_spawner": {
                    accessor.m_7731_(pos, Blocks.f_50085_.m_49966_(), 0);
                    BlockEntity blockEntity = accessor.m_7702_(pos);
                    if (!(blockEntity instanceof SpawnerBlockEntity)) break;
                    SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
                    spawner.m_252803_((EntityType)CSEntityRegistry.BLOVIATOR.get(), random);
                    break;
                }
                case "badloon_spawner": {
                    accessor.m_7731_(pos, Blocks.f_50085_.m_49966_(), 0);
                    BlockEntity blockEntity = accessor.m_7702_(pos);
                    if (!(blockEntity instanceof SpawnerBlockEntity)) break;
                    SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
                    spawner.m_252803_((EntityType)CSEntityRegistry.BADLOON.get(), random);
                    break;
                }
                case "observer_up": {
                    accessor.m_7731_(pos, (BlockState)Blocks.f_50455_.m_49966_().m_61124_((Property)ObserverBlock.f_52588_, (Comparable)Direction.UP), 0);
                    break;
                }
                case "observer_south": {
                    accessor.m_7731_(pos, ((BlockState)Blocks.f_50455_.m_49966_().m_61124_((Property)ObserverBlock.f_52588_, (Comparable)Direction.SOUTH)).m_60717_(this.f_73657_.m_74404_()), 0);
                    break;
                }
                case "tied_balloon": {
                    Random seedRng = new Random(this.seed);
                    switch (seedRng.nextInt(5)) {
                        case 1: {
                            accessor.m_7731_(pos, Blocks.f_50480_.m_49966_(), 2);
                            break;
                        }
                        case 2: {
                            accessor.m_7731_(pos, Blocks.f_50479_.m_49966_(), 2);
                            break;
                        }
                        case 3: {
                            accessor.m_7731_(pos, Blocks.f_50481_.m_49966_(), 2);
                            break;
                        }
                        case 4: {
                            accessor.m_7731_(pos, Blocks.f_50482_.m_49966_(), 2);
                            break;
                        }
                        case 5: {
                            accessor.m_7731_(pos, Blocks.f_50483_.m_49966_(), 2);
                            break;
                        }
                        default: {
                            accessor.m_7731_(pos, Blocks.f_50132_.m_49966_(), 2);
                        }
                    }
                    if (accessor.m_8055_(pos).m_60795_()) break;
                    BalloonTieEntity tie = new BalloonTieEntity((Level)accessor.m_6018_(), pos);
                    tie.setBalloonCount(1);
                    accessor.m_47205_((Entity)tie);
                    BalloonEntity balloon = (BalloonEntity)((EntityType)CSEntityRegistry.BALLOON.get()).m_20615_((Level)accessor.m_6018_());
                    balloon.setStringLength(3);
                    balloon.m_6034_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 3.1f, (float)pos.m_123343_() + 0.5f);
                    balloon.setChildId(tie.m_20148_());
                    accessor.m_47205_((Entity)balloon);
                }
            }
        }
    }
}

