/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.world;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class SkyMobSpawner {
    private static final Predicate<? super ServerPlayer> ABOVE_CLOUD_HEIGHT = serverPlayer -> serverPlayer.m_6084_() && serverPlayer.m_20186_() > (double)((Integer)CloudStorage.CONFIG.cloudHeight.get()).intValue();
    private final Random random = new Random();
    private final ServerLevel world;
    private int timer;

    public SkyMobSpawner(ServerLevel world) {
        this.world = world;
        this.timer = (Integer)CloudStorage.CONFIG.skyMobSpawningInterval.get();
        if (world.m_46462_()) {
            this.timer /= 2;
        }
    }

    public void tick() {
        if (this.timer-- <= 0) {
            this.timer = (Integer)CloudStorage.CONFIG.skyMobSpawningInterval.get() + this.random.nextInt((Integer)CloudStorage.CONFIG.skyMobSpawningInterval.get() / 2);
            if (this.world.m_46462_()) {
                this.timer /= 2;
            }
            this.attemptSpawn();
        }
    }

    private boolean attemptSpawn() {
        double maxDist;
        double minDist;
        Player playerentity = this.getRandomPlayer();
        if (playerentity == null || !this.world.m_6042_().f_223549_()) {
            return false;
        }
        if (this.random.nextDouble() < (Double)CloudStorage.CONFIG.skyMobSpawningChance.get()) {
            return false;
        }
        BlockPos blockpos = BlockPos.m_274446_((Position)playerentity.m_20182_());
        BlockPos blockpos2 = this.generateFarAwayPos(blockpos, (int)(minDist = (double)((Integer)CloudStorage.CONFIG.skyMobMinSpawnDistance.get()).intValue()), (int)Math.max(maxDist = (double)((Integer)CloudStorage.CONFIG.skyMobMaxSpawnDistance.get()).intValue(), minDist + 1.0));
        if (blockpos2 != null && this.hasLightLevel(blockpos2) && blockpos2.m_123331_((Vec3i)blockpos) > minDist * minDist) {
            EntityType<? extends Mob> type = this.createRandomMob(this.random);
            for (int i = 0; i < 1 + this.random.nextInt(2); ++i) {
                Mob mob = (Mob)type.m_20615_((Level)this.world);
                mob.m_20219_(Vec3.m_82512_((Vec3i)blockpos2));
                mob.m_6518_((ServerLevelAccessor)this.world, this.world.m_6436_(blockpos2), MobSpawnType.NATURAL, null, null);
                if (!mob.m_6914_((LevelReader)this.world)) continue;
                mob.m_146922_(this.random.nextFloat() * 360.0f);
                this.world.m_47205_((Entity)mob);
            }
            return true;
        }
        return false;
    }

    private EntityType<? extends Mob> createRandomMob(Random random) {
        if (random.nextDouble() < (Double)CloudStorage.CONFIG.badloonToBloviatorRatio.get()) {
            return (EntityType)CSEntityRegistry.BADLOON.get();
        }
        return (EntityType)CSEntityRegistry.BLOVIATOR.get();
    }

    private Player getRandomPlayer() {
        if (((Boolean)CloudStorage.CONFIG.skyMobSpawnsAroundCloudedPlayers.get()).booleanValue()) {
            List list = this.world.m_8795_(ABOVE_CLOUD_HEIGHT);
            return list.isEmpty() ? null : (Player)list.get(this.random.nextInt(list.size()));
        }
        return this.world.m_8890_();
    }

    @Nullable
    private BlockPos generateFarAwayPos(BlockPos center, int minDist, int maxDist) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int j = center.m_123341_() + this.random.nextInt(maxDist * 2) - maxDist;
            int k = center.m_123343_() + this.random.nextInt(maxDist * 2) - maxDist;
            int cloudHeight = (Integer)CloudStorage.CONFIG.cloudHeight.get() + this.random.nextInt(10);
            int l = this.world.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k);
            BlockPos blockpos1 = new BlockPos(j, Math.max(cloudHeight, l + 1), k);
            double d0 = (double)blockpos1.m_123341_() - (double)center.m_123341_();
            double d2 = (double)blockpos1.m_123343_() - (double)center.m_123343_();
            if (!this.world.m_46859_(blockpos1) || !(d0 * d0 + d2 * d2 >= (double)(minDist * minDist))) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean hasLightLevel(BlockPos pos) {
        int blockLight = this.world.m_45517_(LightLayer.BLOCK, pos);
        int skyLight = this.world.m_45517_(LightLayer.SKY, pos);
        if (((Boolean)CloudStorage.CONFIG.skyMobSpawnsOnlyInDarkness.get()).booleanValue()) {
            return Math.max(skyLight, blockLight) < 2;
        }
        return blockLight < 2;
    }
}

