/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.world;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.block.CSBlockRegistry;
import com.github.alexthe668.cloudstorage.entity.BalloonEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonTieEntity;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.entity.villager.CSVillagerRegistry;
import com.github.alexthe668.cloudstorage.world.CSVillageStructureRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BalloonStandPoolElement
extends LegacySinglePoolElement {
    public static final Codec<BalloonStandPoolElement> CODEC = RecordCodecBuilder.create(p_210357_ -> p_210357_.group((App)BalloonStandPoolElement.m_210465_(), (App)BalloonStandPoolElement.m_210462_(), (App)BalloonStandPoolElement.m_210538_()).apply((Applicative)p_210357_, BalloonStandPoolElement::new));

    protected BalloonStandPoolElement(Either<ResourceLocation, StructureTemplate> either, Holder<StructureProcessorList> p_210349_, StructureTemplatePool.Projection p_210350_) {
        super(either, p_210349_, p_210350_);
    }

    public BalloonStandPoolElement(ResourceLocation resourceLocation, Holder<StructureProcessorList> processors) {
        super(Either.left((Object)resourceLocation), processors, StructureTemplatePool.Projection.RIGID);
    }

    public void m_227329_(LevelAccessor accessor, StructureTemplate.StructureBlockInfo structureBlockInfo, BlockPos pos, Rotation rotation, RandomSource random, BoundingBox box) {
        String contents = structureBlockInfo.f_74677_().m_128461_("metadata");
        if (contents.startsWith("balloons")) {
            int secondary = 0;
            try {
                secondary = Integer.parseInt(contents.substring(8));
            }
            catch (Exception e) {
                CloudStorage.LOGGER.warn("could not parse balloon NBT");
            }
            if (accessor instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevel = (ServerLevelAccessor)accessor;
                if (!accessor.m_8055_(structureBlockInfo.f_74675_()).m_60795_()) {
                    BalloonTieEntity tie = new BalloonTieEntity((Level)serverLevel.m_6018_(), structureBlockInfo.f_74675_().m_7495_());
                    if (accessor.m_8055_(structureBlockInfo.f_74675_().m_7495_()).m_60734_() == CSBlockRegistry.BALLOON_STAND.get()) {
                        tie.m_6034_(tie.m_20185_(), tie.m_20186_() + (double)0.3f, tie.m_20189_());
                    }
                    int balloons = 1 + random.m_188503_(3);
                    tie.setBalloonCount(balloons);
                    ((ServerLevelAccessor)accessor).m_47205_((Entity)tie);
                    int[] colors = this.getBalloonColors(secondary);
                    for (int i = 0; i < balloons; ++i) {
                        BalloonEntity balloon = (BalloonEntity)((EntityType)CSEntityRegistry.BALLOON.get()).m_20615_((Level)serverLevel.m_6018_());
                        balloon.m_6034_((float)structureBlockInfo.f_74675_().m_123341_() + 0.5f, (float)structureBlockInfo.f_74675_().m_123342_() + 0.1f, (float)structureBlockInfo.f_74675_().m_123343_() + 0.5f);
                        balloon.setStringLength(1 + random.m_188503_(2));
                        balloon.setBalloonColor(colors[Mth.m_14045_((int)random.m_188503_(colors.length), (int)0, (int)(colors.length - 1))]);
                        balloon.setChildId(tie.m_20148_());
                        ((ServerLevelAccessor)accessor).m_47205_((Entity)balloon);
                    }
                }
            }
            accessor.m_7731_(structureBlockInfo.f_74675_(), Blocks.f_50016_.m_49966_(), 2);
        }
    }

    private int[] getBalloonColors(int index) {
        switch (index) {
            case 1: {
                return CSVillagerRegistry.getBalloonColorsForVillager(VillagerType.f_35821_);
            }
            case 2: {
                return CSVillagerRegistry.getBalloonColorsForVillager(VillagerType.f_35819_);
            }
            case 3: {
                return CSVillagerRegistry.getBalloonColorsForVillager(VillagerType.f_35822_);
            }
            case 4: {
                return CSVillagerRegistry.getBalloonColorsForVillager(VillagerType.f_35823_);
            }
            case 5: {
                return CSVillagerRegistry.getBalloonColorsForVillager(VillagerType.f_35825_);
            }
        }
        return new int[]{15149353};
    }

    protected StructurePlaceSettings m_207169_(Rotation p_210421_, BoundingBox p_210422_, boolean p_210423_) {
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings();
        structureplacesettings.m_74381_(p_210422_);
        structureplacesettings.m_74379_(p_210421_);
        structureplacesettings.m_74402_(true);
        structureplacesettings.m_74392_(false);
        structureplacesettings.m_74405_(true);
        if (!p_210423_) {
            structureplacesettings.m_74383_((StructureProcessor)JigsawReplacementProcessor.f_74122_);
        }
        ((StructureProcessorList)this.f_210412_.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)structureplacesettings).m_74383_(arg_0));
        this.m_210539_().m_210609_().forEach(arg_0 -> ((StructurePlaceSettings)structureplacesettings).m_74383_(arg_0));
        return structureplacesettings;
    }

    public StructurePoolElementType<?> m_207234_() {
        return (StructurePoolElementType)CSVillageStructureRegistry.BALLOON_STAND.get();
    }

    public String toString() {
        return "BalloonStand[" + this.f_210411_ + "]";
    }
}

