/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.mixin;

import com.github.alexthe668.cloudstorage.block.CSBlockRegistry;
import com.github.alexthe668.cloudstorage.block.CloudBlock;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightningBolt.class})
public abstract class LightningBoltMixin {
    @Inject(method={"clearCopperOnLightningStrike"}, at={@At(value="TAIL")})
    private static void chargeCloudBlocks(Level level, BlockPos pos, CallbackInfo ci) {
        BlockState blockstate1;
        BlockPos blockpos;
        BlockState blockstate = level.m_8055_(pos);
        if (blockstate.m_60713_(Blocks.f_152587_)) {
            blockpos = pos.m_121945_(((Direction)blockstate.m_61143_((Property)LightningRodBlock.f_52588_)).m_122424_());
            blockstate1 = level.m_8055_(blockpos);
        } else {
            blockpos = pos;
            blockstate1 = blockstate;
        }
        if (blockstate1.m_60734_() instanceof CloudBlock) {
            level.m_46597_(blockpos, ((Block)CSBlockRegistry.STATIC_CLOUD.get()).m_49966_());
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
            int i = level.f_46441_.m_188503_(3) + 3;
            for (int j = 0; j < i; ++j) {
                int k = level.f_46441_.m_188503_(8) + 1;
                LightningBoltMixin.chargeRandomCloudsNearby(level, blockpos, blockpos$mutableblockpos, k);
            }
        }
    }

    private static void chargeRandomCloudsNearby(Level level, BlockPos blockpos, BlockPos.MutableBlockPos blockpos$mutableblockpos, int k) {
        Optional<BlockPos> optional;
        blockpos$mutableblockpos.m_122190_((Vec3i)blockpos);
        for (int i = 0; i < k && (optional = LightningBoltMixin.chargeRandomCloud(level, (BlockPos)blockpos$mutableblockpos)).isPresent(); ++i) {
            blockpos$mutableblockpos.m_122190_((Vec3i)optional.get());
        }
    }

    private static Optional<BlockPos> chargeRandomCloud(Level level, BlockPos blockpos2) {
        for (BlockPos blockpos : BlockPos.m_235650_((RandomSource)level.f_46441_, (int)10, (BlockPos)blockpos2, (int)1)) {
            BlockState blockstate = level.m_8055_(blockpos);
            if (!(blockstate.m_60734_() instanceof CloudBlock)) continue;
            level.m_46597_(blockpos, ((Block)CSBlockRegistry.STATIC_CLOUD.get()).m_49966_());
            level.m_46796_(3002, blockpos, -1);
            return Optional.of(blockpos);
        }
        return Optional.empty();
    }
}

