/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.item;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.client.particle.CSParticleRegistry;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.misc.CSSoundRegistry;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class CloudBlowerItem
extends Item {
    public static int MAX_FUEL = 300;

    public CloudBlowerItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public static int getMode(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_("Mode") : 0;
    }

    public static void setMode(ItemStack stack, int mode) {
        stack.m_41784_().m_128405_("Mode", mode);
    }

    public static int getUseTime(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_("UseTime") : 0;
    }

    public static float getLerpedUseTime(ItemStack stack, float f) {
        CompoundTag compoundtag = stack.m_41783_();
        float prev = compoundtag != null ? (float)compoundtag.m_128451_("PrevUseTime") : 0.0f;
        float current = compoundtag != null ? (float)compoundtag.m_128451_("UseTime") : 0.0f;
        return prev + f * (current - prev);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        LivingEntity living;
        super.m_6883_(stack, level, entity, i, held);
        if (!stack.m_41782_()) {
            CompoundTag compoundtag = stack.m_41784_();
            stack.m_41751_(compoundtag);
        }
        if (CloudBlowerItem.getUseTime(stack) != 0 && entity instanceof LivingEntity && !(living = (LivingEntity)entity).m_21211_().equals(stack)) {
            CloudBlowerItem.setUseTime(stack, 0);
            stack.m_41784_().m_128405_("PrevUseTime", 0);
        }
    }

    public static void setUseTime(ItemStack stack, int useTime) {
        stack.m_41784_().m_128405_("PrevUseTime", CloudBlowerItem.getUseTime(stack));
        stack.m_41784_().m_128405_("UseTime", useTime);
    }

    public static int getFuel(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && compoundtag.m_128441_("Fuel") ? compoundtag.m_128451_("Fuel") : MAX_FUEL;
    }

    public static void setFuel(ItemStack stack, int mode) {
        stack.m_41784_().m_128405_("Fuel", mode);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flags) {
        super.m_7373_(stack, level, components, flags);
        if (stack.m_41782_()) {
            MutableComponent one = Component.m_237115_((String)"item.cloudstorage.cloud_blower.mode").m_130940_(ChatFormatting.GRAY);
            MutableComponent two = Component.m_237115_((String)("item.cloudstorage.cloud_blower.mode_" + CloudBlowerItem.getMode(stack))).m_130940_(ChatFormatting.AQUA);
            components.add((Component)one.m_7220_((Component)two));
        }
        components.add((Component)Component.m_237115_((String)"item.cloudstorage.cloud_blower.desc_0").m_130940_(ChatFormatting.GRAY));
        components.add((Component)Component.m_237115_((String)"item.cloudstorage.cloud_blower.desc_1").m_130940_(ChatFormatting.GRAY));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)CloudStorage.PROXY.getISTERProperties(false));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level lvl, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (CloudBlowerItem.getFuel(itemstack) <= 0) {
            ItemStack ammo = this.findAmmo(player);
            boolean flag = player.m_7500_();
            if (!ammo.m_41619_() && !flag) {
                player.m_36356_(ammo.getCraftingRemainingItem().m_41777_());
                ammo.m_41774_(1);
                flag = true;
            }
            if (flag) {
                CloudBlowerItem.setFuel(itemstack, MAX_FUEL);
            }
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int timeUsing) {
        if (CloudBlowerItem.getFuel(stack) > 0) {
            int i = this.m_8105_(stack) - timeUsing;
            if (level.f_46443_) {
                CloudBlowerItem.setUseTime(stack, i);
            }
            if (i >= 5) {
                Vec3 windTo;
                if ((i + 10) % 15 == 0) {
                    living.m_216990_((SoundEvent)CSSoundRegistry.CLOUD_BLOWER.get());
                    living.m_146850_(GameEvent.f_223698_);
                }
                boolean left = this.isLeftHand(living);
                float totalDistance = 6.5f;
                Vec3 handAt = living.m_146892_().m_82520_(0.0, -0.25, 0.0);
                Vec3 windFrom = new Vec3(left ? 0.25 : -0.25, 0.0, (double)0.35f).m_82496_(-living.m_146909_() * ((float)Math.PI / 180)).m_82524_(-living.m_146908_() * ((float)Math.PI / 180)).m_82549_(handAt);
                BlockHitResult result = level.m_45547_(new ClipContext(windFrom, windTo = new Vec3(left ? 0.25 : -0.25, 0.0, (double)totalDistance).m_82496_(-living.m_146909_() * ((float)Math.PI / 180)).m_82524_(-living.m_146908_() * ((float)Math.PI / 180)).m_82549_(handAt), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)living));
                if (result != null) {
                    windTo = result.m_82450_();
                }
                Vec3 sub = windTo.m_82546_(handAt);
                int dist = (int)Math.ceil(sub.m_82553_()) + 1;
                for (int j = 0; j < dist; ++j) {
                    float scale = (float)(j + 1) / (float)dist;
                    Vec3 moveMobsFrom = handAt.m_82549_(sub.m_82490_((double)scale));
                    float aabbFan = 1.0f + scale * 0.5f;
                    for (Entity entity : level.m_45933_((Entity)living, new AABB(moveMobsFrom.m_82492_((double)aabbFan, (double)aabbFan, (double)aabbFan), moveMobsFrom.m_82520_((double)aabbFan, (double)(aabbFan + 1.0f), (double)aabbFan)))) {
                        if (!living.m_142582_(entity)) continue;
                        this.pullOrPush(entity, stack, windFrom);
                    }
                }
                if (CloudBlowerItem.getMode(stack) == 2) {
                    Vec3 away = living.m_20182_().m_82546_(windTo).m_82541_().m_82490_((double)0.1f);
                    living.m_20256_(living.m_20184_().m_82549_(away));
                    living.f_19789_ = 0.0f;
                }
                Vec3 randomVec = new Vec3((double)(living.m_217043_().m_188501_() - 0.5f), (double)(living.m_217043_().m_188501_() - 0.5f), (double)(living.m_217043_().m_188501_() - 0.5f));
                Vec3 particleDir = windTo.m_82549_(randomVec).m_82546_(windFrom).m_82541_();
                if (CloudBlowerItem.getMode(stack) == 1) {
                    Vec3 priorWindFrom = windFrom;
                    windFrom = windTo.m_82549_(randomVec);
                    particleDir = priorWindFrom.m_82546_(windFrom).m_82541_().m_82490_((double)0.6f);
                }
                level.m_7106_((ParticleOptions)CSParticleRegistry.BLOVIATOR_BREATH.get(), windFrom.f_82479_, windFrom.f_82480_, windFrom.f_82481_, particleDir.f_82479_, particleDir.f_82480_, particleDir.f_82481_);
                if (!(i % 15 != 0 || living instanceof Player && ((Player)living).m_7500_())) {
                    CloudBlowerItem.setFuel(stack, CloudBlowerItem.getFuel(stack) - 1);
                }
            }
        } else {
            living.m_5810_();
        }
    }

    private void pullOrPush(Entity entity, ItemStack stack, Vec3 windFrom) {
        if (CloudBlowerItem.getMode(stack) == 1) {
            Vec3 towards = windFrom.m_82546_(entity.m_20182_());
            float pull = towards.m_82553_() > 2.0 ? 1.0f : (float)(2.0 - towards.m_82553_()) * 0.5f;
            entity.m_20256_(entity.m_20184_().m_82549_(towards.m_82541_()).m_82490_((double)(pull * 0.45f)));
        } else {
            Vec3 away = entity.m_20182_().m_82546_(windFrom);
            float scale = 0.2f;
            if (CloudBlowerItem.getMode(stack) == 2) {
                scale = 0.05f;
            }
            entity.m_20256_(entity.m_20184_().m_82549_(away.m_82541_().m_82490_((double)scale)));
        }
        entity.m_6853_(false);
        entity.f_19789_ = 0.0f;
    }

    public boolean isLeftHand(LivingEntity entity) {
        boolean leftHand = false;
        if (entity.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)CSItemRegistry.CLOUD_BLOWER.get())) {
            boolean bl = leftHand = leftHand || entity.m_5737_() == HumanoidArm.LEFT;
        }
        if (entity.m_21120_(InteractionHand.OFF_HAND).m_150930_((Item)CSItemRegistry.CLOUD_BLOWER.get())) {
            leftHand = leftHand || entity.m_5737_() != HumanoidArm.LEFT;
        }
        return leftHand;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity user, int time) {
        CloudBlowerItem.setUseTime(stack, 0);
        stack.m_41784_().m_128405_("PrevUseTime", 0);
    }

    public int m_8105_(ItemStack p_220131_) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack p_220133_) {
        return UseAnim.NONE;
    }

    public boolean m_142522_(ItemStack stack) {
        return CloudBlowerItem.getFuel(stack) != MAX_FUEL;
    }

    public int m_142158_(ItemStack stack) {
        float f = (float)Math.min(CloudBlowerItem.getFuel(stack), MAX_FUEL) / (float)MAX_FUEL;
        return Math.round(f * 13.0f);
    }

    public int m_142159_(ItemStack p_150901_) {
        return 2404351;
    }

    public ItemStack findAmmo(Player entity) {
        if (entity.m_7500_()) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i < entity.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack1 = entity.m_150109_().m_8020_(i);
            if (!itemstack1.m_150930_((Item)CSItemRegistry.ANGRY_CLOUD_IN_A_BOTTLE.get()) && !itemstack1.m_150930_((Item)CSItemRegistry.HAPPY_CLOUD_IN_A_BOTTLE.get())) continue;
            return itemstack1;
        }
        return ItemStack.f_41583_;
    }

    public static void onLeftClick(Player playerIn, ItemStack stack) {
        if (stack.m_41720_() == CSItemRegistry.CLOUD_BLOWER.get()) {
            int current = CloudBlowerItem.getMode(stack);
            int next = current + 1 > 2 ? 0 : current + 1;
            CloudBlowerItem.setMode(stack, next);
            String modeStr = "item.cloudstorage.cloud_blower.mode_" + next;
            playerIn.m_5496_(SoundEvents.f_11762_, 0.5f, 1.4f);
            playerIn.m_5661_((Component)Component.m_237115_((String)"item.cloudstorage.cloud_blower.change_mode").m_7220_((Component)Component.m_237115_((String)modeStr).m_130940_(ChatFormatting.AQUA)), true);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_((Item)CSItemRegistry.CLOUD_BLOWER.get()) || !newStack.m_150930_((Item)CSItemRegistry.CLOUD_BLOWER.get());
    }
}

