/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.item;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.block.AbstractCloudChestBlockEntity;
import com.github.alexthe668.cloudstorage.block.CSBlockRegistry;
import com.github.alexthe668.cloudstorage.entity.BalloonCargoEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonTieEntity;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.item.CustomTabBehavior;
import com.github.alexthe668.cloudstorage.misc.CSSoundRegistry;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class BalloonItem
extends Item
implements DyeableLeatherItem,
CustomTabBehavior {
    public static final int DEFAULT_COLOR = 15149353;
    private static final int[] BALLOONCOLORS = new int[]{15149353};
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("cloudstorage", "chests/loot_balloon");

    public BalloonItem(Item.Properties props) {
        super(props);
    }

    public BalloonItem() {
        this(new Item.Properties().m_41487_(8));
    }

    public static int getBalloonColor(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : 15149353;
    }

    public static boolean isStatic(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && compoundtag.m_128471_("static") && !BalloonItem.isLoot(stack);
    }

    public static boolean isLoot(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && compoundtag.m_128471_("LootBalloon");
    }

    public static int get3DRender(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_("3DRender") : 0;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flags) {
        super.m_7373_(stack, level, components, flags);
        if (!BalloonItem.isLoot(stack) && BalloonItem.isStatic(stack)) {
            components.add((Component)Component.m_237115_((String)"item.cloudstorage.balloon.static").m_130940_(ChatFormatting.AQUA));
        }
    }

    public boolean m_41113_(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99) && compoundtag.m_128451_("color") != 15149353 && compoundtag.m_128451_("color") != -1;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)CloudStorage.PROXY.getISTERProperties(false));
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output contents) {
        int i;
        for (i = 0; i < BALLOONCOLORS.length; ++i) {
            contents.m_246342_(this.createBalloon(15149353, 0));
        }
        if (this == CSItemRegistry.BALLOON.get()) {
            for (i = 0; i < BALLOONCOLORS.length; ++i) {
                contents.m_246342_(this.createBalloon(15149353, 1));
            }
            contents.m_246342_(this.createBalloon(-1, 2));
        }
    }

    public ItemStack createBalloon(int color, int type) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.m_41115_(stack, color);
        BalloonItem.setStatic(stack, type == 1);
        BalloonItem.setLoot(stack, type == 2);
        if (type == 2) {
            stack.m_41654_(ItemStack.TooltipPart.DYE);
        }
        return stack;
    }

    public int m_41121_(ItemStack stack) {
        return BalloonItem.getBalloonColor(stack);
    }

    public void m_41115_(ItemStack stack, int colorHex) {
        if (colorHex != 15149353) {
            stack.m_41698_("display").m_128405_("color", colorHex);
        }
    }

    public static void setStatic(ItemStack stack, boolean isStatic) {
        if (isStatic) {
            stack.m_41784_().m_128379_("static", true);
        }
    }

    public static void setLoot(ItemStack stack, boolean isLoot) {
        if (isLoot) {
            stack.m_41784_().m_128379_("LootBalloon", true);
        }
    }

    public Component m_7626_(ItemStack stack) {
        return BalloonItem.isLoot(stack) ? Component.m_237115_((String)"item.cloudstorage.loot_balloon") : super.m_7626_(stack);
    }

    public Rarity m_41460_(ItemStack stack) {
        return BalloonItem.isLoot(stack) ? Rarity.UNCOMMON : super.m_41460_(stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        boolean rightHand = false;
        boolean leftHand = false;
        if (BalloonItem.isLoot(stack) && BalloonItem.getBalloonColor(stack) == -1) {
            this.m_41115_(stack, level.m_213780_().m_188503_(0xFFFFFF));
        }
        if (entity instanceof LivingEntity) {
            boolean flag;
            LivingEntity player = (LivingEntity)entity;
            boolean bl = flag = held || player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof BalloonItem;
            if (flag) {
                if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof BalloonItem) {
                    leftHand = leftHand || player.m_5737_() == HumanoidArm.LEFT;
                    boolean bl2 = rightHand = rightHand || player.m_5737_() == HumanoidArm.RIGHT;
                }
                if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof BalloonItem) {
                    leftHand = leftHand || player.m_5737_() != HumanoidArm.LEFT;
                    boolean bl3 = rightHand = rightHand || player.m_5737_() != HumanoidArm.RIGHT;
                }
                if (leftHand && entity.m_20184_().f_82480_ < 0.0) {
                    entity.m_20256_(entity.m_20184_().m_82542_(1.0, (double)0.95f, 1.0));
                }
                if (rightHand && entity.m_20184_().f_82480_ < 0.0) {
                    entity.m_20256_(entity.m_20184_().m_82542_(1.0, (double)0.95f, 1.0));
                }
                this.updateBalloon(player, player.m_21120_(InteractionHand.MAIN_HAND), player.m_5737_() == HumanoidArm.LEFT);
                this.updateBalloon(player, player.m_21120_(InteractionHand.OFF_HAND), player.m_5737_() == HumanoidArm.RIGHT);
                if (rightHand || leftHand) {
                    entity.f_19789_ *= 0.9f;
                }
            }
        }
    }

    private void updateBalloon(LivingEntity player, ItemStack itemInHand, boolean left) {
        if (itemInHand.m_150930_((Item)CSItemRegistry.BALLOON.get())) {
            CloudStorage.PROXY.onHoldingBalloon(player, itemInHand, left);
        }
    }

    public boolean placeBalloon(Level level, ItemStack itemstack, BlockPos blockpos, Direction direction, @Nullable Player player, boolean dispensed) {
        BlockEntity te;
        BlockState blockstate = level.m_8055_(blockpos);
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        if (dispensed) {
            blockpos = blockpos1;
            blockstate = level.m_8055_(blockpos1);
        }
        Random random = new Random();
        if (!BalloonItem.isLoot(itemstack) && !BalloonItem.isStatic(itemstack) && blockstate.m_60713_((Block)CSBlockRegistry.STATIC_CLOUD.get())) {
            CompoundTag tag = itemstack.m_41784_().m_6426_();
            tag.m_128379_("static", true);
            ItemStack copyOff = itemstack.m_41777_();
            copyOff.m_41764_(1);
            copyOff.m_41751_(tag);
            level.m_5594_(player, blockpos1, (SoundEvent)CSSoundRegistry.STATIC_SHOCK.get(), SoundSource.BLOCKS, 0.5f, 0.75f + random.nextFloat() * 0.5f);
            if (player != null && !dispensed) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                if (!player.m_36356_(copyOff)) {
                    player.m_36176_(copyOff, true);
                }
            } else {
                Block.m_49840_((Level)level, (BlockPos)blockpos, (ItemStack)copyOff);
            }
            level.m_46597_(blockpos, ((Block)CSBlockRegistry.CLOUD.get()).m_49966_());
            return true;
        }
        if (BalloonItem.isStatic(itemstack) && blockstate.m_60713_((Block)CSBlockRegistry.CLOUD.get())) {
            CompoundTag tag = itemstack.m_41784_().m_6426_();
            tag.m_128379_("static", false);
            ItemStack copyOff = itemstack.m_41777_();
            copyOff.m_41764_(1);
            copyOff.m_41751_(tag);
            if (player != null && !dispensed) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                if (!player.m_36356_(copyOff)) {
                    player.m_36176_(copyOff, true);
                }
            } else {
                Block.m_49840_((Level)level, (BlockPos)blockpos, (ItemStack)copyOff);
            }
            level.m_46597_(blockpos, ((Block)CSBlockRegistry.STATIC_CLOUD.get()).m_49966_());
            return true;
        }
        if (player != null && (!BalloonItem.isStatic(itemstack) && blockstate.m_60713_((Block)CSBlockRegistry.CLOUD_CHEST.get()) || BalloonItem.isStatic(itemstack) && blockstate.m_60713_((Block)CSBlockRegistry.STATIC_CLOUD_CHEST.get())) && (te = level.m_7702_(blockpos)) instanceof AbstractCloudChestBlockEntity) {
            AbstractCloudChestBlockEntity cloudChest = (AbstractCloudChestBlockEntity)te;
            if (cloudChest.hasBalloonFor(player)) {
                ItemStack newBalloon = new ItemStack((ItemLike)CSItemRegistry.BALLOON.get());
                newBalloon.m_41764_(1);
                BalloonItem newBalloonItem = (BalloonItem)newBalloon.m_41720_();
                newBalloonItem.m_41115_(newBalloon, cloudChest.getBalloonFor(player));
                BalloonItem.setStatic(newBalloon, blockstate.m_60713_((Block)CSBlockRegistry.STATIC_CLOUD_CHEST.get()));
                BalloonItem.setLoot(newBalloon, cloudChest.hasLootBalloon());
                ItemEntity itemEntity = new ItemEntity(level, (double)((float)blockpos.m_123341_() + 0.5f), (double)((float)blockpos.m_123342_() + 0.75f), (double)((float)blockpos.m_123343_() + 0.5f), newBalloon);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            }
            if (BalloonItem.isLoot(itemstack)) {
                cloudChest.setLootBalloon(this.m_41121_(itemstack), LOOT_TABLE, random.nextLong());
            } else {
                cloudChest.setLootBalloon(1, null, random.nextLong());
                cloudChest.setBalloonColorFor(player, this.m_41121_(itemstack));
            }
            itemstack.m_41774_(1);
            return true;
        }
        if (BalloonItem.isLoot(itemstack)) {
            return false;
        }
        BalloonEntity balloon = (BalloonEntity)((EntityType)CSEntityRegistry.BALLOON.get()).m_20615_(level);
        CompoundTag compoundtag = itemstack.m_41783_();
        if (compoundtag != null) {
            EntityType.m_20620_((Level)level, (Player)player, (Entity)balloon, (CompoundTag)compoundtag);
        }
        balloon.setBalloonColor(this.m_41121_(itemstack));
        balloon.setStringLength(1);
        balloon.setCharged(BalloonItem.isStatic(itemstack));
        balloon.m_6034_((float)blockpos1.m_123341_() + 0.5f, (float)blockpos1.m_123342_() + 0.5f, (float)blockpos1.m_123343_() + 0.5f);
        if (level.m_45786_((Entity)balloon) || dispensed) {
            if (blockstate.m_204336_(BlockTags.f_13039_) || blockstate.m_60734_() == CSBlockRegistry.BALLOON_STAND.get()) {
                BalloonTieEntity tie = BalloonTieEntity.getOrCreateKnot(level, blockpos);
                if (tie != null) {
                    tie.setBalloonCount(tie.getBalloonCount() + 1);
                    balloon.setChildId(tie.m_20148_());
                }
            } else if (level.m_7702_(blockpos) instanceof Container) {
                BlockEntity te2 = level.m_7702_(blockpos);
                BalloonCargoEntity cargo = BalloonCargoEntity.createCargo(level, blockpos, blockstate, te2.m_187482_());
                cargo.copyContainerData((Container)te2);
                ((Container)te2).m_6211_();
                if (player != null) {
                    cargo.setPlayerUUID(player.m_20148_());
                }
                level.m_46747_(blockpos);
                cargo.setBalloonUUID(balloon.m_20148_());
                balloon.setChildId(cargo.m_20148_());
                level.m_7731_(blockpos, blockstate.m_60819_().m_76188_(), 3);
            }
            if (!level.f_46443_) {
                level.m_142346_((Entity)player, GameEvent.f_157810_, blockpos);
            }
            if (level.m_7967_((Entity)balloon)) {
                itemstack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        return this.placeBalloon(level, itemstack, blockpos, direction, player, false) ? InteractionResult.m_19078_((boolean)level.f_46443_) : InteractionResult.CONSUME;
    }
}

