/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemSorting {
    public static int defaultCompare(ItemStack stack1, ItemStack stack2) {
        if (ItemStack.m_41656_((ItemStack)stack1, (ItemStack)stack2)) {
            return 0;
        }
        if (stack1.m_41619_()) {
            return 1;
        }
        if (stack2.m_41619_()) {
            return -1;
        }
        ResourceLocation name1 = ForgeRegistries.ITEMS.getKey((Object)stack1.m_41720_());
        ResourceLocation name2 = ForgeRegistries.ITEMS.getKey((Object)stack2.m_41720_());
        int modid = name1.m_135827_().compareTo(name2.m_135827_());
        return Integer.compare(Item.m_41393_((Item)stack1.m_41720_()), Item.m_41393_((Item)stack2.m_41720_()));
    }

    public static int addItem(Container container, ItemStack stack) {
        int i = ItemSorting.getSlotWithRemainingSpace(container, stack);
        if (i == -1) {
            i = ItemSorting.getFreeSlot(container);
        }
        return i == -1 ? stack.m_41613_() : ItemSorting.addResource(container, i, stack);
    }

    public static int getSlotWithRemainingSpace(Container container, ItemStack p_36051_) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (!ItemSorting.hasRemainingSpaceForItem(container, container.m_8020_(i), p_36051_)) continue;
            return i;
        }
        return -1;
    }

    public static int getFreeSlot(Container container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (!container.m_8020_(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    private static int addResource(Container container, int p_36048_, ItemStack p_36049_) {
        Item item = p_36049_.m_41720_();
        int i = p_36049_.m_41613_();
        ItemStack itemstack = container.m_8020_(p_36048_);
        if (itemstack.m_41619_()) {
            itemstack = p_36049_.m_41777_();
            itemstack.m_41764_(0);
            if (p_36049_.m_41782_()) {
                itemstack.m_41751_(p_36049_.m_41783_().m_6426_());
            }
            container.m_6836_(p_36048_, itemstack);
        }
        int j = i;
        if (i > itemstack.m_41741_() - itemstack.m_41613_()) {
            j = itemstack.m_41741_() - itemstack.m_41613_();
        }
        if (j > container.m_6893_() - itemstack.m_41613_()) {
            j = container.m_6893_() - itemstack.m_41613_();
        }
        if (j == 0) {
            return i;
        }
        itemstack.m_41769_(j);
        itemstack.m_41754_(5);
        return i -= j;
    }

    private static boolean hasRemainingSpaceForItem(Container container, ItemStack stack1, ItemStack stack2) {
        return !stack1.m_41619_() && ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2) && stack1.m_41753_() && stack1.m_41613_() < stack1.m_41741_() && stack1.m_41613_() < container.m_6893_();
    }

    public static NonNullList<ItemStack> combineStacks(Container container, NonNullList<ItemStack> itemList) {
        NonNullList combined = NonNullList.m_122779_();
        for (ItemStack item : itemList) {
            boolean merged = false;
            for (ItemStack already : combined) {
                if (!ItemSorting.hasRemainingSpaceForItem(container, item, already)) continue;
                int combinedSize = item.m_41613_() + already.m_41613_();
                if (combinedSize > item.m_41741_()) {
                    already.m_41764_(item.m_41741_());
                    item.m_41764_(combinedSize - item.m_41741_());
                    continue;
                }
                already.m_41764_(combinedSize);
                merged = true;
                break;
            }
            if (merged) continue;
            combined.add((Object)item);
        }
        return combined;
    }
}

