/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity.ai;

import com.github.alexthe668.cloudstorage.entity.BadloonHandEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonBuddyEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonFace;
import com.github.alexthe668.cloudstorage.entity.GloveGesture;
import com.github.alexthe668.cloudstorage.misc.CSDamageTypes;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class BalloonBuddyAttackGoal
extends Goal {
    private BalloonBuddyEntity badloon;
    private int punchCooldown = 0;
    private int punchTicks = 0;

    public BalloonBuddyAttackGoal(BalloonBuddyEntity badloon) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.badloon = badloon;
    }

    public boolean m_8036_() {
        return this.badloon.m_5448_() != null && this.badloon.m_5448_().m_6084_() && this.badloon.fearOfBeingPoppedCooldown == 0 && !this.badloon.stopFlying() && !this.badloon.shouldFaceStopAttacking();
    }

    public void m_8041_() {
        this.badloon.setFace(BalloonFace.NEUTRAL);
        this.badloon.setHandGesture(GloveGesture.IDLE);
        this.punchTicks = 0;
    }

    public void m_8056_() {
        this.punchCooldown = 0;
    }

    public void m_8037_() {
        boolean moveTowardsTarget = true;
        float extraY = 1.3f;
        float distExtra = this.badloon.getPersonality() == BalloonFace.CRAZY ? 1.5f : 1.0f;
        Entity hand = this.badloon.getChild();
        if (hand == null) {
            return;
        }
        if (this.badloon.getPersonality() == BalloonFace.SCARY || this.badloon.getPersonality() == BalloonFace.EYEPATCH) {
            this.badloon.setAbilityTime(20);
        }
        if (this.punchCooldown > 0) {
            --this.punchCooldown;
        }
        if ((double)this.badloon.m_5448_().f_19789_ >= 3.0) {
            BadloonHandEntity glove;
            if (hand instanceof BadloonHandEntity && (glove = (BadloonHandEntity)hand).getGesture() != GloveGesture.FLIPOFF && glove.getGesture() != GloveGesture.WAVE) {
                this.badloon.setHandGesture(this.badloon.m_217043_().m_188503_(2) == 0 ? GloveGesture.FLIPOFF : GloveGesture.WAVE);
            }
        } else if (moveTowardsTarget) {
            float speed = this.badloon.getPersonality() == BalloonFace.CRAZY ? 1.5f : 1.0f;
            double targetX = this.badloon.m_5448_().m_20185_();
            double targetZ = this.badloon.m_5448_().m_20189_();
            if (this.badloon.f_19863_ && !this.badloon.m_20096_() && !this.badloon.m_142582_((Entity)this.badloon.m_5448_())) {
                Vec3 lookRotated = new Vec3(0.0, 0.0, 2.0).m_82524_(-this.badloon.m_146908_() * ((float)Math.PI / 180));
                targetX = this.badloon.m_20185_() + lookRotated.f_82479_;
                targetZ = this.badloon.m_20189_() + lookRotated.f_82481_;
            }
            this.badloon.m_21566_().m_6849_(targetX, this.badloon.m_5448_().m_20188_() + (double)extraY, targetZ, (double)speed);
        }
        if (this.punchCooldown == 0 && (hand.m_20270_((Entity)this.badloon.m_5448_()) < this.badloon.m_5448_().m_20205_() + distExtra || hand.m_20191_().m_82381_(this.badloon.m_5448_().m_20191_())) && this.badloon.doesDealDamage()) {
            if (this.badloon.getPersonality() == BalloonFace.TROLL && !this.badloon.m_5448_().m_20159_() && this.badloon.m_5448_().m_20096_()) {
                this.badloon.m_5448_().m_7998_(hand, true);
                this.badloon.setAbilityTime(100 + this.badloon.m_217043_().m_188503_(50));
            } else {
                ++this.punchTicks;
                this.badloon.setHandGesture(GloveGesture.PUNCH);
                if (this.punchTicks > 3) {
                    this.badloon.m_5448_().m_6469_(this.badloon.getPersonality() == BalloonFace.EYEPATCH ? CSDamageTypes.causeSneakBalloonDamage(this.badloon.m_9236_().m_9598_()) : this.badloon.m_269291_().m_269333_((LivingEntity)this.badloon), 2.0f);
                    this.badloon.setHandGesture(GloveGesture.IDLE);
                    this.punchTicks = 0;
                    this.punchCooldown = this.badloon.getPersonality() == BalloonFace.CRAZY ? 3 : 5 + this.badloon.m_217043_().m_188503_(10);
                }
            }
        }
    }

    public double getXZDistanceTo(Vec3 vec3) {
        return Mth.m_14116_((float)((float)this.badloon.m_20275_(vec3.f_82479_, this.badloon.m_20186_(), vec3.f_82481_)));
    }
}

