/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleCloudChest
extends TextureSheetParticle {
    private static final int[] POSSIBLE_COLORS = new int[]{15594742, 13687778, 12633543, 11652832};
    private final float targetX;
    private final float targetY;
    private final float targetZ;
    private final float distX;
    private final float distZ;

    private ParticleCloudChest(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, int variant) {
        super(world, x, y, z);
        int color = ParticleCloudChest.selectColor(variant, this.f_107223_);
        float lvt_18_1_ = (float)(color >> 16 & 0xFF) / 255.0f;
        float lvt_19_1_ = (float)(color >> 8 & 0xFF) / 255.0f;
        float lvt_20_1_ = (float)(color & 0xFF) / 255.0f;
        this.m_107253_(lvt_18_1_, lvt_19_1_, lvt_20_1_);
        this.targetX = (float)motionX;
        this.targetY = (float)motionY;
        this.targetZ = (float)motionZ;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107209_ = x;
        this.f_107210_ = y;
        this.f_107211_ = z;
        this.f_107663_ *= 0.4f + this.f_107223_.m_188501_() * 0.4f;
        this.f_107225_ = 25 + this.f_107223_.m_188503_(6);
        this.distX = (float)(x - (double)this.targetX);
        this.distZ = (float)(z - (double)this.targetZ);
        this.m_107271_(0.0f);
    }

    public static int selectColor(int variant, RandomSource rand) {
        return POSSIBLE_COLORS[rand.m_188503_(POSSIBLE_COLORS.length - 1)];
    }

    public void m_5989_() {
        super.m_5989_();
        float ageScale = (float)this.f_107224_ / (float)this.f_107225_;
        float radius = (1.0f - ageScale) * 4.0f;
        float angle = (float)((double)ageScale * Math.PI * 4.0);
        double extraX = this.targetX + radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = this.targetZ + radius * Mth.m_14089_((float)angle);
        double d2 = extraX - this.f_107212_;
        double d3 = ((double)this.targetY - this.f_107213_) * (double)ageScale;
        double d4 = extraZ - this.f_107214_;
        float speed = 0.07f;
        this.f_107215_ = d2 * (double)speed * (double)0.7f;
        this.f_107216_ = d3 * (double)speed * (double)0.7f;
        this.f_107217_ = d4 * (double)speed * (double)0.7f;
        if (this.f_107224_ < this.f_107225_ / 2) {
            this.m_107271_(((float)this.f_107224_ - (float)(this.f_107225_ / 2)) / (float)this.f_107225_);
        }
    }

    public void m_6257_(double x, double y, double z) {
        this.m_107259_(this.m_107277_().m_82386_(x, y, z));
        this.m_107275_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleCloudChest p = new ParticleCloudChest(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, 0);
            p.m_108335_(this.spriteSet);
            return p;
        }
    }
}

