/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.gui;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.client.ClientProxy;
import com.github.alexthe668.cloudstorage.inventory.BalloonStandMenu;
import com.github.alexthe668.cloudstorage.item.BalloonItem;
import com.github.alexthe668.cloudstorage.network.MessageRequestCloudInfo;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class BalloonStandScreen
extends AbstractContainerScreen<BalloonStandMenu> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("cloudstorage:textures/gui/balloon_stand_gui.png");
    private float cloudProgress;
    private float prevCloudProgress;
    private int lastBalloonColor = -1;
    private int tickCount = 0;

    public BalloonStandScreen(BalloonStandMenu menu, Inventory inventory, Component name) {
        super((AbstractContainerMenu)menu, inventory, name);
        this.f_97727_ = 176;
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTick) {
        this.m_280273_(guiGraphics);
        this.m_7286_(guiGraphics, partialTick, x, y);
        super.m_88315_(guiGraphics, x, y, partialTick);
        this.m_280072_(guiGraphics, x, y);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float f, int x, int y) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        float partialTicks = Minecraft.m_91087_().m_91296_();
        float cloud = (this.prevCloudProgress + (this.cloudProgress - this.prevCloudProgress) * partialTicks) / 10.0f;
        int cloudTexture = this.tickCount / 7;
        this.renderLittleCloud(guiGraphics, partialTicks, cloud * 0.8f, cloudTexture);
    }

    private void renderLittleCloud(GuiGraphics guiGraphics, float partialTick, float alpha, int cloudTexture) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        guiGraphics.m_280218_(TEXTURE, i + 7, j + 15, 176, 66, 66, 66);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void m_181908_() {
        this.prevCloudProgress = this.cloudProgress;
        ++this.tickCount;
        if (((BalloonStandMenu)this.f_97732_).m_38853_(0).m_6657_()) {
            int i = BalloonItem.getBalloonColor(((BalloonStandMenu)this.f_97732_).m_38853_(0).m_7993_());
            if (i != this.lastBalloonColor) {
                CloudStorage.NETWORK_WRAPPER.sendToServer((Object)new MessageRequestCloudInfo(i));
                this.lastBalloonColor = i;
            }
            if (this.cloudProgress < 10.0f) {
                this.cloudProgress += 1.0f;
            }
        } else if (this.cloudProgress > 0.0f) {
            this.cloudProgress -= 1.0f;
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int x, int y) {
        float cloud = this.prevCloudProgress + (this.cloudProgress - this.prevCloudProgress) * this.f_96541_.m_91296_();
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_ + 10, 0x404040, false);
        int alpha = (int)(cloud / 10.0f * 255.0f);
        if (alpha > 10) {
            int fade = FastColor.ARGB32.m_13660_((int)alpha, (int)255, (int)255, (int)255);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(0.8f, 0.8f, 0.8f);
            String color = Integer.toHexString(this.lastBalloonColor).toUpperCase(Locale.ROOT) + " RGB";
            int textColor = FastColor.ARGB32.m_13657_((int)8757938, (int)fade);
            int textX = 20;
            int textY = 30;
            int r = this.lastBalloonColor >> 16 & 0xFF;
            int g = this.lastBalloonColor >> 8 & 0xFF;
            int b = this.lastBalloonColor & 0xFF;
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"cloudstorage.container.balloon_stand.color"), textX, textY, textColor, false);
            guiGraphics.m_280056_(this.f_96547_, color, textX, textY + 10, FastColor.ARGB32.m_13660_((int)alpha, (int)r, (int)g, (int)b), false);
            MutableComponent slotsPrivate = Component.m_237110_((String)"cloudstorage.container.balloon_stand.slots", (Object[])new Object[]{ClientProxy.getCloudInt(this.lastBalloonColor, false), ClientProxy.getCloudInt(this.lastBalloonColor, true), false});
            MutableComponent slotsPublic = Component.m_237110_((String)"cloudstorage.container.balloon_stand.slots", (Object[])new Object[]{ClientProxy.getStaticCloudInt(this.lastBalloonColor, false), ClientProxy.getStaticCloudInt(this.lastBalloonColor, true), false});
            if (this.f_96547_.m_92852_((FormattedText)slotsPrivate) > 78) {
                slotsPrivate = Component.m_237113_((String)(ClientProxy.getCloudInt(this.lastBalloonColor, false) + " / " + ClientProxy.getCloudInt(this.lastBalloonColor, true)));
            }
            if (this.f_96547_.m_92852_((FormattedText)slotsPublic) > 78) {
                slotsPublic = Component.m_237113_((String)(ClientProxy.getStaticCloudInt(this.lastBalloonColor, false) + " / " + ClientProxy.getStaticCloudInt(this.lastBalloonColor, true)));
            }
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"cloudstorage.container.balloon_stand.private_slots"), textX, textY + 20, textColor, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)slotsPrivate, textX, textY + 30, textColor, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"cloudstorage.container.balloon_stand.public_slots"), textX, textY + 40, textColor, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)slotsPublic, textX, textY + 50, textColor, false);
            guiGraphics.m_280168_().m_85849_();
        }
    }
}

