/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.block;

import com.github.alexthe668.cloudstorage.client.particle.CSParticleRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CloudBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private boolean lightning;

    public CloudBlock(boolean lightning, BlockBehaviour.Properties properties) {
        super(properties);
        this.lightning = lightning;
    }

    public boolean m_6104_(BlockState state, BlockState otherState, Direction direction) {
        return otherState.m_60734_() instanceof CloudBlock ? true : super.m_6104_(state, otherState, direction);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter lvl, BlockPos pos, CollisionContext context) {
        return lvl.m_8055_(pos.m_7494_()).m_60734_() instanceof CloudBlock ? Shapes.m_83144_() : SHAPE;
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter lvl, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter lvl, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public float m_49964_() {
        return super.m_49964_() + 0.5f;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float dist) {
        entity.m_142535_(dist, 0.1f, entity.m_269291_().m_268989_());
    }

    public void m_5548_(BlockGetter blockGetter, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(blockGetter, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        if (vec3.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 0.5 : 0.2;
            entity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * d0, vec3.f_82481_);
        }
    }

    public float m_7749_(BlockState state, BlockGetter getter, BlockPos pos) {
        return 0.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rng) {
        if (this.lightning && rng.m_188503_(1) == 0) {
            Direction direction = Direction.m_235672_((RandomSource)rng);
            BlockPos blockpos = pos.m_121945_(direction);
            BlockState blockstate = level.m_8055_(blockpos);
            if (!(state.m_60815_() && blockstate.m_60783_((BlockGetter)level, blockpos, direction.m_122424_()) || blockstate.m_60734_() instanceof CloudBlock)) {
                double d0 = direction.m_122429_() == 0 ? rng.m_188500_() - 0.5 : (double)direction.m_122429_() * 0.4;
                double d1 = direction.m_122430_() == 0 ? rng.m_188500_() - 0.5 : (double)direction.m_122430_() * 0.4;
                double d2 = direction.m_122431_() == 0 ? rng.m_188500_() - 0.5 : (double)direction.m_122431_() * 0.4;
                double length = 0.2 + (double)rng.m_188501_() * 0.2;
                double d3 = d0 * length;
                double d4 = d1 * length;
                double d5 = d2 * length;
                level.m_7106_((ParticleOptions)CSParticleRegistry.STATIC_LIGHTNING.get(), (double)pos.m_123341_() + 0.5 + d0, (double)pos.m_123342_() + 0.5 + d1, (double)pos.m_123343_() + 0.5 + d2, d3, d4, d5);
            }
        }
    }
}

