/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.villager;

import com.blamejared.crafttweaker.api.action.villager.ActionTradeBase;
import com.blamejared.crafttweaker.api.villager.ITradeRemover;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;

public class ActionRemoveTrade
extends ActionTradeBase {
    private final ITradeRemover tradeRemover;
    private final List<VillagerTrades.ItemListing> removed;

    public ActionRemoveTrade(VillagerProfession profession, int level, ITradeRemover tradeRemover) {
        super(profession, level);
        this.tradeRemover = tradeRemover;
        this.removed = new ArrayList<VillagerTrades.ItemListing>();
    }

    @Override
    public void apply() {
        List<VillagerTrades.ItemListing> tradeList = this.getTradeList();
        this.apply(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void apply(List<VillagerTrades.ItemListing> tradeList) {
        tradeList.forEach(iTrade -> {
            if (this.tradeRemover.shouldRemove((VillagerTrades.ItemListing)iTrade)) {
                this.removed.add((VillagerTrades.ItemListing)iTrade);
            }
        });
        tradeList.removeAll(this.removed);
    }

    @Override
    public String describe() {
        return String.format("Removing Villager trade for Profession: '%s' and Level: '%s'", this.profession.toString(), this.level);
    }

    @Override
    public void undo() {
        List<VillagerTrades.ItemListing> tradeList = this.getTradeList();
        this.undo(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void undo(List<VillagerTrades.ItemListing> tradeList) {
        tradeList.addAll(this.removed);
    }

    @Override
    public String describeUndo() {
        return String.format("Undoing removal of Villager trade for Profession: '%s' and Level: '%s'", this.profession.toString(), this.level);
    }
}

