/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.modelfix;

import java.util.List;
import java.util.Set;
import net.mehvahdjukaar.modelfix.ModelFix;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ModelFixGeom {
    private static final ResourceLocation BLOCK_ATLAS = new ResourceLocation("textures/atlas/blocks.png");

    public static float getShrinkRatio(ResourceLocation atlasLocation, float defaultValue, float returnValue) {
        if (atlasLocation.equals((Object)BLOCK_ATLAS) && defaultValue == returnValue) {
            return (float)((double)defaultValue * ModelFix.shrinkMult.get());
        }
        return -1.0f;
    }

    public static void createOrExpandSpan(List<ItemModelGenerator.Span> listSpans, ItemModelGenerator.SpanFacing spanFacing, int pixelX, int pixelY) {
        int length;
        ItemModelGenerator.Span existingSpan = null;
        for (ItemModelGenerator.Span span2 : listSpans) {
            int i;
            if (span2.m_111683_() != spanFacing) continue;
            int n = i = spanFacing.m_111709_() ? pixelY : pixelX;
            if (span2.m_111688_() != i || ModelFix.expansion.get() != 0.0 && span2.m_111687_() != (!spanFacing.m_111709_() ? pixelY : pixelX) - 1) continue;
            existingSpan = span2;
            break;
        }
        int n = length = spanFacing.m_111709_() ? pixelX : pixelY;
        if (existingSpan == null) {
            int newStart = spanFacing.m_111709_() ? pixelY : pixelX;
            listSpans.add(new ItemModelGenerator.Span(spanFacing, length, newStart));
        } else {
            existingSpan.m_111684_(length);
        }
    }

    public static void enlargeFaces(CallbackInfoReturnable<List<BlockElement>> cir) {
        double inc = ModelFix.indent.get();
        double inc2 = ModelFix.expansion.get();
        for (BlockElement e : (List)cir.getReturnValue()) {
            Vector3f from = e.f_111308_;
            Vector3f to = e.f_111309_;
            Set set = e.f_111310_.keySet();
            if (set.size() != 1) continue;
            Direction dir = (Direction)set.stream().findAny().get();
            switch (dir) {
                case UP: {
                    from.set((double)from.x() - inc2, (double)from.y() - inc, (double)from.z() - inc2);
                    to.set((double)to.x() + inc2, (double)to.y() - inc, (double)to.z() + inc2);
                    break;
                }
                case DOWN: {
                    from.set((double)from.x() - inc2, (double)from.y() + inc, (double)from.z() - inc2);
                    to.set((double)to.x() + inc2, (double)to.y() + inc, (double)to.z() + inc2);
                    break;
                }
                case WEST: {
                    from.set((double)from.x() - inc, (double)from.y() + inc2, (double)from.z() - inc2);
                    to.set((double)to.x() - inc, (double)to.y() - inc2, (double)to.z() + inc2);
                    break;
                }
                case EAST: {
                    from.set((double)from.x() + inc, (double)from.y() + inc2, (double)from.z() - inc2);
                    to.set((double)to.x() + inc, (double)to.y() - inc2, (double)to.z() + inc2);
                }
            }
        }
    }
}

