/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.misc;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.config.BiomeGenerationConfig;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;

public class CaveTabletLootModifier
implements IGlobalLootModifier {
    private static final MapCodec<ResourceKey<Biome>> ENTRY_CODEC = ResourceKey.m_195966_((ResourceKey)Registries.f_256952_).fieldOf("biome");
    public static final Supplier<Codec<CaveTabletLootModifier>> CODEC = () -> RecordCodecBuilder.create(inst -> inst.group((App)ENTRY_CODEC.forGetter(configuration -> configuration.biome), (App)Codec.BOOL.fieldOf("replace").forGetter(configuration -> configuration.replace), (App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(lm -> lm.conditions)).apply((Applicative)inst, CaveTabletLootModifier::new));
    private final ResourceKey<Biome> biome;
    private final boolean replace;
    private final LootItemCondition[] conditions;
    private final Predicate<LootContext> orConditions;

    protected CaveTabletLootModifier(ResourceKey<Biome> biome, boolean replace, LootItemCondition[] conditionsIn) {
        this.biome = biome;
        this.replace = replace;
        this.conditions = conditionsIn;
        this.orConditions = LootItemConditions.m_81841_((Predicate[])conditionsIn);
    }

    @NotNull
    public ObjectArrayList<ItemStack> apply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        return this.orConditions.test(context) ? this.doApply(generatedLoot, context) : generatedLoot;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.m_230907_().m_188501_() < this.getChance()) {
            if (this.replace) {
                generatedLoot.clear();
            }
            generatedLoot.add((Object)this.getTablet());
        }
        return generatedLoot;
    }

    private float getChance() {
        if (this.biome == null || BiomeGenerationConfig.isBiomeDisabledCompletely(this.biome)) {
            return 0.0f;
        }
        if (this.biome.equals(ACBiomeRegistry.MAGNETIC_CAVES)) {
            return ((Double)AlexsCaves.COMMON_CONFIG.magneticTabletLootChance.get()).floatValue();
        }
        if (this.biome.equals(ACBiomeRegistry.PRIMORDIAL_CAVES)) {
            return ((Double)AlexsCaves.COMMON_CONFIG.primordialTabletLootChance.get()).floatValue();
        }
        if (this.biome.equals(ACBiomeRegistry.TOXIC_CAVES)) {
            return ((Double)AlexsCaves.COMMON_CONFIG.toxicTabletLootChance.get()).floatValue();
        }
        if (this.biome.equals(ACBiomeRegistry.ABYSSAL_CHASM)) {
            return ((Double)AlexsCaves.COMMON_CONFIG.abyssalTabletLootChance.get()).floatValue();
        }
        if (this.biome.equals(ACBiomeRegistry.FORLORN_HOLLOWS)) {
            return ((Double)AlexsCaves.COMMON_CONFIG.forlornTabletLootChance.get()).floatValue();
        }
        return 0.0f;
    }

    private ItemStack getTablet() {
        CompoundTag tag = new CompoundTag();
        ResourceKey<Biome> key = ACBiomeRegistry.MAGNETIC_CAVES;
        if (this.biome != null) {
            key = this.biome;
        }
        tag.m_128359_("CaveBiome", key.m_135782_().toString());
        ItemStack stack = new ItemStack((ItemLike)ACItemRegistry.CAVE_TABLET.get());
        stack.m_41751_(tag);
        return stack;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

