/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.UpdatesStackTags;
import com.github.alexmodguy.alexscaves.server.level.storage.ACWorldData;
import com.github.alexmodguy.alexscaves.server.message.UpdateItemTagMessage;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class CaveMapItem
extends Item
implements UpdatesStackTags {
    public static int MAP_SCALE = 7;

    public CaveMapItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!CaveMapItem.isLoading(itemstack) && !CaveMapItem.isFilled(itemstack)) {
            if (!level.f_46443_) {
                UUID uuid;
                CompoundTag tag = itemstack.m_41784_();
                if (!tag.m_128441_("MapUUID")) {
                    uuid = UUID.randomUUID();
                    tag.m_128362_("MapUUID", uuid);
                    AlexsCaves.sendMSGToAll(new UpdateItemTagMessage(player.m_19879_(), itemstack));
                } else {
                    uuid = tag.m_128342_("MapUUID");
                }
                tag.m_128379_("Loading", true);
                itemstack.m_41751_(tag);
                ACWorldData acWorldData = ACWorldData.get(level);
                if (acWorldData != null) {
                    acWorldData.fillOutCaveMap(uuid, itemstack, (ServerLevel)level, player.m_20201_().m_20183_(), player);
                }
            }
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public static ItemStack createMap(ResourceKey<Biome> biomeResourceKey) {
        ItemStack map = new ItemStack((ItemLike)ACItemRegistry.CAVE_MAP.get());
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("BiomeTargetResourceKey", biomeResourceKey.m_135782_().toString());
        map.m_41751_(tag);
        return map;
    }

    public static boolean isLoading(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_("Loading");
    }

    public static boolean isFilled(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_("Filled");
    }

    public static BlockPos getBiomeBlockPos(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return new BlockPos(stack.m_41783_().m_128451_("BiomeX"), stack.m_41783_().m_128451_("BiomeY"), stack.m_41783_().m_128451_("BiomeZ"));
        }
        return BlockPos.f_121853_;
    }

    public static int[] createBiomeArray(ItemStack stack) {
        if (stack.m_41783_() != null) {
            ListTag listTag = stack.m_41783_().m_128437_("MapBiomeList", 10);
            HashMap<Byte, Integer> integerByteMap = new HashMap<Byte, Integer>();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag innerTag = listTag.m_128728_(i);
                integerByteMap.put(innerTag.m_128445_("BiomeHash"), innerTag.m_128451_("BiomeID"));
            }
            int[] intArray = new int[16384];
            byte[] byteArray = stack.m_41783_().m_128463_("MapBiomes");
            int j = Math.min(intArray.length, byteArray.length);
            if (j > 0) {
                for (int i = 0; i < j; ++i) {
                    intArray[i] = (Integer)integerByteMap.get(byteArray[i]);
                }
            }
            return intArray;
        }
        return new int[0];
    }

    public static long getSeed(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41783_().m_128454_("RandomSeed");
        }
        return 0L;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ResourceKey<Biome> biomeResourceKey = CaveMapItem.getBiomeTarget(stack);
        if (biomeResourceKey != null) {
            String biomeName = "biome." + biomeResourceKey.m_135782_().toString().replace(":", ".");
            tooltip.add((Component)Component.m_237115_((String)biomeName).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public static ResourceKey<Biome> getBiomeTarget(ItemStack stack) {
        if (stack.m_41783_() != null) {
            String s = stack.m_41783_().m_128461_("BiomeTargetResourceKey");
            return s == null ? null : ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(s));
        }
        return null;
    }
}

