/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalBreedEggsGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalFollowOwnerGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalLayEggGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTargetClosePlayers;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTargetUntamedGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.TremorsaurusMeleeGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GrottoceratopsEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.RelicheirusEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.SubterranodonEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.KeybindUsingMount;
import com.github.alexmodguy.alexscaves.server.entity.util.ShakesScreen;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.message.MountedEntityKeyMessage;
import com.github.alexmodguy.alexscaves.server.message.UpdateEffectVisualityEntityMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.animation.LegSolver;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TremorsaurusEntity
extends DinosaurEntity
implements KeybindUsingMount,
IAnimatedEntity,
ShakesScreen {
    private static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.m_135353_(TremorsaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> HELD_MOB_ID = SynchedEntityData.m_135353_(TremorsaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TAME_ATTEMPTS = SynchedEntityData.m_135353_(TremorsaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> METER_AMOUNT = SynchedEntityData.m_135353_(TremorsaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public final LegSolver legSolver = new LegSolver(new LegSolver.Leg[]{new LegSolver.Leg(-0.45f, 0.75f, 1.0f, false), new LegSolver.Leg(-0.45f, -0.75f, 1.0f, false)});
    private Animation currentAnimation;
    private int animationTick;
    private float prevScreenShakeAmount;
    private float screenShakeAmount;
    private int lastScareTimestamp = 0;
    private boolean hasRunningAttributes = false;
    private int roarCooldown = 0;
    public static final Animation ANIMATION_SNIFF = Animation.create((int)30);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)15);
    public static final Animation ANIMATION_ROAR = Animation.create((int)55);
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SHAKE_PREY = Animation.create((int)40);
    private double lastStompX = 0.0;
    private double lastStompZ = 0.0;
    private int roarScatterTime = 0;
    private Entity riderHitEntity = null;

    public TremorsaurusEntity(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new TremorsaurusMeleeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AnimalFollowOwnerGoal(this, 1.2, 5.0f, 2.0f, false){

            @Override
            public boolean shouldFollow() {
                return TremorsaurusEntity.this.getCommand() == 2;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new AnimalBreedEggsGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new AnimalLayEggGoal((Animal)this, 100, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACBlockRegistry.COOKED_DINOSAUR_CHOP.get(), (ItemLike)ACBlockRegistry.DINOSAUR_CHOP.get()}), false));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 30));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{TremorsaurusEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new MobTargetClosePlayers((Mob)this, 50, 8.0f));
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(4, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, new MobTargetUntamedGoal<GrottoceratopsEntity>(this, GrottoceratopsEntity.class, 100, true, false, null));
        this.f_21346_.m_25352_(4, new MobTargetUntamedGoal<SubterranodonEntity>(this, SubterranodonEntity.class, 50, true, false, null));
        this.f_21346_.m_25352_(5, new MobTargetUntamedGoal<RelicheirusEntity>(this, RelicheirusEntity.class, 250, true, false, null));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RUNNING, (Object)false);
        this.f_19804_.m_135372_(HELD_MOB_ID, (Object)-1);
        this.f_19804_.m_135372_(TAME_ATTEMPTS, (Object)0);
        this.f_19804_.m_135372_(METER_AMOUNT, (Object)Float.valueOf(1.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 14.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22278_, 0.9).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22284_, 8.0);
    }

    @Override
    public void m_8119_() {
        float f;
        super.m_8119_();
        this.prevScreenShakeAmount = this.screenShakeAmount;
        this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)this.f_20883_, (float)this.m_21529_());
        this.legSolver.update((LivingEntity)this, this.f_20883_, this.m_6134_());
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.screenShakeAmount > 0.0f) {
            this.screenShakeAmount = Math.max(0.0f, this.screenShakeAmount - 0.34f);
        }
        if (this.m_20096_() && !this.isInFluidType() && this.f_267362_.m_267731_() > 0.1f && !this.m_6162_() && (double)Math.abs(f = (float)Math.cos(this.f_267362_.m_267756_() * 0.8f - 1.5f)) < 0.2) {
            if ((double)this.screenShakeAmount <= 0.3) {
                this.m_5496_((SoundEvent)ACSoundRegistry.TREMORSAURUS_STOMP.get(), 2.0f, 1.0f);
                this.shakeWater();
            }
            this.screenShakeAmount = 1.0f;
        }
        if (this.f_19797_ % 100 == 0 && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(2.0f);
        }
        if (this.isRunning() && !this.hasRunningAttributes) {
            this.hasRunningAttributes = true;
            this.m_21051_(Attributes.f_22279_).m_22100_(0.35);
        }
        if (!this.isRunning() && this.hasRunningAttributes) {
            this.hasRunningAttributes = false;
            this.m_21051_(Attributes.f_22279_).m_22100_(0.2);
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 5) {
            this.playRoarSound();
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() >= 5 && this.getAnimationTick() <= 40 && !this.m_6162_()) {
            this.screenShakeAmount = 1.0f;
            this.roarScatterTime = 30;
            if (this.getAnimationTick() % 5 == 0 && this.m_9236_().f_46443_) {
                this.shakeWater();
            }
        }
        if (this.roarScatterTime > 0) {
            --this.roarScatterTime;
            this.scareMobs();
        }
        if (this.getAnimation() == ANIMATION_SPEAK && this.getAnimationTick() == 5) {
            this.actuallyPlayAmbientSound();
        }
        if (!this.m_9236_().f_46443_) {
            LivingEntity target;
            if (this.m_20184_().m_165924_() < 0.05 && this.getAnimation() == NO_ANIMATION && !this.isDancing() && !this.m_21825_()) {
                if (this.f_19796_.m_188503_(180) == 0) {
                    this.setAnimation(ANIMATION_SNIFF);
                }
                if (this.f_19796_.m_188503_(600) == 0 && !this.m_20160_()) {
                    this.tryRoar();
                }
            }
            boolean held = false;
            if (this.riderHitEntity != null && this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() > 10 && this.getAnimationTick() <= 12 && this.m_142582_(this.riderHitEntity) && (double)this.m_20270_(this.riderHitEntity) < (double)(this.m_20205_() + this.riderHitEntity.m_20205_()) + 2.0) {
                this.riderHitEntity.m_6469_(this.riderHitEntity.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
                Entity entity = this.riderHitEntity;
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    living.m_147240_(0.5, this.m_20185_() - this.riderHitEntity.m_20185_(), this.m_20189_() - this.riderHitEntity.m_20189_());
                }
                this.riderHitEntity = null;
            }
            LivingEntity livingEntity = target = this.riderHitEntity instanceof LivingEntity ? (LivingEntity)this.riderHitEntity : this.m_5448_();
            if (target != null && target.m_6084_()) {
                float f2 = target.m_20270_((Entity)this);
                float f3 = this.m_20160_() ? 10.0f : 5.5f;
                if (f2 < f3) {
                    if (this.getAnimation() == ANIMATION_SHAKE_PREY && this.getAnimationTick() <= 35) {
                        Vec3 shakePreyPos = this.getShakePreyPos();
                        Vec3 minus = new Vec3(shakePreyPos.f_82479_ - target.m_20185_(), shakePreyPos.f_82480_ - target.m_20186_(), shakePreyPos.f_82481_ - target.m_20189_());
                        target.m_20256_(minus);
                        if (this.getAnimationTick() % 10 == 0) {
                            target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)(5 + this.m_217043_().m_188503_(2)));
                        }
                        held = true;
                        this.setHeldMobId(target.m_19879_());
                    } else if (this.getAnimation() == ANIMATION_SHAKE_PREY && this.getAnimationTick() <= 36 && target.m_20184_().m_82553_() > 1.0) {
                        target.m_20256_(target.m_20184_().m_82541_().m_82490_(0.5));
                    }
                }
            }
            if (!held && this.getHeldMobId() != -1) {
                this.setHeldMobId(-1);
                this.m_216990_((SoundEvent)ACSoundRegistry.TREMORSAURUS_THROW.get());
                this.riderHitEntity = null;
            }
        } else {
            Player player = AlexsCaves.PROXY.getClientSidePlayer();
            if (player != null && player.m_20365_((Entity)this)) {
                if (AlexsCaves.PROXY.isKeyDown(2) && this.getMeterAmount() >= 1.0f) {
                    AlexsCaves.sendMSGToServer(new MountedEntityKeyMessage(this.m_19879_(), player.m_19879_(), 2));
                }
                if (AlexsCaves.PROXY.isKeyDown(3) && (this.getAnimation() == NO_ANIMATION || this.getAnimation() == null)) {
                    AlexsCaves.sendMSGToServer(new MountedEntityKeyMessage(this.m_19879_(), player.m_19879_(), 3));
                }
            }
        }
        if (this.m_20160_()) {
            if (this.getMeterAmount() < 1.0f) {
                this.setMeterAmount(Math.min(this.getMeterAmount() + 0.0035f, 1.0f));
            }
        } else {
            this.setMeterAmount(0.0f);
        }
        if (this.roarCooldown > 0) {
            --this.roarCooldown;
        }
        this.lastStompX = this.m_20185_();
        this.lastStompZ = this.m_20189_();
    }

    private void playRoarSound() {
        if (this.m_6162_()) {
            this.m_5496_((SoundEvent)ACSoundRegistry.TREMORSAURUS_ROAR.get(), 1.0f, 1.5f);
        } else {
            this.m_5496_((SoundEvent)ACSoundRegistry.TREMORSAURUS_ROAR.get(), 4.0f, 1.0f);
        }
    }

    private void scareMobs() {
        if (this.f_19797_ - this.lastScareTimestamp > 3) {
            this.lastScareTimestamp = this.f_19797_;
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(30.0, 10.0, 30.0));
        for (LivingEntity e : list) {
            PathfinderMob mob;
            if (e.m_6095_().m_204039_(ACTagRegistry.RESISTS_TREMORSAURUS_ROAR) || this.m_7307_((Entity)e)) continue;
            if (!(!(e instanceof PathfinderMob) || (mob = (PathfinderMob)e) instanceof TamableAnimal && ((TamableAnimal)mob).m_21825_())) {
                Vec3 vec;
                mob.m_6710_(null);
                mob.m_6703_(null);
                if (mob.m_20096_()) {
                    Vec3 randomShake = new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), 0.0, (double)(this.f_19796_.m_188501_() - 0.5f)).m_82490_((double)0.1f);
                    mob.m_20256_(mob.m_20184_().m_82542_((double)0.7f, 1.0, (double)0.7f).m_82549_(randomShake));
                }
                if (this.lastScareTimestamp == this.f_19797_) {
                    mob.m_21573_().m_26573_();
                }
                if (mob.m_21573_().m_26571_() && (vec = LandRandomPos.m_148521_((PathfinderMob)mob, (int)15, (int)7, (Vec3)this.m_20182_())) != null) {
                    mob.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 2.0);
                }
            }
            if (!this.m_21824_()) continue;
            e.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0, true, true));
        }
    }

    private void shakeWater() {
        if (this.m_9236_().f_46443_) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int radius = 8;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + z * z > radius * radius) continue;
                    mutableBlockPos.m_122169_(this.m_20185_() + (double)x, this.m_20186_() + 5.0, this.m_20189_() + (double)z);
                    while (mutableBlockPos.m_123342_() > this.m_9236_().m_141937_() && this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60795_()) {
                        mutableBlockPos.m_122173_(Direction.DOWN);
                    }
                    float water = this.getWaterLevelForBlock(this.m_9236_(), (BlockPos)mutableBlockPos);
                    if (!(water > 0.0f)) continue;
                    this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.WATER_TREMOR.get(), (double)((float)mutableBlockPos.m_123341_() + 0.5f), (double)((float)mutableBlockPos.m_123342_() + water) + 0.01, (double)((float)mutableBlockPos.m_123343_() + 0.5f), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(RUNNING);
    }

    public void setRunning(boolean bool) {
        this.f_19804_.m_135381_(RUNNING, (Object)bool);
    }

    public void setHeldMobId(int i) {
        this.f_19804_.m_135381_(HELD_MOB_ID, (Object)i);
    }

    public int getHeldMobId() {
        return (Integer)this.f_19804_.m_135370_(HELD_MOB_ID);
    }

    public void setTameAttempts(int i) {
        this.f_19804_.m_135381_(TAME_ATTEMPTS, (Object)i);
    }

    public int getTameAttempts() {
        return (Integer)this.f_19804_.m_135370_(TAME_ATTEMPTS);
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82377_(3.0, 3.0, 3.0);
    }

    public Entity getHeldMob() {
        int id = this.getHeldMobId();
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    @Override
    public float getScreenShakeAmount(float partialTicks) {
        return this.prevScreenShakeAmount + (this.screenShakeAmount - this.prevScreenShakeAmount) * partialTicks;
    }

    public Vec3 getShakePreyPos() {
        Vec3 jaw = new Vec3(0.0, -0.75, 3.0);
        if (this.getAnimation() == ANIMATION_SHAKE_PREY) {
            if (this.getAnimationTick() <= 5) {
                jaw = jaw.m_82492_(0.0, (double)(1.5f * ((float)this.getAnimationTick() / 5.0f)), 0.0);
            } else if (this.getAnimationTick() < 35) {
                jaw = jaw.m_82524_(0.8f * (float)Math.cos((float)this.f_19797_ * 0.6f));
            }
        }
        Vec3 head = jaw.m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_6080_() * ((float)Math.PI / 180));
        return this.m_146892_().m_82549_(head);
    }

    public void tryRoar() {
        if (this.roarCooldown == 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ROAR);
            this.roarCooldown = 200 + this.f_19796_.m_188503_(200);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)ACEntityRegistry.TREMORSAURUS.get()).m_20615_((Level)level);
    }

    public boolean m_7757_(LivingEntity living, LivingEntity owner) {
        TremorsaurusEntity tremorsaurus;
        if (living instanceof TremorsaurusEntity && ((tremorsaurus = (TremorsaurusEntity)living).getTameAttempts() > 0 || tremorsaurus.m_21023_((MobEffect)ACEffectRegistry.STUNNED.get()))) {
            return false;
        }
        return super.m_7757_(living, owner);
    }

    @Override
    public void m_7023_(Vec3 vec3d) {
        if (this.getAnimation() == ANIMATION_ROAR || this.getAnimation() == ANIMATION_SHAKE_PREY) {
            vec3d = Vec3.f_82478_;
        }
        super.m_7023_(vec3d);
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.25f : 1.0f;
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.lastStompX), (double)0.0, (double)(this.m_20189_() - this.lastStompZ));
        float walkSpeed = 4.0f;
        if (this.m_20160_()) {
            walkSpeed = 1.5f;
        } else if (this.isRunning()) {
            walkSpeed = 2.0f;
        }
        float f2 = Math.min(f1 * walkSpeed, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public void m_8032_() {
        if (this.getAnimation() == NO_ANIMATION && !this.m_9236_().f_46443_) {
            this.setAnimation(ANIMATION_SPEAK);
        }
    }

    @Override
    public void m_6818_(BlockPos pos, boolean playing) {
        this.onClientPlayMusicDisc(this.m_19879_(), pos, playing);
    }

    public void actuallyPlayAmbientSound() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SNIFF, ANIMATION_SPEAK, ANIMATION_ROAR, ANIMATION_BITE, ANIMATION_SHAKE_PREY};
    }

    private float getWaterLevelForBlock(Level level, BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        if (state.m_60713_(Blocks.f_152476_)) {
            return (6.0f + (float)((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue() * 3.0f) / 16.0f;
        }
        if (this.f_19796_.m_188501_() < 0.33f && state.m_60819_().m_205070_(FluidTags.f_13131_)) {
            return state.m_60819_().m_76155_((BlockGetter)level, pos);
        }
        return 0.0f;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("TameAttempts", this.getTameAttempts());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setTameAttempts(compound.m_128451_("TameAttempts"));
    }

    @Override
    public BlockState createEggBlockState() {
        return ((Block)ACBlockRegistry.TREMORSAURUS_EGG.get()).m_49966_();
    }

    public float getStepHeight() {
        return 1.1f;
    }

    protected Vec3 m_274312_(Player player, Vec3 deltaIn) {
        float f = player.f_20902_ < 0.0f ? 0.5f : 1.0f;
        return new Vec3((double)(player.f_20900_ * 0.35f), 0.0, (double)(player.f_20902_ * 0.8f * f));
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        if (player.f_20902_ != 0.0f || player.f_20900_ != 0.0f) {
            this.m_19915_(player.m_146908_(), player.m_146909_() * 0.25f);
            this.m_5616_(player.m_6080_());
            this.m_6710_(null);
        }
    }

    protected float m_245547_(Player rider) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    @Override
    public boolean tamesFromHatching() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20365_(passenger) && passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            if (!this.m_146899_()) {
                Vec3 seatOffset = new Vec3(0.0, (double)0.1f, (double)0.6f).m_82524_((float)Math.toRadians(-this.f_20883_));
                passenger.m_5618_(this.f_20883_);
                passenger.f_19789_ = 0.0f;
                this.clampRotation(living, 105.0f);
                float heightBackLeft = this.legSolver.legs[0].getHeight(1.0f);
                float heightBackRight = this.legSolver.legs[1].getHeight(1.0f);
                float maxLegSolverHeight = (1.0f - ACMath.smin(1.0f - heightBackLeft, 1.0f - heightBackRight, 0.1f)) * 0.8f;
                moveFunction.m_20372_(passenger, this.m_20185_() + seatOffset.f_82479_, this.m_20186_() + seatOffset.f_82480_ + this.m_6048_() - (double)maxLegSolverHeight, this.m_20189_() + seatOffset.f_82481_);
                return;
            }
        }
        super.m_19956_(passenger, moveFunction);
    }

    public Vec3 m_7688_(LivingEntity p_20123_) {
        return new Vec3(this.m_20185_(), this.m_20191_().f_82289_, this.m_20189_());
    }

    @Override
    public boolean hasRidingMeter() {
        return true;
    }

    @Override
    public float getMeterAmount() {
        return ((Float)this.f_19804_.m_135370_(METER_AMOUNT)).floatValue();
    }

    public void setMeterAmount(float roarPower) {
        this.f_19804_.m_135381_(METER_AMOUNT, (Object)Float.valueOf(roarPower));
    }

    @Override
    public boolean onFeedMixture(ItemStack itemStack, Player player) {
        if (itemStack.m_150930_((Item)ACItemRegistry.SERENE_SALAD.get()) && this.m_21023_((MobEffect)ACEffectRegistry.STUNNED.get())) {
            this.m_21195_((MobEffect)ACEffectRegistry.STUNNED.get());
            AlexsCaves.sendMSGToAll(new UpdateEffectVisualityEntityMessage(this.m_19879_(), this.m_19879_(), 3, 0, true));
            if (!this.m_9236_().f_46443_) {
                this.setTameAttempts(this.getTameAttempts() + 1);
                if (this.getTameAttempts() > 3 && this.m_217043_().m_188503_(2) == 0 || this.getTameAttempts() > 8) {
                    this.m_21828_(player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6898_(ItemStack stack) {
        return this.m_21824_() && (stack.m_150930_(((Block)ACBlockRegistry.COOKED_DINOSAUR_CHOP.get()).m_5456_()) || stack.m_150930_(((Block)ACBlockRegistry.DINOSAUR_CHOP.get()).m_5456_()));
    }

    @Override
    public boolean canOwnerMount(Player player) {
        return !this.m_6162_();
    }

    @Override
    public boolean canOwnerCommand(Player ownerPlayer) {
        return ownerPlayer.m_6144_();
    }

    @Override
    public void onKeyPacket(Entity keyPresser, int type) {
        if (keyPresser.m_20365_((Entity)this)) {
            if (type == 2 && this.getMeterAmount() >= 1.0f && (this.getAnimation() == NO_ANIMATION || this.getAnimation() == null)) {
                this.f_20883_ = keyPresser.m_6080_();
                this.m_146922_(keyPresser.m_6080_());
                this.setAnimation(ANIMATION_ROAR);
                this.setMeterAmount(0.0f);
            }
            if (type == 3 && (this.getAnimation() == NO_ANIMATION || this.getAnimation() == null)) {
                HitResult hitresult = ProjectileUtil.m_278180_((Entity)keyPresser, entity -> !entity.m_7306_((Entity)this) && !this.m_7307_((Entity)entity), (double)10.0);
                this.m_5616_(keyPresser.m_6080_());
                this.m_146926_(keyPresser.m_146909_());
                boolean flag = false;
                if (hitresult instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)hitresult;
                    this.riderHitEntity = entityHitResult.m_82443_();
                    if (this.m_217043_().m_188499_() && this.riderHitEntity.m_20205_() < 2.0f || this.riderHitEntity instanceof FlyingAnimal) {
                        flag = true;
                    }
                } else {
                    this.riderHitEntity = null;
                }
                this.setAnimation(flag ? ANIMATION_SHAKE_PREY : ANIMATION_BITE);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.TREMORSAURUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.TREMORSAURUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.TREMORSAURUS_DEATH.get();
    }
}

