/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.ForsakenAttackGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.ForsakenRandomlyJumpGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GroundPathNavigatorNoSpin;
import com.github.alexmodguy.alexscaves.server.entity.util.ShakesScreen;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.animation.LegSolverQuadruped;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class ForsakenEntity
extends Monster
implements IAnimatedEntity,
ShakesScreen {
    private static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.m_135353_(ForsakenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEAPING = SynchedEntityData.m_135353_(ForsakenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SONIC_CHARGE = SynchedEntityData.m_135353_(ForsakenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SONAR_ID = SynchedEntityData.m_135353_(ForsakenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HELD_MOB_ID = SynchedEntityData.m_135353_(ForsakenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DARKNESS_TIME = SynchedEntityData.m_135353_(ForsakenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Animation ANIMATION_SUMMON = Animation.create((int)50);
    public static final Animation ANIMATION_PREPARE_JUMP = Animation.create((int)15);
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_LEFT_SLASH = Animation.create((int)33);
    public static final Animation ANIMATION_RIGHT_SLASH = Animation.create((int)33);
    public static final Animation ANIMATION_GROUND_SMASH = Animation.create((int)30);
    public static final Animation ANIMATION_SONIC_ATTACK = Animation.create((int)35);
    public static final Animation ANIMATION_SONIC_BLAST = Animation.create((int)45);
    public static final Animation ANIMATION_LEFT_PICKUP = Animation.create((int)48);
    public static final Animation ANIMATION_RIGHT_PICKUP = Animation.create((int)48);
    private static final int LIGHT_THRESHOLD = 4;
    private Animation currentAnimation = IAnimatedEntity.NO_ANIMATION;
    private int animationTick;
    public LegSolverQuadruped legSolver = new LegSolverQuadruped(-0.4f, 1.4f, 1.0f, 0.75f, 1.0f);
    private float runProgress;
    private float prevRunProgress;
    private float leapProgress;
    private float prevLeapProgress;
    private float leapPitch;
    private float prevLeapPitch;
    private float prevScreenShakeAmount;
    private float screenShakeAmount;
    private int timeLeaping = 0;
    private float raiseLeftArmProgress;
    private float prevRaiseLeftArmProgress;
    private float raiseRightArmProgress;
    private float prevRaiseRightArmProgress;
    private float darknessProgress;
    private float prevDarknessProgress;
    private boolean hasRunningAttributes = false;
    private int destroyBlocksTick = 10;
    public static final Predicate<LivingEntity> TARGETING = mob -> !mob.m_6095_().m_204039_(ACTagRegistry.FORSAKEN_IGNORES);

    public ForsakenEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 0.6);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RUNNING, (Object)false);
        this.f_19804_.m_135372_(LEAPING, (Object)false);
        this.f_19804_.m_135372_(SONIC_CHARGE, (Object)false);
        this.f_19804_.m_135372_(DARKNESS_TIME, (Object)0);
        this.f_19804_.m_135372_(SONAR_ID, (Object)-1);
        this.f_19804_.m_135372_(HELD_MOB_ID, (Object)-1);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ForsakenAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ForsakenRandomlyJumpGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 30));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{ForsakenEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 120, false, true, TARGETING));
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigatorNoSpin((Mob)this, level);
    }

    public void m_8119_() {
        Entity grabbedEntity;
        super.m_8119_();
        this.prevRunProgress = this.runProgress;
        this.prevLeapProgress = this.leapProgress;
        this.prevRaiseLeftArmProgress = this.raiseLeftArmProgress;
        this.prevRaiseRightArmProgress = this.raiseRightArmProgress;
        this.prevDarknessProgress = this.darknessProgress;
        this.prevLeapPitch = this.leapPitch;
        this.prevScreenShakeAmount = this.screenShakeAmount;
        this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)this.f_20883_, (float)this.m_21529_());
        if (this.isRunning() && this.runProgress < 5.0f) {
            this.runProgress += 1.0f;
        }
        if (!this.isRunning() && this.runProgress > 0.0f) {
            this.runProgress -= 1.0f;
        }
        if (this.isLeaping() && this.leapProgress < 5.0f) {
            this.leapProgress += 1.0f;
        }
        if (!this.isLeaping() && this.leapProgress > 0.0f) {
            this.leapProgress -= 1.0f;
        }
        if (this.getDarknessTime() > 0 && this.darknessProgress < 5.0f) {
            this.darknessProgress += 1.0f;
        }
        if (this.getDarknessTime() <= 0 && this.darknessProgress > 0.0f) {
            this.darknessProgress -= 1.0f;
        }
        if (this.isLeaping()) {
            if (this.m_20096_() && this.leapProgress >= 5.0f) {
                this.setLeaping(false);
            }
            ++this.timeLeaping;
            Vec3 vec3 = this.m_20184_();
            float f2 = (float)(-(Mth.m_14136_((double)vec3.f_82480_, (double)vec3.m_165924_()) * 57.2957763671875));
            this.leapPitch = Mth.m_14148_((float)this.leapPitch, (float)f2, (float)5.0f);
        } else {
            this.timeLeaping = 0;
            this.leapPitch = Mth.m_14148_((float)this.leapPitch, (float)0.0f, (float)5.0f);
            if (this.getAnimation() == ANIMATION_PREPARE_JUMP && this.m_20096_() && !this.m_9236_().f_46443_ && this.getAnimationTick() >= 8 && this.getAnimationTick() <= 10) {
                this.setLeaping(true);
                this.m_5496_((SoundEvent)ACSoundRegistry.FORSAKEN_LEAP.get(), this.m_6121_(), this.m_6100_());
            }
        }
        if (this.isRunning() && !this.hasRunningAttributes) {
            this.hasRunningAttributes = true;
            this.m_21051_(Attributes.f_22279_).m_22100_(0.45);
        }
        if (!this.isRunning() && this.hasRunningAttributes) {
            this.hasRunningAttributes = false;
            this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
        }
        boolean raisingLeftArm = this.isRaisingArm(true);
        boolean raisingRightArm = this.isRaisingArm(false);
        if (raisingLeftArm && this.raiseLeftArmProgress < 10.0f) {
            this.raiseLeftArmProgress += 1.0f;
        }
        if (!raisingLeftArm && this.raiseLeftArmProgress > 0.0f) {
            this.raiseLeftArmProgress -= 1.0f;
        }
        if (raisingRightArm && this.raiseRightArmProgress < 10.0f) {
            this.raiseRightArmProgress += 1.0f;
        }
        if (!raisingRightArm && this.raiseRightArmProgress > 0.0f) {
            this.raiseRightArmProgress -= 1.0f;
        }
        if (this.screenShakeAmount > 0.0f) {
            this.screenShakeAmount = Math.max(0.0f, this.screenShakeAmount - 0.34f);
        }
        this.legSolver.update((LivingEntity)this, this.f_20883_, this.m_6134_());
        if (this.m_9236_().f_46443_) {
            if (this.f_19796_.m_188503_(6) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.FORSAKEN_SPIT.get(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), (double)this.m_19879_(), 0.0, 0.0);
            }
            if (this.darknessProgress > 0.0f) {
                for (int i = 0; i < 1; ++i) {
                    if (this.f_19796_.m_188499_()) {
                        this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.UNDERZEALOT_MAGIC.get(), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), this.m_20185_(), this.m_20188_(), this.m_20189_());
                        continue;
                    }
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
            }
            if (this.getAnimation() == ANIMATION_SONIC_ATTACK && this.getAnimationTick() > 10 && this.getAnimationTick() < 30) {
                if (this.getAnimationTick() % 4 == 0) {
                    this.m_9236_().m_6485_((ParticleOptions)ACParticleRegistry.FORSAKEN_SONAR.get(), true, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), (double)this.m_19879_(), (double)this.m_146909_(), (double)this.m_6080_());
                }
                this.screenShakeAmount = 1.0f;
            }
            if (this.getAnimation() == ANIMATION_SONIC_BLAST && this.getAnimationTick() > 10 && this.getAnimationTick() < 30) {
                if (this.getAnimationTick() % 4 == 0) {
                    this.m_9236_().m_6485_((ParticleOptions)ACParticleRegistry.FORSAKEN_SONAR_LARGE.get(), true, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), (double)this.m_19879_(), 90.0, 0.0);
                }
                this.screenShakeAmount = 1.0f;
            }
            if (this.getAnimation() == ANIMATION_GROUND_SMASH) {
                if (this.getAnimationTick() >= 10 && this.getAnimationTick() <= 15) {
                    this.screenShakeAmount = 1.0f;
                }
                if (this.getAnimationTick() == 12) {
                    Vec3 smashPos = this.m_20182_().m_82549_(new Vec3(0.0, 0.0, 3.5).m_82524_((float)(-Math.toRadians(this.f_20883_))));
                    float radius = 1.4f;
                    float particleCount = 20 + this.f_19796_.m_188503_(12);
                    int i1 = 0;
                    while ((float)i1 < particleCount) {
                        double motionX = (double)(this.m_217043_().m_188501_() - 0.5f) * 0.7;
                        double motionY = (double)this.m_217043_().m_188501_() * 0.7 + (double)1.8f;
                        double motionZ = (double)(this.m_217043_().m_188501_() - 0.5f) * 0.7;
                        float angle = (float)Math.PI / 180 * (this.f_20883_ + (float)i1 / particleCount * 360.0f);
                        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                        double extraY = 1.2f;
                        double extraZ = radius * Mth.m_14089_((float)angle);
                        BlockPos ground = BlockPos.m_274446_((Position)ACMath.getGroundBelowPosition((BlockGetter)this.m_9236_(), new Vec3((double)Mth.m_14107_((double)(smashPos.f_82479_ + extraX)), (double)(Mth.m_14107_((double)(smashPos.f_82480_ + extraY)) + 2), (double)Mth.m_14107_((double)(smashPos.f_82481_ + extraZ)))));
                        BlockState groundState = this.m_9236_().m_8055_(ground);
                        if (groundState.m_280296_() && this.m_9236_().f_46443_) {
                            this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, groundState), true, smashPos.f_82479_ + extraX, (double)ground.m_123342_() + extraY, smashPos.f_82481_ + extraZ, motionX, motionY, motionZ);
                        }
                        ++i1;
                    }
                }
            }
        } else {
            LivingEntity target = this.m_5448_();
            if (target != null && target.m_6084_() && target.m_20270_((Entity)this) < 10.0f && this.m_142582_((Entity)target) && (this.getAnimation() == ANIMATION_RIGHT_PICKUP || this.getAnimation() == ANIMATION_LEFT_PICKUP)) {
                if (this.getHeldMobId() == -1) {
                    this.m_5496_((SoundEvent)ACSoundRegistry.FORSAKEN_GRAB.get(), this.m_6121_(), this.m_6100_());
                }
                this.setHeldMobId(target.m_19879_());
            } else if (this.getHeldMobId() != -1) {
                this.setHeldMobId(-1);
            }
            if (this.m_21223_() < this.m_21233_() * 0.5f && !this.m_9236_().f_46443_) {
                int lightLevel = this.getLightLevel();
                if (lightLevel <= 4) {
                    this.setDarknessTime(30);
                } else if (this.getDarknessTime() > 0) {
                    this.setDarknessTime(this.getDarknessTime() - 1);
                }
                if (this.getDarknessTime() > 0 && this.f_19797_ % 30 == 0) {
                    this.m_5634_(1.0f);
                }
            } else {
                this.setDarknessTime(0);
            }
        }
        if ((grabbedEntity = this.getHeldMob()) != null && grabbedEntity.m_6084_() && grabbedEntity.m_20270_((Entity)this) < 10.0f) {
            grabbedEntity.f_19789_ = 0.0f;
            if ((this.getAnimation() == ANIMATION_RIGHT_PICKUP || this.getAnimation() == ANIMATION_LEFT_PICKUP) && this.getAnimationTick() >= 10 && this.getAnimationTick() <= 38) {
                Vec3 grabPos = this.getPickupPos();
                Vec3 minus = new Vec3(grabPos.f_82479_ - grabbedEntity.m_20185_(), grabPos.f_82480_ - grabbedEntity.m_20186_(), grabPos.f_82481_ - grabbedEntity.m_20189_()).m_82490_((double)0.33f);
                grabbedEntity.m_20256_(minus);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private int getLightLevel() {
        BlockPos blockPos = this.m_20183_().m_7494_();
        return Math.max(this.m_9236_().m_45517_(LightLayer.BLOCK, blockPos), this.m_9236_().m_46803_(blockPos));
    }

    private Vec3 getPickupPos() {
        Vec3 handRotated = this.getHandPos(this.animationTick).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        return this.m_20182_().m_82549_(handRotated);
    }

    public int getDarknessTime() {
        return (Integer)this.f_19804_.m_135370_(DARKNESS_TIME);
    }

    public void setDarknessTime(int time) {
        this.f_19804_.m_135381_(DARKNESS_TIME, (Object)time);
    }

    private Vec3 getHandPos(int animationTick) {
        float sideOffset;
        float f = sideOffset = this.getAnimation() == ANIMATION_LEFT_PICKUP ? 1.0f : -1.0f;
        Vec3 hand = animationTick <= 10 ? new Vec3(0.0, 0.0, 4.0) : (animationTick <= 15 ? new Vec3(0.0, 1.0, (double)3.7f) : (animationTick <= 25 ? new Vec3((double)(sideOffset * 2.75f), (double)4.65f, (double)1.9f) : new Vec3((double)(sideOffset * 1.2f), (double)3.15f, (double)2.4f)));
        return hand;
    }

    public Entity getHeldMob() {
        int id = this.getHeldMobId();
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public boolean m_6785_(double dist) {
        return dist > 16384.0;
    }

    public static boolean checkForsakenSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return ForsakenEntity.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource) && randomSource.m_188503_(20) == 0;
    }

    private boolean isRaisingArm(boolean left) {
        if (this.currentAnimation != NO_ANIMATION && this.currentAnimation != null && this.animationTick > this.currentAnimation.getDuration() - 5) {
            return false;
        }
        if (left && (this.currentAnimation == ANIMATION_LEFT_PICKUP || this.currentAnimation == ANIMATION_LEFT_SLASH)) {
            return true;
        }
        if (!(left || this.currentAnimation != ANIMATION_RIGHT_PICKUP && this.currentAnimation != ANIMATION_RIGHT_SLASH)) {
            return true;
        }
        return this.currentAnimation == ANIMATION_SUMMON || this.currentAnimation == ANIMATION_GROUND_SMASH;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public float getRunProgress(float partialTick) {
        return (this.prevRunProgress + (this.runProgress - this.prevRunProgress) * partialTick) * 0.2f;
    }

    public boolean isLeaping() {
        return (Boolean)this.f_19804_.m_135370_(LEAPING);
    }

    public void setLeaping(boolean bool) {
        this.f_19804_.m_135381_(LEAPING, (Object)bool);
    }

    public float getLeapProgress(float partialTick) {
        return (this.prevLeapProgress + (this.leapProgress - this.prevLeapProgress) * partialTick) * 0.2f;
    }

    public void setSonarId(int i) {
        this.f_19804_.m_135381_(SONAR_ID, (Object)i);
    }

    public Entity getSonarTarget() {
        int id = (Integer)this.f_19804_.m_135370_(SONAR_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public void setHeldMobId(int i) {
        this.f_19804_.m_135381_(HELD_MOB_ID, (Object)i);
    }

    public int getHeldMobId() {
        return (Integer)this.f_19804_.m_135370_(HELD_MOB_ID);
    }

    public float getLeapPitch(float partialTick) {
        return this.prevLeapPitch + (this.leapPitch - this.prevLeapPitch) * partialTick;
    }

    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(RUNNING);
    }

    public void setRunning(boolean bool) {
        this.f_19804_.m_135381_(RUNNING, (Object)bool);
    }

    public boolean hasSonicCharge() {
        return (Boolean)this.f_19804_.m_135370_(SONIC_CHARGE);
    }

    public void setSonicCharge(boolean bool) {
        this.f_19804_.m_135381_(SONIC_CHARGE, (Object)bool);
    }

    public float getRaisedLeftArmAmount(float partialTicks) {
        return (this.prevRaiseLeftArmProgress + (this.raiseLeftArmProgress - this.prevRaiseLeftArmProgress) * partialTicks) * 0.1f;
    }

    public float getRaisedRightArmAmount(float partialTicks) {
        return (this.prevRaiseRightArmProgress + (this.raiseRightArmProgress - this.prevRaiseRightArmProgress) * partialTicks) * 0.1f;
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)0.0, (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 6.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public float getDarknessAmount(float partialTicks) {
        float animationValue = 0.0f;
        if (this.currentAnimation == ANIMATION_SUMMON) {
            animationValue = 1.0f - ((float)this.getAnimationTick() + partialTicks) / (float)ANIMATION_SUMMON.getDuration();
        }
        return Math.max((this.prevDarknessProgress + (this.darknessProgress - this.prevDarknessProgress) * partialTicks) * 0.2f, animationValue);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_5830_() && this.destroyBlocksTick > 0) {
            --this.destroyBlocksTick;
            if (this.destroyBlocksTick == 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                int j1 = Mth.m_14107_((double)this.m_20186_());
                int i2 = Mth.m_14107_((double)this.m_20185_());
                int j2 = Mth.m_14107_((double)this.m_20189_());
                boolean flag = false;
                for (int j = -1; j <= 1; ++j) {
                    for (int k2 = -1; k2 <= 1; ++k2) {
                        for (int k = 0; k <= 3; ++k) {
                            int l2 = i2 + j;
                            int l = j1 + k;
                            int i1 = j2 + k2;
                            BlockPos blockpos = new BlockPos(l2, l, i1);
                            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                            if (!blockstate.canEntityDestroy((BlockGetter)this.m_9236_(), blockpos, (Entity)this) || blockstate.m_204336_(ACTagRegistry.UNMOVEABLE) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                            flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
                        }
                    }
                }
                if (flag) {
                    this.m_9236_().m_5898_((Player)null, 1022, this.m_20183_(), 0);
                }
                this.destroyBlocksTick = 20;
            }
        }
    }

    @Override
    public float getScreenShakeAmount(float partialTicks) {
        return this.prevScreenShakeAmount + (this.screenShakeAmount - this.prevScreenShakeAmount) * partialTicks;
    }

    @Override
    public boolean canFeelShake(Entity player) {
        return true;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (damageSource.m_276093_(DamageTypes.f_268679_)) {
            this.setSonicCharge(true);
            return false;
        }
        if (damageSource.m_7639_() instanceof AbstractGolem) {
            f *= 0.5f;
        }
        return super.m_6469_(damageSource, f);
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SUMMON, ANIMATION_PREPARE_JUMP, ANIMATION_BITE, ANIMATION_LEFT_SLASH, ANIMATION_RIGHT_SLASH, ANIMATION_GROUND_SMASH, ANIMATION_SONIC_ATTACK, ANIMATION_SONIC_BLAST, ANIMATION_LEFT_PICKUP, ANIMATION_RIGHT_PICKUP};
    }

    public float getSonicDamageAgainst(LivingEntity target) {
        return target.m_6095_().m_204039_(ACTagRegistry.WEAK_TO_FORSAKEN_SONIC_ATTACK) ? 45.0f : 4.0f;
    }

    public float getStepHeight() {
        return this.hasRunningAttributes ? 1.1f : 0.6f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.FORSAKEN_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.FORSAKEN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.FORSAKEN_DEATH.get();
    }

    public float m_6121_() {
        return 2.5f;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (!this.m_6162_()) {
            this.m_5496_((SoundEvent)ACSoundRegistry.FORSAKEN_STEP.get(), 1.0f, 1.0f);
        }
    }

    protected float m_6108_() {
        return 0.98f;
    }
}

