/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneBaseEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class WaveEntity
extends Entity {
    private static final EntityDataAccessor<Boolean> SLAMMING = SynchedEntityData.m_135353_(WaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(WaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> Y_ROT = SynchedEntityData.m_135353_(WaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private float slamProgress;
    private float prevSlamProgress;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;

    public WaveEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public float getStepHeight() {
        return 2.0f;
    }

    public WaveEntity(Level level, LivingEntity shooter) {
        this((EntityType)ACEntityRegistry.WAVE.get(), level);
        this.setOwner(shooter);
    }

    public WaveEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.WAVE.get(), level);
    }

    public void setOwner(@Nullable LivingEntity living) {
        this.owner = living;
        this.ownerUUID = living == null ? null : living.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(SLAMMING, (Object)false);
        this.m_20088_().m_135372_(LIFESPAN, (Object)10);
        this.m_20088_().m_135372_(Y_ROT, (Object)Float.valueOf(0.0f));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getSlamAmount(float partialTicks) {
        return (this.prevSlamProgress + (this.slamProgress - this.prevSlamProgress) * partialTicks) * 0.1f;
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
        if (tag.m_128441_("Lifespan")) {
            this.setLifespan(tag.m_128451_("Lifespan"));
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
        compoundTag.m_128405_("Lifespan", this.getLifespan());
    }

    public float m_146908_() {
        return ((Float)this.f_19804_.m_135370_(Y_ROT)).floatValue();
    }

    public void m_146922_(float f) {
        this.f_19804_.m_135381_(Y_ROT, (Object)Float.valueOf(f));
    }

    public int getLifespan() {
        return (Integer)this.f_19804_.m_135370_(LIFESPAN);
    }

    public void setLifespan(int time) {
        this.f_19804_.m_135381_(LIFESPAN, (Object)time);
    }

    public boolean isSlamming() {
        return (Boolean)this.f_19804_.m_135370_(SLAMMING);
    }

    public void setSlamming(boolean bool) {
        this.f_19804_.m_135381_(SLAMMING, (Object)bool);
    }

    private void spawnParticleAt(float yOffset, float zOffset, float xOffset, ParticleOptions particleType) {
        Vec3 vec3 = new Vec3((double)xOffset, (double)yOffset, (double)zOffset).m_82524_((float)Math.toRadians(-this.m_146908_()));
        this.m_9236_().m_7106_(particleType, this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_, this.m_20184_().f_82479_, (double)0.1f, this.m_20184_().f_82481_);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevSlamProgress = this.slamProgress;
        if (this.isSlamming() && this.slamProgress < 10.0f) {
            this.slamProgress += 1.0f;
        }
        if (this.isSlamming() && this.slamProgress == 10.0f) {
            this.m_146870_();
        }
        if (!this.m_20068_() && !this.m_20072_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.04f, 0.0));
        }
        float f = Math.min((float)this.f_19797_ / 10.0f, 1.0f);
        Vec3 directionVec = new Vec3(0.0, 0.0, (double)(f * f * 0.2f)).m_82524_((float)Math.toRadians(-this.m_146908_()));
        if (this.m_9236_().f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
            for (int i = 0; i <= 4; ++i) {
                float xOffset = (float)i / 4.0f - 0.5f;
                this.spawnParticleAt(0.2f + this.f_19796_.m_188501_() * 0.2f, 1.2f, xOffset * 1.2f, (ParticleOptions)ACParticleRegistry.WATER_FOAM.get());
                this.spawnParticleAt(0.2f + this.f_19796_.m_188501_() * 0.2f, -0.2f, xOffset * 1.4f, (ParticleOptions)ParticleTypes.f_123769_);
            }
        } else {
            this.m_20090_();
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        if (!this.m_9236_().f_46443_) {
            this.attackEntities(this.getSlamAmount(1.0f) * 2.0f + 1.0f);
        }
        Vec3 vec3 = this.m_20184_().m_82490_((double)0.9f).m_82549_(directionVec);
        this.m_6478_(MoverType.SELF, vec3);
        this.m_20256_(vec3.m_82542_((double)0.99f, (double)0.98f, (double)0.99f));
        if (this.f_19797_ > this.getLifespan() || this.f_19797_ > 10 && this.m_20184_().m_165924_() < 0.04) {
            this.setSlamming(true);
        }
    }

    private void attackEntities(float scale) {
        AABB bashBox = this.m_20191_().m_82377_(0.5, 0.5, 0.5);
        DamageSource source = this.m_269291_().m_269299_((Entity)this, this.owner);
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, bashBox)) {
            if (this.m_7307_((Entity)entity) || entity instanceof DeepOneBaseEntity || this.owner != null && (this.owner.equals((Object)entity) || this.owner.m_7307_((Entity)entity))) continue;
            entity.m_6469_(source, scale + 1.0f);
            this.setSlamming(true);
            entity.m_147240_(0.1 + 0.5 * (double)scale, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
        }
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }
}

