/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneBaseEntity;
import com.github.alexmodguy.alexscaves.server.message.UpdateEffectVisualityEntityMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class WaterBoltEntity
extends Projectile {
    private static final EntityDataAccessor<Optional<UUID>> ARC_TOWARDS_ENTITY_UUID = SynchedEntityData.m_135353_(WaterBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> BUBBLING = SynchedEntityData.m_135353_(WaterBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private Vec3[] trailPositions = new Vec3[64];
    private int trailPointer = -1;
    private boolean spawnedSplash = false;
    private int wooshSoundTime = 0;
    private int dieIn = -1;
    private boolean playedSplashSound;

    public WaterBoltEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public WaterBoltEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.WATER_BOLT.get(), level);
    }

    public WaterBoltEntity(Level level, LivingEntity shooter) {
        this((EntityType)ACEntityRegistry.WATER_BOLT.get(), level);
        float f = shooter instanceof Player ? 0.3f : 0.1f;
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_() - (double)f, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(BUBBLING, (Object)false);
        this.m_20088_().m_135372_(ARC_TOWARDS_ENTITY_UUID, Optional.empty());
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            Entity arcTowards = this.getArcingTowards();
            if (arcTowards != null && this.f_19797_ > 3 && this.dieIn == -1 && this.m_20270_(arcTowards) > 1.5f && this.f_19797_ < 20) {
                Vec3 arcVec = arcTowards.m_20182_().m_82520_(0.0, 0.3 * (double)arcTowards.m_20206_(), 0.0).m_82546_(this.m_20182_()).m_82541_();
                this.m_20256_(this.m_20184_().m_82549_(arcVec.m_82490_((double)0.3f)));
            }
        } else {
            for (int j = 0; j < 3 + this.f_19796_.m_188503_(2); ++j) {
                this.m_9236_().m_7106_((ParticleOptions)(this.m_20072_() || this.isBubbling() ? ParticleTypes.f_123774_ : ParticleTypes.f_123804_), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, (double)-0.1f, 0.0);
            }
        }
        if (this.wooshSoundTime <= 0) {
            this.wooshSoundTime = 30 + this.m_9236_().f_46441_.m_188503_(30);
            this.m_216990_((SoundEvent)ACSoundRegistry.SEA_STAFF_WOOSH.get());
        }
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20186_() + vec3.f_82480_;
        double d2 = this.m_20189_() + vec3.f_82481_;
        this.m_37283_();
        float f = 0.99f;
        float f1 = 0.06f;
        if (this.m_9236_().m_45556_(this.m_20191_()).noneMatch(BlockBehaviour.BlockStateBase::m_60795_) && !this.m_20072_()) {
            this.m_146870_();
        } else {
            this.m_20256_(vec3.m_82490_((double)0.9f));
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.07f, 0.0));
            }
            if (this.m_9236_().f_46443_) {
                if (this.lSteps > 0) {
                    double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                    double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                    double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                    this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                    this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                    --this.lSteps;
                    this.m_6034_(d5, d6, d7);
                } else {
                    this.m_20090_();
                }
            } else {
                this.m_6034_(d0, d1, d2);
            }
        }
        Vec3 trailAt = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        if (this.trailPointer == -1) {
            Vec3 backAt = trailAt;
            for (int i = 0; i < this.trailPositions.length; ++i) {
                this.trailPositions[i] = backAt;
            }
        }
        if (++this.trailPointer == this.trailPositions.length) {
            this.trailPointer = 0;
        }
        this.trailPositions[this.trailPointer] = trailAt;
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        if (this.dieIn > 0) {
            --this.dieIn;
            if (this.dieIn == 0) {
                this.m_146870_();
            }
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        Level level;
        super.m_142687_(removalReason);
        if (!this.spawnedSplash && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnedSplash = true;
            BlockPos pos = this.m_20183_().m_7494_();
            while (this.m_9236_().m_46859_(pos) && pos.m_123342_() > this.m_9236_().m_141937_()) {
                pos = pos.m_7495_();
            }
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ACParticleRegistry.BIG_SPLASH.get()), this.m_20185_(), (double)((float)pos.m_123342_() + 1.5f), this.m_20189_(), 0, (double)1.3f, 1.0, 0.0, 1.0);
        }
    }

    public Vec3 getTrailPosition(int pointer, float partialTick) {
        if (this.m_213877_()) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x3F;
        int j = this.trailPointer - pointer - 1 & 0x3F;
        Vec3 d0 = this.trailPositions[j];
        Vec3 d1 = this.trailPositions[i].m_82546_(d0);
        return d0.m_82549_(d1.m_82490_((double)partialTick));
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        if (!this.playedSplashSound) {
            this.playedSplashSound = true;
            this.m_216990_((SoundEvent)ACSoundRegistry.SEA_STAFF_HIT.get());
        }
        if (!this.m_9236_().f_46443_ && !this.m_150171_(hitResult.m_82443_())) {
            this.damageMobs();
            if (this.dieIn == -1) {
                this.dieIn = 5;
            }
        }
    }

    private void damageMobs() {
        LivingEntity living1;
        Entity owner = this.m_19749_();
        DamageSource source = this.m_269291_().m_269299_((Entity)this, owner instanceof LivingEntity ? (living1 = (LivingEntity)owner) : null);
        AABB bashBox = this.m_20191_().m_82377_(2.0, 2.0, 2.0);
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, bashBox)) {
            if (this.m_7307_((Entity)entity) || entity instanceof DeepOneBaseEntity || !entity.m_6469_(source, 3.0f) || !this.isBubbling()) continue;
            entity.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.BUBBLED.get(), 200));
            if (entity.m_9236_().f_46443_) continue;
            AlexsCaves.sendMSGToAll(new UpdateEffectVisualityEntityMessage(entity.m_19879_(), this.m_19879_(), 1, 200));
        }
    }

    public boolean isBubbling() {
        return (Boolean)this.f_19804_.m_135370_(BUBBLING);
    }

    public void setBubbling(boolean bool) {
        this.f_19804_.m_135381_(BUBBLING, (Object)bool);
    }

    protected void m_8060_(BlockHitResult hitResult) {
        super.m_8060_(hitResult);
        if (!this.playedSplashSound) {
            this.playedSplashSound = true;
            this.m_216990_((SoundEvent)ACSoundRegistry.SEA_STAFF_HIT.get());
        }
        if (!this.m_9236_().f_46443_) {
            this.damageMobs();
            if (this.dieIn == -1) {
                this.dieIn = 5;
            }
        }
    }

    public Entity getArcingTowards() {
        UUID id = ((Optional)this.f_19804_.m_135370_(ARC_TOWARDS_ENTITY_UUID)).orElse(null);
        return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
    }

    protected void m_7378_(CompoundTag tag) {
        this.setBubbling(tag.m_128471_("Bubbling"));
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128379_("Bubbling", this.isBubbling());
    }

    public void setArcingTowards(@Nullable UUID arcingTowards) {
        this.f_19804_.m_135381_(ARC_TOWARDS_ENTITY_UUID, Optional.ofNullable(arcingTowards));
    }

    public boolean hasTrail() {
        return this.trailPointer != -1;
    }
}

