/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class SeekingArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> ARC_TOWARDS_ENTITY_ID = SynchedEntityData.m_135353_(SeekingArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SeekingArrowEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public SeekingArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType)ACEntityRegistry.SEEKING_ARROW.get(), shooter, level);
    }

    public SeekingArrowEntity(Level level, double x, double y, double z) {
        super((EntityType)ACEntityRegistry.SEEKING_ARROW.get(), x, y, z, level);
    }

    public SeekingArrowEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.SEEKING_ARROW.get(), level);
        this.m_20011_(this.m_142242_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ARC_TOWARDS_ENTITY_ID, (Object)-1);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        int id = this.getArcTowardsID();
        if (!this.f_36703_) {
            if (id == -1) {
                if (!this.m_9236_().f_46443_) {
                    Entity closest = null;
                    float boxExpandBy = Math.min(10, 3 + this.f_19797_ / 4);
                    for (Entity entity : this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_((double)boxExpandBy), x$0 -> this.m_5603_((Entity)x$0))) {
                        if (closest != null && !(entity.m_20270_((Entity)this) < closest.m_20270_((Entity)this)) || this.m_150171_(entity)) continue;
                        closest = entity;
                    }
                    if (closest != null) {
                        this.m_5496_((SoundEvent)ACSoundRegistry.SEEKING_ARROW_LOCKON.get(), 5.0f, 1.0f);
                        this.setArcTowardsID(closest.m_19879_());
                    }
                }
            } else {
                Entity arcTowards = this.m_9236_().m_6815_(id);
                if (arcTowards != null) {
                    Vec3 arcVec = arcTowards.m_20182_().m_82520_(0.0, (double)(0.65f * arcTowards.m_20206_()), 0.0).m_82546_(this.m_20182_()).m_82541_();
                    this.m_20256_(this.m_20184_().m_82490_((double)0.3f).m_82549_(arcVec.m_82490_((double)0.7f)));
                }
            }
        }
        if (this.m_9236_().f_46443_ && !this.f_36703_) {
            Vec3 center = this.m_20182_().m_82549_(this.m_20184_());
            Vec3 vec3 = center.m_82549_(new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f)));
            this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.SCARLET_SHIELD_LIGHTNING.get(), center.f_82479_, center.f_82480_, center.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        }
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ACItemRegistry.SEEKING_ARROW.get());
    }

    private int getArcTowardsID() {
        return (Integer)this.f_19804_.m_135370_(ARC_TOWARDS_ENTITY_ID);
    }

    private void setArcTowardsID(int id) {
        this.f_19804_.m_135381_(ARC_TOWARDS_ENTITY_ID, (Object)id);
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)ACSoundRegistry.SEEKING_ARROW_HIT.get();
    }
}

