/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.RaycatEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import java.util.List;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class NuclearExplosionEntity
extends Entity {
    private boolean spawnedParticle = false;
    private Stack<BlockPos> destroyingChunks = new Stack();
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(NuclearExplosionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> NO_GRIEFING = SynchedEntityData.m_135353_(NuclearExplosionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean loadingChunks = false;
    private Explosion dummyExplosion;

    public NuclearExplosionEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public NuclearExplosionEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.NUCLEAR_EXPLOSION.get(), level);
        this.m_20011_(this.m_142242_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        int chunksAffected = this.getChunksAffected();
        int radius = chunksAffected * 15;
        if (!this.spawnedParticle) {
            int particleY;
            this.spawnedParticle = true;
            for (particleY = (int)Math.ceil(this.m_20186_()); particleY > this.m_9236_().m_141937_() && (double)particleY > this.m_20186_() - (double)((float)radius / 2.0f) && this.isDestroyable(this.m_9236_().m_8055_(BlockPos.m_274561_((double)this.m_20185_(), (double)particleY, (double)this.m_20189_()))); --particleY) {
            }
            this.m_9236_().m_6485_((ParticleOptions)ACParticleRegistry.MUSHROOM_CLOUD.get(), true, this.m_20185_(), (double)(particleY + 2), this.m_20189_(), (double)this.getSize(), 0.0, 0.0);
        }
        if (this.f_19797_ > 40 && this.destroyingChunks.isEmpty()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            if (!this.m_9236_().f_46443_ && !this.isNoGriefing()) {
                if (!this.loadingChunks) {
                    this.loadingChunks = true;
                    this.loadChunksAround(true);
                }
                if (this.destroyingChunks.isEmpty()) {
                    BlockPos center = this.m_20183_();
                    int chunks = chunksAffected;
                    for (int i = -chunks; i <= chunks; ++i) {
                        for (int j = -chunks; j <= chunks; ++j) {
                            for (int k = -chunks; k <= chunks; ++k) {
                                this.destroyingChunks.push(center.m_7918_(i * 16, j * 16, k * 16));
                            }
                        }
                    }
                    this.destroyingChunks.sort((blockPos1, blockPos2) -> Double.compare(blockPos2.m_123333_((Vec3i)this.m_20183_()), blockPos1.m_123333_((Vec3i)this.m_20183_())));
                } else {
                    int tickChunkCount = Math.min(this.destroyingChunks.size(), 3);
                    for (int i = 0; i < tickChunkCount; ++i) {
                        this.removeChunk(radius);
                    }
                }
            }
            AABB killBox = this.m_20191_().m_82377_((double)((float)radius + (float)radius * 0.5f), (double)radius * 0.6, (double)((float)radius + (float)radius * 0.5f));
            float flingStrength = this.getSize() * 0.33f;
            float maximumDistance = (float)radius + (float)radius * 0.5f + 1.0f;
            for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, killBox)) {
                float dist = entity.m_20270_((Entity)this);
                float damage = this.calculateDamage(dist, maximumDistance);
                Vec3 vec3 = entity.m_20182_().m_82546_(this.m_20182_()).m_82520_(0.0, 0.3, 0.0).m_82541_();
                float playerFling = entity instanceof Player ? 0.5f * flingStrength : flingStrength;
                entity.m_20256_(vec3.m_82490_((double)(damage * 0.1f * playerFling)));
                if (damage > 0.0f) {
                    if (entity instanceof RaycatEntity) {
                        damage = 0.0f;
                    } else if (entity.m_6095_().m_204039_(ACTagRegistry.RESISTS_RADIATION)) {
                        damage *= 0.25f;
                    }
                    entity.m_6469_(ACDamageTypes.causeNukeDamage(this.m_9236_().m_9598_()), damage);
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.IRRADIATED.get(), 48000, this.getSize() <= 1.5f ? 1 : 2, false, false, true));
            }
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        if (!this.m_9236_().f_46443_ && this.loadingChunks) {
            this.loadingChunks = false;
            this.loadChunksAround(false);
        }
        super.m_142687_(removalReason);
    }

    private int getChunksAffected() {
        return (int)Math.ceil(this.getSize());
    }

    private void loadChunksAround(boolean load) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkPos chunkPos = new ChunkPos(this.m_20183_());
            int dist = Math.max(this.getChunksAffected(), serverLevel.m_7654_().m_6846_().m_11312_() / 2);
            for (int i = -dist; i <= dist; ++i) {
                for (int j = -dist; j <= dist; ++j) {
                    ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"alexscaves", (Entity)this, (int)(chunkPos.f_45578_ + i), (int)(chunkPos.f_45579_ + j), (boolean)load, (boolean)true);
                }
            }
        }
    }

    private float calculateDamage(float dist, float max) {
        float revert = (max - dist) / max;
        float baseDmg = this.getSize() <= 1.5f ? 100.0f : 100.0f + (this.getSize() - 1.5f) * 400.0f;
        return revert * baseDmg;
    }

    private void removeChunk(int radius) {
        BlockPos chunkCorner = this.destroyingChunks.pop();
        BlockPos.MutableBlockPos carve = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos carveBelow = new BlockPos.MutableBlockPos();
        carve.m_122190_((Vec3i)chunkCorner);
        carveBelow.m_122190_((Vec3i)chunkCorner);
        float itemDropModifier = 0.025f / Math.min(1.0f, this.getSize());
        if ((Integer)AlexsCaves.COMMON_CONFIG.nukeMaxBlockExplosionResistance.get() <= 0) {
            return;
        }
        if (this.dummyExplosion == null) {
            this.dummyExplosion = new Explosion(this.m_9236_(), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0f, List.of());
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 15; y >= 0; --y) {
                    BlockState state;
                    carve.m_122178_(chunkCorner.m_123341_() + x, Mth.m_14045_((int)(chunkCorner.m_123342_() + y), (int)this.m_9236_().m_141937_(), (int)this.m_9236_().m_151558_()), chunkCorner.m_123343_() + z);
                    float widthSimplexNoise1 = (ACMath.sampleNoise3D(carve.m_123341_(), carve.m_123342_(), carve.m_123343_(), (float)radius) - 0.5f) * 0.45f + 0.55f;
                    double yDist = ACMath.smin(0.6f - (float)Math.abs(this.m_20183_().m_123342_() - carve.m_123342_()) / (float)radius, 0.6f, 0.2f);
                    double distToCenter = carve.m_203202_((double)this.m_20183_().m_123341_(), (double)(carve.m_123342_() - 1), (double)this.m_20183_().m_123343_());
                    double targetRadius = yDist * (double)((float)radius + widthSimplexNoise1 * (float)radius) * (double)radius;
                    if (!(distToCenter <= targetRadius) || (state = this.m_9236_().m_8055_((BlockPos)carve)).m_60795_() && state.m_60819_().m_76178_() || !this.isDestroyable(state)) continue;
                    carveBelow.m_122178_(carve.m_123341_(), carve.m_123342_() - 1, carve.m_123343_());
                    if (((Boolean)AlexsCaves.COMMON_CONFIG.nukesSpawnItemDrops.get()).booleanValue() && this.f_19796_.m_188501_() < itemDropModifier && state.m_60819_().m_76178_()) {
                        this.m_9236_().m_46961_((BlockPos)carve, true);
                        continue;
                    }
                    state.onBlockExploded(this.m_9236_(), (BlockPos)carve, this.dummyExplosion);
                }
                if (!((double)this.f_19796_.m_188501_() < 0.15) || this.m_9236_().m_8055_((BlockPos)carveBelow).m_60795_()) continue;
                this.m_9236_().m_46597_(carveBelow.m_7494_(), Blocks.f_50083_.m_49966_());
            }
        }
    }

    private boolean isDestroyable(BlockState state) {
        return !state.m_204336_(ACTagRegistry.NUKE_PROOF) && state.m_60734_().m_7325_() < (float)((Integer)AlexsCaves.COMMON_CONFIG.nukeMaxBlockExplosionResistance.get()).intValue();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(NO_GRIEFING, (Object)false);
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public void setSize(float f) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(f));
    }

    public boolean isNoGriefing() {
        return (Boolean)this.f_19804_.m_135370_(NO_GRIEFING);
    }

    public void setNoGriefing(boolean noGriefing) {
        this.f_19804_.m_135381_(NO_GRIEFING, (Object)noGriefing);
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.loadingChunks = compoundTag.m_128471_("WasLoadingChunks");
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128379_("WasLoadingChunks", this.loadingChunks);
    }
}

