/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.server.block.AbyssalAltarBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneBaseEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class AbyssalAltarBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private ItemStack displayCopyStack = ItemStack.f_41583_;
    private float itemAngle = 0.0f;
    private float slideProgress;
    private float prevSlideProgress;
    private int popDelay = 0;
    private static final int[] slotsTop = new int[]{0};
    private ItemStack popStack;
    private LivingEntity lastInteracter;
    private UUID placingPlayer = null;
    private long lastInteractionTime = 0L;

    public AbyssalAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.ABYSSAL_ALTAR.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbyssalAltarBlockEntity entity) {
        if (level.f_46443_) {
            ItemStack itemStack = entity.m_8020_(0);
            entity.prevSlideProgress = entity.slideProgress;
            if (!itemStack.equals(entity.displayCopyStack, false)) {
                if (entity.slideProgress > 0.0f) {
                    entity.slideProgress -= 1.0f;
                } else {
                    entity.displayCopyStack = itemStack.m_41777_();
                }
            } else {
                entity.slideProgress = 0.0f;
            }
        }
        if (entity.popStack != null && !level.f_46443_ && entity.popDelay++ > 5) {
            ItemStack drop = entity.popStack.m_41777_();
            Vec3 angleAdd = new Vec3(0.0, 0.0, 1.0).m_82524_(entity.itemAngle * ((float)Math.PI / 180));
            Vec3 vec3 = Vec3.m_82512_((Vec3i)entity.f_58858_).m_82520_(0.0, 0.5, 0.0).m_82549_(angleAdd);
            ItemEntity itemEntity = new ItemEntity(level, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, drop);
            if (entity.lastInteracter != null) {
                itemEntity.m_32052_(entity.lastInteracter.m_20148_());
                boolean kill = true;
                LivingEntity livingEntity = entity.lastInteracter;
                if (livingEntity instanceof Player) {
                    boolean fullInv;
                    Player player = (Player)livingEntity;
                    boolean bl = fullInv = !AbyssalAltarBlockEntity.hasInventorySpaceFor(player.m_150109_(), drop);
                    if (!player.m_36356_(drop.m_41777_()) || player.m_150110_().f_35937_ && fullInv) {
                        kill = false;
                    }
                } else {
                    livingEntity = entity.lastInteracter;
                    if (livingEntity instanceof DeepOneBaseEntity) {
                        DeepOneBaseEntity deepOne = (DeepOneBaseEntity)livingEntity;
                        deepOne.swapItemsForAnimation(itemEntity.m_32055_());
                        deepOne.m_21008_(InteractionHand.MAIN_HAND, itemEntity.m_32055_());
                        deepOne.setAnimation(deepOne.getTradingAnimation());
                        deepOne.m_216990_(deepOne.getAdmireSound());
                        if (entity.placingPlayer != null) {
                            deepOne.addReputation(entity.placingPlayer, 5);
                            entity.placingPlayer = null;
                        }
                        kill = true;
                    }
                }
                itemEntity.m_32045_(drop);
                if (kill) {
                    entity.lastInteracter.m_21053_(itemEntity);
                    entity.lastInteracter.m_7938_((Entity)itemEntity, drop.m_41613_());
                    itemEntity.m_146870_();
                } else {
                    level.m_7967_((Entity)itemEntity);
                    itemEntity.m_32060_();
                }
            }
            entity.popStack = null;
            entity.popDelay = 0;
            entity.lastInteracter = null;
        }
    }

    private static boolean hasInventorySpaceFor(Inventory inventory, ItemStack drop) {
        return inventory.m_36050_(drop) != -1 || inventory.m_36062_() != -1;
    }

    public void onEntityInteract(LivingEntity entity, boolean flip) {
        if (flip) {
            if (((Boolean)this.m_58900_().m_61143_((Property)AbyssalAltarBlock.ACTIVE)).booleanValue()) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)AbyssalAltarBlock.ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        } else {
            this.displayCopyStack = this.m_8020_(0).m_41777_();
            if (entity instanceof DeepOneBaseEntity) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)AbyssalAltarBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
            }
        }
        Vec3 vec3 = entity.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)this.f_58858_));
        this.itemAngle = Mth.m_14177_((float)((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875)));
        this.prevSlideProgress = 5.0f;
        this.slideProgress = 5.0f;
        this.lastInteracter = entity;
        if (entity instanceof Player) {
            this.placingPlayer = entity.m_20148_();
        } else {
            this.lastInteractionTime = entity.m_9236_().m_46467_();
        }
    }

    public float getSlideProgress(float partialTick) {
        return (this.prevSlideProgress + (this.slideProgress - this.prevSlideProgress) * partialTick) * 0.2f;
    }

    public float getItemAngle() {
        return this.itemAngle;
    }

    public ItemStack getDisplayStack() {
        return this.displayCopyStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 2, 1));
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        if (!((ItemStack)this.stacks.get(index)).m_41619_()) {
            if (((ItemStack)this.stacks.get(index)).m_41613_() <= count) {
                ItemStack itemstack = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, (Object)ItemStack.f_41583_);
                return itemstack;
            }
            ItemStack itemstack = ((ItemStack)this.stacks.get(index)).m_41620_(count);
            if (((ItemStack)this.stacks.get(index)).m_41619_()) {
                this.stacks.set(index, (Object)ItemStack.f_41583_);
            }
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getStackInSlotOnClosing(int index) {
        if (!((ItemStack)this.stacks.get(index)).m_41619_()) {
            ItemStack itemstack = (ItemStack)this.stacks.get(index);
            this.stacks.set(index, (Object)itemstack);
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int index, ItemStack stack) {
        boolean flag = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)this.stacks.get(index)));
        this.stacks.set(index, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.markUpdated();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.stacks);
        if (compound.m_128441_("PopStack")) {
            this.popStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("PopStack"));
        }
        if (compound.m_128403_("PlayerUUID")) {
            this.placingPlayer = compound.m_128342_("PlayerUUID");
        }
        this.itemAngle = compound.m_128457_("Angle");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.stacks);
        if (this.popStack != null && !this.popStack.m_41619_()) {
            CompoundTag stackTag = new CompoundTag();
            this.popStack.m_41739_(stackTag);
            compound.m_128365_("PopStack", (Tag)stackTag);
        }
        if (this.placingPlayer != null) {
            compound.m_128362_("PlayerUUID", this.placingPlayer);
        }
        compound.m_128350_("Angle", this.itemAngle);
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.stacks.clear();
    }

    public int[] m_7071_(Direction side) {
        return slotsTop;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean m_8077_() {
        return false;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)packet.m_131708_(), this.stacks);
            this.itemAngle = packet.m_131708_().m_128457_("Angle");
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundtag = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)compoundtag, this.stacks, (boolean)true);
        compoundtag.m_128350_("Angle", this.itemAngle);
        return compoundtag;
    }

    public ItemStack m_8016_(int index) {
        ItemStack lvt_2_1_ = (ItemStack)this.stacks.get(index);
        if (lvt_2_1_.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.stacks.set(index, (Object)ItemStack.f_41583_);
        return lvt_2_1_;
    }

    public Component m_5446_() {
        return this.m_6820_();
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.alexsmobs.capsid");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return null;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.DOWN) {
                return this.handlers[0].cast();
            }
            return this.handlers[1].cast();
        }
        return super.getCapability(capability, facing);
    }

    private void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public boolean queueItemDrop(ItemStack copy) {
        if (this.popStack != null) {
            return false;
        }
        this.popStack = copy;
        return true;
    }

    public long getLastInteractionTime() {
        return this.lastInteractionTime;
    }
}

