/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SulfurBudBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty LIQUID_LOGGED = IntegerProperty.m_61631_((String)"liquid_logged", (int)0, (int)2);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private final Map<Direction, VoxelShape> shapeMap;

    public SulfurBudBlock(int pixWidth, int pixHeight) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_60913_(1.0f, 2.0f).m_60918_(ACSoundTypes.SULFUR).m_60977_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.UP));
        this.shapeMap = SulfurBudBlock.buildShapeMap(pixWidth, pixHeight);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        return level.m_8055_(blockpos).m_60783_((BlockGetter)level, blockpos, direction);
    }

    public void m_213898_(BlockState currentState, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        if (randomSource.m_188503_(3) == 0 && !currentState.m_60713_((Block)ACBlockRegistry.SULFUR_CLUSTER.get())) {
            BlockPos acidAbove = blockPos.m_7494_();
            while (level.m_8055_(acidAbove).m_60795_() && acidAbove.m_123342_() < level.m_151558_()) {
                acidAbove = acidAbove.m_7494_();
            }
            BlockState acidState = level.m_8055_(acidAbove);
            Block block = null;
            if (acidState.m_60713_((Block)ACBlockRegistry.ACIDIC_RADROCK.get()) || (Integer)currentState.m_61143_((Property)LIQUID_LOGGED) == 2) {
                if (currentState.m_60713_((Block)ACBlockRegistry.SULFUR_BUD_SMALL.get())) {
                    block = (Block)ACBlockRegistry.SULFUR_BUD_MEDIUM.get();
                } else if (currentState.m_60713_((Block)ACBlockRegistry.SULFUR_BUD_MEDIUM.get())) {
                    block = (Block)ACBlockRegistry.SULFUR_BUD_LARGE.get();
                } else if (currentState.m_60713_((Block)ACBlockRegistry.SULFUR_BUD_LARGE.get())) {
                    block = (Block)ACBlockRegistry.SULFUR_CLUSTER.get();
                }
            }
            if (block != null) {
                BlockState blockstate1 = (BlockState)((BlockState)block.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)currentState.m_61143_((Property)FACING)))).m_61124_((Property)LIQUID_LOGGED, (Comparable)((Integer)currentState.m_61143_((Property)LIQUID_LOGGED)));
                level.m_46597_(blockPos, blockstate1);
            }
        }
    }

    public static Map<Direction, VoxelShape> buildShapeMap(int pixWidth, int pixHeight) {
        HashMap<Direction, VoxelShape> map = new HashMap<Direction, VoxelShape>();
        map.put(Direction.UP, Block.m_49796_((double)(8 - pixWidth / 2), (double)0.0, (double)(8 - pixWidth / 2), (double)(8 + pixWidth / 2), (double)pixHeight, (double)(8 + pixWidth / 2)));
        map.put(Direction.DOWN, Block.m_49796_((double)(8 - pixWidth / 2), (double)(16 - pixHeight), (double)(8 - pixWidth / 2), (double)(8 + pixWidth / 2), (double)16.0, (double)(8 + pixWidth / 2)));
        map.put(Direction.NORTH, Block.m_49796_((double)(8 - pixWidth / 2), (double)(8 - pixWidth / 2), (double)0.0, (double)(8 + pixWidth / 2), (double)(8 + pixWidth / 2), (double)pixHeight));
        map.put(Direction.SOUTH, Block.m_49796_((double)(8 - pixWidth / 2), (double)(8 - pixWidth / 2), (double)(16 - pixHeight), (double)(8 + pixWidth / 2), (double)(8 + pixWidth / 2), (double)16.0));
        map.put(Direction.EAST, Block.m_49796_((double)0.0, (double)(8 - pixWidth / 2), (double)(8 - pixWidth / 2), (double)pixHeight, (double)(8 + pixWidth / 2), (double)(8 + pixWidth / 2)));
        map.put(Direction.WEST, Block.m_49796_((double)(16 - pixHeight), (double)(8 - pixWidth / 2), (double)(8 - pixWidth / 2), (double)16.0, (double)(8 + pixWidth / 2), (double)(8 + pixWidth / 2)));
        return map;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        int liquidType = (Integer)state.m_61143_((Property)LIQUID_LOGGED);
        if (liquidType == 1) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        } else if (liquidType == 2) {
            levelAccessor.m_186469_(blockPos, (Fluid)ACFluidRegistry.ACID_FLUID_SOURCE.get(), ((FlowingFluid)ACFluidRegistry.ACID_FLUID_SOURCE.get()).m_6718_((LevelReader)levelAccessor));
        }
        if (!levelAccessor.m_5776_()) {
            levelAccessor.m_186460_(blockPos, (Block)this, 1);
        }
        return direction == ((Direction)state.m_61143_((Property)FACING)).m_122424_() && !state.m_60710_((LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeMap.get(state.m_61143_((Property)FACING));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(SulfurBudBlock.getLiquidType(levelaccessor.m_6425_(blockpos))))).m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_6044_(BlockGetter getter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return fluid == Fluids.f_76193_ || fluid.getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get();
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos pos, BlockState blockState, FluidState fluidState) {
        int liquidType = (Integer)blockState.m_61143_((Property)LIQUID_LOGGED);
        if (liquidType == 0) {
            if (!levelAccessor.m_5776_()) {
                if (fluidState.m_76152_() == Fluids.f_76193_) {
                    levelAccessor.m_7731_(pos, (BlockState)blockState.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(1)), 3);
                } else if (fluidState.getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get()) {
                    levelAccessor.m_7731_(pos, (BlockState)blockState.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(2)), 3);
                }
                levelAccessor.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)levelAccessor));
            }
            return true;
        }
        return false;
    }

    public ItemStack m_142598_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState state) {
        int liquidType = (Integer)state.m_61143_((Property)LIQUID_LOGGED);
        if (liquidType > 0) {
            levelAccessor.m_7731_(blockPos, (BlockState)state.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(0)), 3);
            if (!state.m_60710_((LevelReader)levelAccessor, blockPos)) {
                levelAccessor.m_46961_(blockPos, true);
            }
            return new ItemStack((ItemLike)(liquidType == 1 ? Items.f_42447_ : (ItemLike)ACItemRegistry.ACID_BUCKET.get()));
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }

    public FluidState m_5888_(BlockState state) {
        int liquidType = (Integer)state.m_61143_((Property)LIQUID_LOGGED);
        return liquidType == 1 ? Fluids.f_76193_.m_76068_(false) : (liquidType == 2 ? ((FlowingFluid)ACFluidRegistry.ACID_FLUID_SOURCE.get()).m_76068_(false) : super.m_5888_(state));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{LIQUID_LOGGED, FACING});
    }

    public static int getLiquidType(FluidState fluidState) {
        if (fluidState.m_76152_() == Fluids.f_76193_) {
            return 1;
        }
        if (fluidState.getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get()) {
            return 2;
        }
        return 0;
    }

    public PushReaction getPistonPushReaction(BlockState blockState) {
        return PushReaction.DESTROY;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
    }
}

