/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.level.storage.ACWorldData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;

public class PrimalMagmaBlock
extends Block {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty PERMANENT = BooleanProperty.m_61465_((String)"permanent");

    public PrimalMagmaBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283820_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60953_(state -> 5).m_60978_(0.5f).m_60922_((state, getter, pos, entityType) -> entityType.m_20672_()).m_60982_((state, getter, pos) -> true).m_60991_((state, getter, pos) -> true).m_60918_(ACSoundTypes.FLOOD_BASALT).m_60977_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PERMANENT, (Comparable)Boolean.valueOf(false)));
    }

    public void m_141947_(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (!entity.m_20161_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(level.m_269111_().m_269047_(), 1.0f);
            entity.m_20254_(3);
        }
        super.m_141947_(level, blockPos, blockState, entity);
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.m_61143_((Property)ACTIVE)).booleanValue()) {
            if (!((Boolean)blockState.m_61143_((Property)PERMANENT)).booleanValue() && !this.isBossActive((Level)serverLevel)) {
                serverLevel.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        } else if (!((Boolean)blockState.m_61143_((Property)PERMANENT)).booleanValue() && this.isBossActive((Level)serverLevel)) {
            serverLevel.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        BlockState newState = super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
        levelAccessor.m_186460_(blockPos, (Block)this, 2);
        return newState;
    }

    private boolean isBossActive(Level level) {
        ACWorldData worldData = ACWorldData.get(level);
        if (worldData != null) {
            return worldData.isPrimordialBossActive();
        }
        return false;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && randomSource.m_188503_(5) == 0 && level.m_8055_(pos.m_7494_()).m_60795_()) {
            Vec3 center = Vec3.m_82514_((Vec3i)pos, (double)1.0).m_82520_((double)(randomSource.m_188501_() - 0.5f), 0.0, (double)(randomSource.m_188501_() - 0.5f));
            Vec3 delta = new Vec3((double)(randomSource.m_188501_() - 0.5f), (double)(randomSource.m_188501_() - 0.5f), (double)(randomSource.m_188501_() - 0.5f));
            if (randomSource.m_188501_() < 0.4f) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, center.f_82479_, center.f_82480_, center.f_82481_, delta.f_82479_, (double)0.4f + delta.f_82480_, delta.f_82481_);
                level.m_7785_(center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.2f + randomSource.m_188501_() * 0.2f, 0.75f + randomSource.m_188501_() * 0.25f, false);
            } else {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, center.f_82479_, center.f_82480_, center.f_82481_, delta.f_82479_ * (double)0.1f, (double)0.35f, delta.f_82481_ * (double)0.1f);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE, PERMANENT});
    }
}

