/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.mixin.client;

import com.github.alexmodguy.alexscaves.client.render.item.ACArmorRenderProperties;
import com.github.alexmodguy.alexscaves.server.item.CustomArmorPostRender;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidArmorLayer.class})
public abstract class HumanoidArmorLayerMixin
extends RenderLayer {
    private static final Map<String, ResourceLocation> AC_ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private ItemStack lastArmorItemStackRendered = ItemStack.f_41583_;

    @Shadow
    protected abstract void m_117125_(HumanoidModel var1, EquipmentSlot var2);

    public HumanoidArmorLayerMixin(RenderLayerParent renderLayerParent) {
        super(renderLayerParent);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/layers/HumanoidArmorLayer;renderArmorPiece(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/EquipmentSlot;ILnet/minecraft/client/model/HumanoidModel;)V"}, at={@At(value="HEAD")}, remap=true, cancellable=true)
    private void ac_renderArmorPiece(PoseStack poseStack, MultiBufferSource multiBufferSource, LivingEntity livingEntity, EquipmentSlot equipmentSlot, int light, HumanoidModel humanoidModel, CallbackInfo ci) {
        ItemStack itemstack = livingEntity.m_6844_(equipmentSlot);
        if (itemstack.m_41720_() instanceof CustomArmorPostRender) {
            ArmorItem armorItem;
            ci.cancel();
            this.lastArmorItemStackRendered = livingEntity.m_6844_(equipmentSlot);
            Item item = itemstack.m_41720_();
            if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == equipmentSlot) {
                HumanoidModel humanoidModel1;
                EntityModel entityModel = this.m_117386_();
                HumanoidModel model = entityModel instanceof HumanoidModel ? (humanoidModel1 = (HumanoidModel)entityModel) : humanoidModel;
                boolean legs = equipmentSlot == EquipmentSlot.LEGS;
                this.m_117125_(model, equipmentSlot);
                Model armorModel = ForgeHooksClient.getArmorModel((LivingEntity)livingEntity, (ItemStack)itemstack, (EquipmentSlot)equipmentSlot, (HumanoidModel)model);
                ResourceLocation texture = this.getACArmorResource(livingEntity, itemstack, equipmentSlot, null);
                ACArmorRenderProperties.renderCustomArmor(poseStack, multiBufferSource, light, this.lastArmorItemStackRendered, armorItem, armorModel, legs, texture);
            }
        }
    }

    private ResourceLocation getACArmorResource(LivingEntity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = AC_ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            AC_ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

