/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.MineGuardianModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.living.MineGuardianEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MineGuardianRenderer
extends MobRenderer<MineGuardianEntity, MineGuardianModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/mine_guardian.png");
    private static final ResourceLocation TEXTURE_SLEEPING = new ResourceLocation("alexscaves:textures/entity/mine_guardian_sleeping.png");
    private static final ResourceLocation TEXTURE_EYE = new ResourceLocation("alexscaves:textures/entity/mine_guardian_eye.png");
    private static final ResourceLocation TEXTURE_EXPLODE = new ResourceLocation("alexscaves:textures/entity/mine_guardian_explode.png");

    public MineGuardianRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new MineGuardianModel(), 0.8f);
        this.m_115326_(new LayerGlow());
    }

    protected void scale(MineGuardianEntity mob, PoseStack poseStack, float partialTicks) {
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
    }

    public ResourceLocation getTextureLocation(MineGuardianEntity entity) {
        return entity.isEyeClosed() ? TEXTURE_SLEEPING : TEXTURE;
    }

    private static void shineOriginVertex(VertexConsumer p_114220_, Matrix4f p_114221_, Matrix3f p_114092_, float xOffset, float yOffset) {
        p_114220_.m_252986_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(230, 0, 0, 230).m_7421_(xOffset + 0.5f, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void shineLeftCornerVertex(VertexConsumer p_114215_, Matrix4f p_114216_, Matrix3f p_114092_, float p_114217_, float p_114218_, float xOffset, float yOffset) {
        p_114215_.m_252986_(p_114216_, -ACMath.HALF_SQRT_3 * p_114218_, p_114217_, 0.0f).m_6122_(255, 0, 0, 0).m_7421_(xOffset, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void shineRightCornerVertex(VertexConsumer p_114224_, Matrix4f p_114225_, Matrix3f p_114092_, float p_114226_, float p_114227_, float xOffset, float yOffset) {
        p_114224_.m_252986_(p_114225_, ACMath.HALF_SQRT_3 * p_114227_, p_114226_, 0.0f).m_6122_(255, 0, 0, 0).m_7421_(xOffset + 1.0f, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    public void render(MineGuardianEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        float bodyYaw = Mth.m_14189_((float)partialTicks, (float)entityIn.f_20884_, (float)entityIn.f_20883_);
        float scanProgress = entityIn.getScanProgress(partialTicks);
        if (scanProgress > 0.0f && entityIn.m_6084_() && !entityIn.isExploding()) {
            float ticks = (float)entityIn.f_19797_ + partialTicks;
            float length = (float)((double)scanProgress * (4.0 + Math.sin(ticks * 0.2f + 2.0f)));
            float width = scanProgress * scanProgress * 1.0f;
            float extraX = (float)((double)scanProgress * (Math.sin(ticks * 0.1f) * 3.0));
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.5f, 0.0f);
            poseStack.m_252781_(Axis.f_252392_.m_252977_(bodyYaw));
            poseStack.m_252880_(extraX * 0.5f / 16.0f, 0.25f, 0.75f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(Math.sin(ticks * 0.1f) * 32.0 * (double)scanProgress)));
            ((MineGuardianModel)this.f_115290_).translateToEye(poseStack);
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_252880_(0.0f, -0.5f, 0.0f);
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f1 = posestack$pose.m_252922_();
            Matrix3f matrix3f1 = posestack$pose.m_252943_();
            VertexConsumer lightConsumer = bufferIn.m_6299_(ACRenderTypes.getSubmarineLights());
            MineGuardianRenderer.shineOriginVertex(lightConsumer, matrix4f1, matrix3f1, 0.0f, 0.0f);
            MineGuardianRenderer.shineLeftCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            MineGuardianRenderer.shineRightCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            MineGuardianRenderer.shineLeftCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    class LayerGlow
    extends RenderLayer<MineGuardianEntity, MineGuardianModel> {
        public LayerGlow() {
            super((RenderLayerParent)MineGuardianRenderer.this);
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, MineGuardianEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            float explodeProgress = entitylivingbaseIn.getExplodeProgress(partialTicks);
            if (!entitylivingbaseIn.isEyeClosed()) {
                VertexConsumer ivertexbuilder1 = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)TEXTURE_EYE));
                ((MineGuardianModel)this.m_117386_()).m_7695_(poseStack, ivertexbuilder1, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
            VertexConsumer ivertexbuilder4 = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE_EXPLODE));
            ((MineGuardianModel)this.m_117386_()).m_7695_(poseStack, ivertexbuilder4, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, explodeProgress);
        }
    }
}

