/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.goated.common;

import net.mehvahdjukaar.goated.Goated;
import net.mehvahdjukaar.goated.GoatedPlatformStuff;
import net.mehvahdjukaar.goated.common.BreakMemory;
import net.mehvahdjukaar.moonlight.api.block.IPistonMotionReact;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RamBlock
extends WaterBlock
implements IPistonMotionReact {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE_X = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_Z = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final float MAX_HARDNESS = 50.0f;

    public RamBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Z ? SHAPE_Z : SHAPE_X;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void onMoved(BlockState state, Level level, BlockPos pos, Direction direction, boolean extending, PistonMovingBlockEntity tile) {
        if (extending) {
            RamBlock.tryBreakAfterMove(state, level, pos, direction);
        }
    }

    public static void tryBreakAfterMove(BlockState state, Level level, BlockPos pos, Direction direction) {
        if (RamBlock.canBreakInDir(state, direction) && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            BlockPos toBreakPos = pos.m_121945_(direction);
            BlockState toBreak = level.m_8055_(toBreakPos);
            if (!toBreak.m_60795_() && !toBreak.m_204336_(Goated.BREAK_BLACKLIST)) {
                float blockHardness = toBreak.m_60800_((BlockGetter)level, toBreakPos);
                level.m_5594_(null, pos, SoundEvents.f_144170_, SoundSource.BLOCKS, 0.8f, level.f_46441_.m_188501_() * 0.25f + 0.65f);
                if (blockHardness < 50.0f && blockHardness != -1.0f) {
                    BreakMemory memory = GoatedPlatformStuff.getBreakMemory(sl, toBreakPos, toBreak);
                    memory.setTimestamp(level.m_46467_());
                    float speed = 6.0f;
                    int breakProgress = memory.getBreakProgress();
                    breakProgress += Mth.m_14045_((int)((int)(speed / blockHardness)), (int)1, (int)(10 - breakProgress));
                    memory.setBreakProgress(breakProgress);
                    if (breakProgress >= 10) {
                        boolean drop = !toBreak.m_60834_() || Items.f_42385_.m_8096_(toBreak);
                        level.m_46953_(toBreakPos, drop, null);
                        memory.setTimestamp(0L);
                        level.m_142346_(null, GameEvent.f_157794_, toBreakPos);
                        level.m_6801_(memory.getBreakerId(), toBreakPos, -1);
                        return;
                    }
                    level.m_6801_(memory.getBreakerId(), toBreakPos, breakProgress);
                }
                level.m_5594_(null, pos, toBreak.m_60827_().m_56778_(), SoundSource.BLOCKS, 1.25f, 0.75f);
            }
        }
    }

    private static boolean canBreakInDir(BlockState state, Direction direction) {
        Direction.Axis axis = direction.m_122434_();
        return axis == Direction.Axis.Y || axis == ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public boolean ticksWhileMoved() {
        return true;
    }

    public void moveTick(BlockState movedState, Level level, BlockPos pos, AABB aabb, PistonMovingBlockEntity tile) {
        if (tile.m_60387_()) {
            Direction dir = tile.m_60392_();
            float i = 1.0f - tile.m_60350_(0.0f);
            for (LivingEntity e : level.m_45976_(LivingEntity.class, aabb.m_82386_((double)((float)dir.m_122429_() * i), (double)((float)dir.m_122430_() * i), (double)((float)dir.m_122431_() * i)))) {
                float strength = 1.0f;
                if (!((double)(strength = (float)((double)strength * (1.0 - e.m_21133_(Attributes.f_22278_)))) > 0.0)) continue;
                e.f_19812_ = true;
                Vec3 vec3 = e.m_20184_();
                Vec3 impulse = new Vec3((double)(-dir.m_122429_()), (double)(-dir.m_122430_()), (double)(-dir.m_122431_())).m_82490_((double)strength);
                double dy = impulse.f_82480_ != 0.0 ? vec3.f_82480_ / 2.0 - impulse.f_82480_ : (e.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0 + (double)strength) : vec3.f_82480_);
                e.m_20334_(vec3.f_82479_ / 2.0 - impulse.f_82479_, dy, vec3.f_82481_ / 2.0 - impulse.f_82481_);
                e.m_6469_(level.m_269111_().m_269264_(), 1.0f);
            }
        }
    }
}

