/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.goated.common;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BreakMemory {
    public static final AtomicInteger NEXT_BREAKER_ID = new AtomicInteger();
    private static final LoadingCache<BlockPos, Integer> RESERVED_BREAKER_IDS = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<BlockPos, Integer>(){

        public Integer load(BlockPos key) {
            return null;
        }
    });
    private final BlockState state;
    private final BlockPos pos;
    private final int breakerId;
    private int breakProgress;
    private long lastTouchedTimestamp;

    public BreakMemory(BlockState state, BlockPos pos) {
        this(state, pos, 0);
    }

    public BreakMemory(BlockState state, BlockPos pos, int progress) {
        this.state = state;
        this.pos = pos;
        this.breakProgress = progress;
        Integer id = (Integer)RESERVED_BREAKER_IDS.getIfPresent((Object)pos);
        if (id == null) {
            id = 0x3FFFFFFF - NEXT_BREAKER_ID.incrementAndGet();
            RESERVED_BREAKER_IDS.put((Object)pos, (Object)id);
        }
        this.breakerId = id;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setTimestamp(long lastTouchedTimestamp) {
        this.lastTouchedTimestamp = lastTouchedTimestamp;
    }

    public long getTimestamp() {
        return this.lastTouchedTimestamp;
    }

    public int getBreakProgress() {
        return this.breakProgress;
    }

    public void setBreakProgress(int breakProgress) {
        this.breakProgress = breakProgress;
    }

    public BlockState getState() {
        return this.state;
    }

    public int getBreakerId() {
        return this.breakerId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BreakMemory that = (BreakMemory)obj;
        return Objects.equals(this.state, that.state) && Objects.equals(this.breakerId, that.breakerId) && Objects.equals(this.breakProgress, that.breakProgress);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.breakerId, this.breakProgress);
    }

    public CompoundTag save() {
        CompoundTag c = new CompoundTag();
        c.m_128376_("progress", (short)this.breakProgress);
        c.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
        return c;
    }

    public static BreakMemory load(CompoundTag c, Level level) {
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)c.m_128469_("pos"));
        short progress = c.m_128448_("progress");
        BreakMemory m = new BreakMemory(level.m_8055_(pos), pos, progress);
        m.setTimestamp(level.m_46467_());
        return m;
    }
}

