/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.events;

import com.alexander.whatareyouvotingfor.capabilities.WolfArmour;
import com.alexander.whatareyouvotingfor.capabilities.WolfArmourProvider;
import com.alexander.whatareyouvotingfor.init.ItemInit;
import com.alexander.whatareyouvotingfor.network.Messages;
import com.alexander.whatareyouvotingfor.network.SyncWolfArmourToClientPacket;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="whatareyouvotingfor")
public class HandleWolfArmourEvents {
    public static List<WolfArmourUpdate> armourUpdates = Lists.newArrayList();
    private static final UUID ARMOURED_ARMOR_MODIFIER_UUID = UUID.fromString("915e8347-75e9-4249-88c2-e9372cbc6c48");
    private static final AttributeModifier ARMOURED_ARMOR_MODIFIER = new AttributeModifier(ARMOURED_ARMOR_MODIFIER_UUID, "Armoured armor bonus", 7.0, AttributeModifier.Operation.ADDITION);

    @SubscribeEvent
    public static void syncToClient(LivingEvent.LivingTickEvent event) {
        LazyOptional capability;
        Player player = event.getEntity().m_9236_().m_45930_((Entity)event.getEntity(), 5000.0);
        if (event.getEntity() != null && event.getEntity() instanceof Wolf && !event.getEntity().m_9236_().f_46443_ && player != null && event.getEntity().m_6000_(player.m_20185_(), player.m_20186_(), player.m_20189_()) && event.getEntity().f_19797_ % 20 == 0 && (capability = event.getEntity().getCapability(WolfArmourProvider.WOLF_ARMOUR)).isPresent() && capability.resolve().get() != null) {
            Messages.sendToAllPlayers(new SyncWolfArmourToClientPacket(event.getEntity().m_19879_(), ((WolfArmour)capability.resolve().get()).hasArmour()));
        }
    }

    @SubscribeEvent
    public static void handleUpdates(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof Wolf && event.getEntity().m_9236_().f_46443_) {
            WolfArmourUpdate updateToRemove = null;
            for (WolfArmourUpdate update : armourUpdates) {
                LazyOptional capability;
                if (update.entityID != event.getEntity().m_19879_() || !(capability = event.getEntity().getCapability(WolfArmourProvider.WOLF_ARMOUR)).isPresent() || capability.resolve().get() == null) continue;
                ((WolfArmour)capability.resolve().get()).setHasArmour(update.hasArmour);
                updateToRemove = update;
            }
            if (updateToRemove != null && armourUpdates.contains(updateToRemove)) {
                armourUpdates.remove(updateToRemove);
            }
        }
    }

    @SubscribeEvent
    public static void applyArmouredAttributes(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof Wolf && !event.getEntity().m_9236_().f_46443_) {
            @NotNull LazyOptional capability = event.getEntity().getCapability(WolfArmourProvider.WOLF_ARMOUR);
            if (capability.isPresent() && capability.resolve().get() != null && ((WolfArmour)capability.resolve().get()).hasArmour()) {
                if (!((Wolf)event.getEntity()).m_21051_(Attributes.f_22284_).m_22109_(ARMOURED_ARMOR_MODIFIER)) {
                    ((Wolf)event.getEntity()).m_21051_(Attributes.f_22284_).m_22125_(ARMOURED_ARMOR_MODIFIER);
                }
            } else if (((Wolf)event.getEntity()).m_21051_(Attributes.f_22284_).m_22109_(ARMOURED_ARMOR_MODIFIER)) {
                ((Wolf)event.getEntity()).m_21051_(Attributes.f_22284_).m_22130_(ARMOURED_ARMOR_MODIFIER);
            }
        }
    }

    @SubscribeEvent
    public static void applyArmouredAttributes(LivingDeathEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof Wolf && !event.getEntity().m_9236_().f_46443_) {
            event.getEntity().getCapability(WolfArmourProvider.WOLF_ARMOUR).ifPresent(capability -> {
                if (capability.hasArmour()) {
                    event.getEntity().m_19998_((ItemLike)ItemInit.WOLF_ARMOUR.get());
                }
            });
        }
    }

    public static void addNewUpdate(int entityID, boolean hasArmour) {
        armourUpdates.add(new WolfArmourUpdate(entityID, hasArmour));
    }

    public static class WolfArmourUpdate {
        public int entityID;
        public boolean hasArmour;

        public WolfArmourUpdate(int entityID, boolean hasArmour) {
            this.entityID = entityID;
            this.hasArmour = hasArmour;
        }
    }
}

