/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor;

import com.alexander.whatareyouvotingfor.entities.Armadillo;
import com.alexander.whatareyouvotingfor.entities.Crab;
import com.alexander.whatareyouvotingfor.entities.Penguin;
import com.alexander.whatareyouvotingfor.events.WolfArmourEvents;
import com.alexander.whatareyouvotingfor.init.BlockInit;
import com.alexander.whatareyouvotingfor.init.EntityTypeInit;
import com.alexander.whatareyouvotingfor.init.ItemInit;
import com.alexander.whatareyouvotingfor.network.Messages;
import com.mojang.logging.LogUtils;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="whatareyouvotingfor")
public class WhatAreYouVotingFor {
    public static final String MODID = "whatareyouvotingfor";
    private static final Logger LOGGER = LogUtils.getLogger();

    public WhatAreYouVotingFor() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::addAttributes);
        modEventBus.addListener(this::registerSpawns);
        WolfArmourEvents.setup();
        EntityTypeInit.ENTITY_TYPES.register(modEventBus);
        BlockInit.BLOCKS.register(modEventBus);
        ItemInit.ITEMS.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    private void addAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)EntityTypeInit.CRAB.get(), Crab.createAttributes().m_22265_());
        event.put((EntityType)EntityTypeInit.ARMADILLO.get(), Armadillo.createAttributes().m_22265_());
        event.put((EntityType)EntityTypeInit.PENGUIN.get(), Penguin.createAttributes().m_22265_());
    }

    private void registerSpawns(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)EntityTypeInit.CRAB.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE, Crab::canSpawn, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)EntityTypeInit.ARMADILLO.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE, Armadillo::canSpawn, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)EntityTypeInit.PENGUIN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE, Penguin::canSpawn, SpawnPlacementRegisterEvent.Operation.AND);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Messages.register();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(ItemInit.CRAB_CLAW);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256731_) {
            event.accept(ItemInit.CRAB_SPAWN_EGG);
            event.accept(ItemInit.ARMADILLO_SPAWN_EGG);
            event.accept(ItemInit.PENGUIN_SPAWN_EGG);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256968_) {
            event.accept(ItemInit.ARMADILLO_SCUTE);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256797_) {
            event.accept(ItemInit.WOLF_ARMOUR);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256776_) {
            event.accept(ItemInit.PENGUIN_EGG);
        }
    }
}

