/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.insanelib.util.MathHelper;
import insane96mcp.progressivebosses.module.wither.entity.WitherMinion;
import insane96mcp.progressivebosses.setup.PBEntities;
import insane96mcp.progressivebosses.setup.Strings;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Label(name="Minions", description="Wither will spawn deadly Minions")
@LoadFeature(module="progressivebosses:wither")
public class MinionFeature
extends Feature {
    @Config(min=0.0)
    @Label(name="Minion at Difficulty", description="At which difficulty the Wither starts spawning Minions")
    public static Integer minionAtDifficulty = 1;
    @Config(min=0.0)
    @Label(name="Bonus Minion Every Difficulty", description="As the Wither starts spawning Minions, every how much difficulty the Wither will spawn one more Minion")
    public static Integer bonusMinionEveryDifficulty = 1;
    @Config(min=0.0)
    @Label(name="Max Minions Spawned", description="Maximum Minions spawned by the Wither")
    public static Integer maxSpawned = 6;
    @Config(min=0.0)
    @Label(name="Max Minions Around", description="Maximum amount of Minions that can be around the Wither in a 16 block radius. After this number is reached the Wither will stop spawning minions. Set to 0 to disable this check")
    public static Integer maxAround = 18;
    @Config(min=0.0)
    @Label(name="Minimum Cooldown", description="Minimum ticks (20 ticks = 1 seconds) after Minions can spawn.")
    public static Integer minCooldown = 400;
    @Config(min=0.0)
    @Label(name="Maximum Cooldown", description="Maximum ticks (20 ticks = 1 seconds) after Minions can spawn.")
    public static Integer maxCooldown = 800;
    @Config(min=0.0)
    @Label(name="Cooldown Multiplier Below Half Health", description="Min and Max cooldowns are multiplied by this value when the Wither drops below half health. Set to 1 to not change the cooldown when the wither's health drops below half.")
    public static Double cooldownMultiplierBelowHalfHealth = 0.5;
    @Config(min=0.0)
    @Label(name="Bonus Movement Speed Per Difficulty", description="Percentage bonus speed at max difficulty.")
    public static Double bonusSpeed = 0.25;
    @Config(min=0.0)
    @Label(name="Magic Damage Taken Multiplier", description="Wither Minions will take magic damage multiplied by this value.")
    public static Double magicDamageMultiplier = 3.0;
    @Config
    @Label(name="Kill Minions on Wither Death", description="Wither Minions will die when the Wither that summoned them dies.")
    public static Boolean killMinionOnWitherDeath = true;
    @Config(min=0.0, max=1.0)
    @Label(name="Equipment.Bow Chance Above Half Health", description="Chance for the Wither Minion to spawn with a bow instead of a Stone Sword when Wither's above Half Health.")
    public static Double aboveHalfHealthBowChance = 0.6;
    @Config(min=0.0, max=1.0)
    @Label(name="Equipment.Bow Chance Below Half Health", description="Chance for the Wither Minion to spawn with a bow instead of a Stone Sword when Wither's below Half Health.")
    public static Double belowHalfHealthBowChance = 0.08;
    @Config(min=0.0, max=127.0)
    @Label(name="Equipment.Enchantments.Sharpness Chance", description="Chance (at max difficulty) for the Wither Minion's Sword to be enchanted with Sharpness. Note that every 100% chance adds one guaranteed level of the enchantment, while the remaining dictates the chance to add on more level.")
    public static Double sharpnessChance = 2.4;
    @Config(min=0.0, max=127.0)
    @Label(name="Equipment.Enchantments.Knockback Chance", description="Chance (at max difficulty) for the Wither Minion's Sword to be enchanted with Knockback. Note that every 100% chance adds one guaranteed level of the enchantment, while the remaining dictates the chance to add on more level.")
    public static Double knockbackChance = 2.4;
    @Config(min=0.0, max=127.0)
    @Label(name="Equipment.Enchantments.Power Chance", description="Chance (at max difficulty) for the Wither Minion's Bow to be enchanted with Power. Note that every 100% chance adds one guaranteed level of the enchantment, while the remaining dictates the chance to add on more level.")
    public static Double powerChance = 3.2;
    @Config(min=0.0, max=127.0)
    @Label(name="Equipment.Enchantments.Punch Chance", description="Chance (at max difficulty) for the Wither Minion's Bow to be enchanted with Punch. Note that every 100% chance adds one guaranteed level of the enchantment, while the remaining dictates the chance to add on more level.")
    public static Double punchChance = 1.5;

    public MinionFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        if (minCooldown > maxCooldown) {
            minCooldown = maxCooldown;
        }
    }

    @SubscribeEvent
    public void onWitherSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || !((entity = event.getEntity()) instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        CompoundTag witherTags = wither.getPersistentData();
        int cooldown = (int)((double)Mth.m_216271_((RandomSource)wither.m_9236_().f_46441_, (int)minCooldown, (int)maxCooldown) * cooldownMultiplierBelowHalfHealth);
        witherTags.m_128405_("progressivebosses:wither_minion_cooldown", cooldown);
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingTickEvent event) {
        BlockPos pos2;
        LivingEntity livingEntity;
        if (event.getEntity().m_9236_().f_46443_ || !this.isEnabled() || !((livingEntity = event.getEntity()) instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)livingEntity;
        Level world = event.getEntity().m_9236_();
        CompoundTag witherTags = wither.getPersistentData();
        float difficulty = witherTags.m_128457_("progressivebosses:difficulty");
        if (difficulty < (float)minionAtDifficulty.intValue() || wither.m_21223_() <= 0.0f || wither.m_31502_() > 0) {
            return;
        }
        int cooldown = witherTags.m_128451_("progressivebosses:wither_minion_cooldown");
        if (cooldown > 0) {
            witherTags.m_128405_("progressivebosses:wither_minion_cooldown", cooldown - 1);
            return;
        }
        int radius = 32;
        BlockPos pos1 = wither.m_20183_().m_7918_(-radius, -radius, -radius);
        AABB bb = new AABB(pos1, pos2 = wither.m_20183_().m_7918_(radius, radius, radius));
        List players = world.m_45976_(ServerPlayer.class, bb);
        if (players.isEmpty()) {
            return;
        }
        List minionsInAABB = world.m_45976_(WitherMinion.class, wither.m_20191_().m_82400_(16.0));
        int minionsCountInAABB = minionsInAABB.size();
        if (minionsCountInAABB >= maxAround) {
            return;
        }
        cooldown = Mth.m_216271_((RandomSource)world.f_46441_, (int)minCooldown, (int)maxCooldown);
        if (wither.m_7090_()) {
            cooldown = (int)((double)cooldown * cooldownMultiplierBelowHalfHealth);
        }
        witherTags.m_128405_("progressivebosses:wither_minion_cooldown", cooldown - 1);
        int minionSpawnedCount = 0;
        int i = minionAtDifficulty;
        while ((float)i <= difficulty) {
            int x = 0;
            int y = 0;
            int z = 0;
            for (int t = 0; t < 5; ++t) {
                x = (int)(wither.m_20185_() + (double)Mth.m_216271_((RandomSource)world.f_46441_, (int)-3, (int)3));
                y = (int)(wither.m_20186_() + 3.0);
                z = (int)(wither.m_20189_() + (double)Mth.m_216271_((RandomSource)world.f_46441_, (int)-3, (int)3));
                y = MCUtils.getFittingY((EntityType)((EntityType)PBEntities.WITHER_MINION.get()), (BlockPos)new BlockPos(x, y, z), (Level)world, (int)8);
                if (y != -1) break;
            }
            if (y > wither.m_9236_().m_141937_()) {
                WitherMinion witherMinion = MinionFeature.summonMinion(world, new Vec3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), DifficultyHelper.getScalingDifficulty((LivingEntity)wither), wither.m_7090_());
                ListTag minionsList = witherTags.m_128437_("progressivebosses:minions", 10);
                CompoundTag uuid = new CompoundTag();
                uuid.m_128362_("uuid", witherMinion.m_20148_());
                minionsList.add((Object)uuid);
                witherTags.m_128365_("progressivebosses:minions", (Tag)minionsList);
                if (++minionSpawnedCount >= maxSpawned || ++minionsCountInAABB >= maxAround) break;
            }
            i += bonusMinionEveryDifficulty.intValue();
        }
    }

    @SubscribeEvent
    public void onMinionDamage(LivingDamageEvent event) {
        if (!this.isEnabled() || magicDamageMultiplier == 0.0 || !(event.getEntity() instanceof WitherMinion) || !event.getSource().m_276093_(DamageTypes.f_268515_) && !event.getSource().m_276093_(DamageTypes.f_268530_)) {
            return;
        }
        event.setAmount((float)((double)event.getAmount() * magicDamageMultiplier));
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (event.getEntity().m_9236_().f_46443_ || !this.isEnabled() || !killMinionOnWitherDeath.booleanValue() || !((livingEntity = event.getEntity()) instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)livingEntity;
        ServerLevel world = (ServerLevel)wither.m_9236_();
        CompoundTag tags = wither.getPersistentData();
        ListTag minionsList = tags.m_128437_("progressivebosses:minions", 10);
        for (int i = 0; i < minionsList.size(); ++i) {
            UUID uuid = minionsList.m_128728_(i).m_128342_("uuid");
            WitherMinion witherMinion = (WitherMinion)world.m_8791_(uuid);
            if (witherMinion == null) continue;
            witherMinion.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 10000, 0, false, false));
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        Entity entity;
        if (event.getEntity().m_9236_().f_46443_ || !this.isEnabled() || !((entity = event.getSource().m_7639_()) instanceof WitherMinion)) {
            return;
        }
        WitherMinion witherMinion = (WitherMinion)entity;
        LivingEntity livingEntity = event.getEntity();
        boolean hasPlantedRose = false;
        if (ForgeEventFactory.getMobGriefingEvent((Level)witherMinion.m_9236_(), (Entity)witherMinion)) {
            BlockPos blockpos = livingEntity.m_20183_();
            BlockState blockstate = Blocks.f_50070_.m_49966_();
            if (livingEntity.m_9236_().m_46859_(blockpos) && blockstate.m_60710_((LevelReader)livingEntity.m_9236_(), blockpos)) {
                livingEntity.m_9236_().m_7731_(blockpos, blockstate, 3);
                hasPlantedRose = true;
            }
        }
        if (!hasPlantedRose) {
            ItemEntity itementity = new ItemEntity(livingEntity.m_9236_(), livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), new ItemStack((ItemLike)Items.f_41951_));
            livingEntity.m_9236_().m_7967_((Entity)itementity);
        }
    }

    private static void setEquipment(WitherMinion witherMinion, float scalingDifficulty, boolean isCharged) {
        ItemStack item;
        witherMinion.m_21409_(EquipmentSlot.MAINHAND, Float.MIN_VALUE);
        double bowChance = isCharged ? belowHalfHealthBowChance : aboveHalfHealthBowChance;
        if (Mth.m_216263_((RandomSource)witherMinion.m_9236_().m_213780_(), (double)0.0, (double)1.0) < bowChance) {
            int punchLevel;
            item = new ItemStack((ItemLike)Items.f_42411_);
            int powerLevel = MathHelper.getAmountWithDecimalChance((RandomSource)witherMinion.m_217043_(), (double)(powerChance * (double)scalingDifficulty));
            if (powerLevel > 0) {
                item.m_41663_(Enchantments.f_44988_, powerLevel);
            }
            if ((punchLevel = MathHelper.getAmountWithDecimalChance((RandomSource)witherMinion.m_217043_(), (double)(punchChance * (double)scalingDifficulty))) > 0) {
                item.m_41663_(Enchantments.f_44989_, punchLevel);
            }
        } else {
            int knockbackLevel;
            item = new ItemStack((ItemLike)Items.f_42425_);
            int sharpnessLevel = MathHelper.getAmountWithDecimalChance((RandomSource)witherMinion.m_217043_(), (double)(sharpnessChance * (double)scalingDifficulty));
            if (sharpnessLevel > 0) {
                item.m_41663_(Enchantments.f_44977_, sharpnessLevel);
            }
            if ((knockbackLevel = MathHelper.getAmountWithDecimalChance((RandomSource)witherMinion.m_217043_(), (double)(knockbackChance * (double)scalingDifficulty))) > 0) {
                item.m_41663_(Enchantments.f_44980_, knockbackLevel);
            }
        }
        witherMinion.m_8061_(EquipmentSlot.MAINHAND, item);
    }

    public static WitherMinion summonMinion(Level world, Vec3 pos, float scalingDifficulty, boolean isCharged) {
        WitherMinion witherMinion = new WitherMinion((EntityType<? extends AbstractSkeleton>)((EntityType)PBEntities.WITHER_MINION.get()), world);
        CompoundTag minionTags = witherMinion.getPersistentData();
        minionTags.m_128379_("mobspropertiesrandomness:processed", true);
        witherMinion.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        MinionFeature.setEquipment(witherMinion, scalingDifficulty, isCharged);
        witherMinion.m_21409_(EquipmentSlot.MAINHAND, -0.1f);
        witherMinion.m_21553_(false);
        witherMinion.m_21530_();
        double speedBonus = bonusSpeed * (double)scalingDifficulty;
        MCUtils.applyModifier((LivingEntity)witherMinion, (Attribute)Attributes.f_22279_, (UUID)Strings.AttributeModifiers.MOVEMENT_SPEED_BONUS_UUID, (String)"progressivebosses:movement_speed_bonus", (double)speedBonus, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        world.m_7967_((Entity)witherMinion);
        return witherMinion;
    }
}

