/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.progressivebosses.module.wither.ai.WitherChargeAttackGoal;
import insane96mcp.progressivebosses.module.wither.ai.WitherRangedAttackGoal;
import insane96mcp.progressivebosses.network.MessageWitherSync;
import insane96mcp.progressivebosses.network.PacketManager;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkDirection;

@Label(name="Attack", description="Makes the Wither smarter (will no longer try to stand on the player's head ...), attack faster and hit harder")
@LoadFeature(module="progressivebosses:wither")
public class AttackFeature
extends Feature {
    @Config(min=0.0)
    @Label(name="Increased Damage", description="How much experience will an Elder Guardian drop. -1 will make the Elder Guardian drop vanilla experience.")
    public static Double increasedDamage = 0.96;
    @Config(min=0.0, max=1.0)
    @Label(name="Charge attack.Chance", description="Chance every time the Wither takes damage to start a charge attack. Lower health and more damage taken increases the chance.\nThis value is the chance at 0% health and when taking 10 damage.")
    public static Double maxChargeAttackChance = 0.05;
    @Config(min=0.0, max=32.0)
    @Label(name="Charge attack.Base Damage", description="Base damage of the charge attack. Increased by 'Increased Damage' config option.")
    public static Double chargeAttackBaseDamage = 12.0;
    @Config(min=0.0, max=1.0)
    @Label(name="Barrage Attack.Chance", description="Chance (at max difficulty) every time the Wither takes damage to start a barrage attack. More damage taken increases the chance.\nThis value is the chance when taking 10 damage.")
    public static Double maxBarrageChance = 0.075;
    @Config(min=0.0)
    @Label(name="Barrage Attack.Min Duration", description="Min time (in ticks) for the duration of the barrage attack. Less health = longer barrage.")
    public static Integer minBarrageDuration = 20;
    @Config(min=0.0)
    @Label(name="Barrage Attack.Max Duration", description="Max time (in ticks) for the duration of the barrage attack. Less health = longer barrage")
    public static Integer maxBarrageDuration = 140;
    @Config(min=1.0)
    @Label(name="Skull Velocity Multiplier", description="Wither Skull Projectiles speed will be multiplied by this value. Set to 1 to not change the speed.")
    public static Double skullVelocityMultiplier = 2.5;
    @Config(min=1.0)
    @Label(name="Attack Speed.Interval", description="Every how many ticks (20 ticks = 1 seconds) the middle head will fire a projectile to the target.")
    public static Integer attackInterval = 35;
    @Config(min=0.0, max=1.0)
    @Label(name="Attack Speed.Bonus when near", description="The middle head will attack faster (up to this bonus percentage) the nearer the target is to the Wither.")
    public static Double bonusAttackSpeedWhenNear = 0.6;

    public AttackFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        this.witherSkullSpeed(event.getEntity());
        this.setWitherAI(event.getEntity());
    }

    private void witherSkullSpeed(Entity entity) {
        WitherSkull witherSkullEntity;
        block5: {
            block4: {
                if (!(entity instanceof WitherSkull)) break block4;
                witherSkullEntity = (WitherSkull)entity;
                if (this.isEnabled()) break block5;
            }
            return;
        }
        if (Math.abs(witherSkullEntity.f_36813_) > 10.0 || Math.abs(witherSkullEntity.f_36814_) > 10.0 || Math.abs(witherSkullEntity.f_36815_) > 10.0) {
            entity.m_6074_();
            return;
        }
        witherSkullEntity.f_36813_ *= skullVelocityMultiplier.doubleValue();
        witherSkullEntity.f_36814_ *= skullVelocityMultiplier.doubleValue();
        witherSkullEntity.f_36815_ *= skullVelocityMultiplier.doubleValue();
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        if (!(this.isEnabled() && event.getEntity().m_6084_() && (livingEntity = event.getEntity()) instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)livingEntity;
        this.tickCharge(wither);
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        this.chargeUnseen(wither);
    }

    private void tickCharge(WitherBoss wither) {
        if (maxChargeAttackChance == 0.0) {
            return;
        }
        byte chargeTick = wither.getPersistentData().m_128445_("progressivebosses:charge_attack");
        if (chargeTick > 0) {
            if (wither.f_19797_ % 10 == 0) {
                float missingHealth = wither.m_21233_() - wither.m_21223_();
                wither.m_21153_(wither.m_21223_() + missingHealth * 0.005f);
            }
            wither.getPersistentData().m_128344_("progressivebosses:charge_attack", (byte)(chargeTick - 1));
        }
    }

    private void chargeUnseen(WitherBoss wither) {
        CompoundTag witherTags = wither.getPersistentData();
        if (witherTags.m_128445_("progressivebosses:charge_attack") <= 0 && wither.f_19797_ % 20 == 0) {
            this.doCharge(wither, (float)witherTags.m_128451_("progressivebosses:unseen_player_ticks") / 20.0f);
        }
    }

    @SubscribeEvent
    public void onDamageDealt(LivingHurtEvent event) {
        Entity entity;
        if (event.getEntity().m_9236_().f_46443_ || !this.isEnabled() || increasedDamage == 0.0 || !((entity = event.getSource().m_7639_()) instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        event.setAmount(event.getAmount() * (float)(1.0 + increasedDamage * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)wither)));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDamaged(LivingHurtEvent event) {
        LivingEntity livingEntity;
        if (event.getEntity().m_9236_().f_46443_ || !this.isEnabled() || !event.getEntity().m_6084_() || !((livingEntity = event.getEntity()) instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)livingEntity;
        this.doBarrage(wither, event.getAmount());
        this.doCharge(wither, event.getAmount());
    }

    private void doBarrage(WitherBoss wither, float damageTaken) {
        if (maxBarrageChance == 0.0) {
            return;
        }
        CompoundTag witherTags = wither.getPersistentData();
        double missingHealthPerc = 1.0 - (double)(wither.m_21223_() / wither.m_21233_());
        double chance = maxBarrageChance * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)wither);
        chance *= (double)(damageTaken / 10.0f);
        double r = wither.m_217043_().m_188500_();
        if (r < chance) {
            int duration = (int)((double)(maxBarrageDuration - minBarrageDuration) * missingHealthPerc + (double)minBarrageDuration.intValue());
            witherTags.m_128405_("progressivebosses:barrage_attack", duration);
        }
    }

    private void doCharge(WitherBoss wither, float damageTaken) {
        if (maxChargeAttackChance == 0.0 || wither.getPersistentData().m_128445_("progressivebosses:charge_attack") > 0) {
            return;
        }
        double missingHealthPerc = 1.0 - (double)(wither.m_21223_() / wither.m_21233_());
        double chance = maxChargeAttackChance * missingHealthPerc;
        chance *= (double)(damageTaken / 10.0f);
        double r = wither.m_217043_().m_188500_();
        if (r < chance) {
            AttackFeature.initCharging(wither);
        }
    }

    public void setWitherAI(Entity entity) {
        if (entity.m_9236_().f_46443_ || !this.isEnabled() || !(entity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        ArrayList<Goal> toRemove = new ArrayList<Goal>();
        wither.f_21345_.f_25345_.forEach(goal -> {
            if (goal.m_26015_() instanceof RangedAttackGoal) {
                toRemove.add(goal.m_26015_());
            }
            if (goal.m_26015_() instanceof WitherBoss.WitherDoNothingGoal) {
                toRemove.add(goal.m_26015_());
            }
        });
        toRemove.forEach(arg_0 -> ((GoalSelector)wither.f_21345_).m_25363_(arg_0));
        wither.f_21345_.m_25352_(1, (Goal)new WitherChargeAttackGoal(wither));
        wither.f_21345_.m_25352_(2, (Goal)new WitherRangedAttackGoal(wither, attackInterval, 24.0f, bonusAttackSpeedWhenNear));
        MCUtils.applyModifier((LivingEntity)wither, (Attribute)Attributes.f_22277_, (UUID)UUID.randomUUID(), (String)"Wither Sexy Glasses", (double)56.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
    }

    public static void initCharging(WitherBoss wither) {
        wither.getPersistentData().m_128344_("progressivebosses:charge_attack", (byte)90);
        MessageWitherSync msg = new MessageWitherSync(wither.m_19879_(), 90);
        for (Player player : wither.m_9236_().m_6907_()) {
            PacketManager.CHANNEL.sendTo((Object)msg, ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void stopCharging(WitherBoss wither) {
        wither.getPersistentData().m_128344_("progressivebosses:charge_attack", (byte)0);
        MessageWitherSync msg = new MessageWitherSync(wither.m_19879_(), 0);
        for (Player player : wither.m_9236_().m_6907_()) {
            PacketManager.CHANNEL.sendTo((Object)msg, ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static class Consts {
        public static final int CHARGE_ATTACK_TICK_START = 90;
        public static final int CHARGE_ATTACK_TICK_CHARGE = 30;
    }
}

